<?php
/*
 * Este arquivo lê os cliente da agência no banco de dados e envia o resultado por meio de JSON.
 */

require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

try{
    $sistema->usuario->filtro_clientes['contatos'] = isset($_POST['contatos']) ? $_POST['contatos'] : "";
    $sistema->usuario->filtro_clientes['ligacoes'] = isset($_POST['ligacoes']) ? $_POST['ligacoes'] : "";
    $sistema->usuario->filtro_clientes['whatsapp'] = isset($_POST['whatsapp']) ? $_POST['whatsapp'] : "";
    $sistema->usuario->filtro_clientes['data'] = $_POST['data-leads'];
    $sistema->usuario->filtro_clientes['datainicial'] = $_POST['datainicial'];
    $sistema->usuario->filtro_clientes['datafinal'] = $_POST['datafinal'];
    $sistema->usuario->filtro_clientes['ligacoesnaoatendidas'] = $_POST['ligacoesnaoatendidas'];
    $sistema->usuario->filtro_clientes['seguimento'] = $_POST['slqSeguimento'];
	$params = array();
	$sql = "SELECT * FROM TBL_CLIENTE";
	$adicoes = 0;

	// Faz a consulta no banco
	switch($_POST['atividade']){
		case "ativos":
			$sql .= " WHERE NU_CLIENTE_ATIVO = 1";
			$adicoes++;
			break;
		case "inativos":
			$sql .= " WHERE NU_CLIENTE_ATIVO = 0";
			$adicoes++;
			break;
		case "nao-frequentes":
			$time = date('Y-m-d H:i:s', strtotime("-" . Usuario_Win7::TEMPO_ATIVIDADE ." days"));
			$params[':data'] = $time;
			$sql .= " WHERE NU_CLIENTE_ATIVO = 1 AND NU_ACESSOS_SISTEMA_DATA <= :data";
			$adicoes++;
			break;
		case "frequentes":
			$time = date('Y-m-d H:i:s', strtotime("-" . Usuario_Win7::TEMPO_ATIVIDADE ." days"));
			$params[':data'] = $time;
			$sql .= " WHERE NU_CLIENTE_ATIVO = 0 AND NU_ACESSOS_SISTEMA_DATA > :data";
			$adicoes++;
			break;
		default:
			break;
	}

	switch($_POST['win7fone']){
		case "possui":
			if($adicoes > 0){
				$sql .= " AND NU_POSSUI_WIN7FONE = 1";
			}
			else{
				$sql .= " WHERE NU_POSSUI_WIN7FONE = 1";
			}
			$adicoes++;
			break;
		case "nao-possui":
			if($adicoes > 0){
				$sql .= " AND NU_POSSUI_WIN7FONE = 0";
			}
			else{
				$sql .= " WHERE NU_POSSUI_WIN7FONE = 0";
			}
			$adicoes++;
			break;
		case "todos":
			// if($adicoes > 0){
			// 	$sql .= " AND NU_POSSUI_WIN7FONE = 0 AND NU_POSSUI_WIN7FONE = 1";
			// }
			// else{
			// 	$sql .= " WHERE NU_POSSUI_WIN7FONE = 0 AND NU_POSSUI_WIN7FONE = 1";
			// }
			// $adicoes++;
			break;
	}

	if($_POST['slqSeguimento']){
        
        if ($_POST['slqSeguimento'] !== 'todos') {
            if($adicoes > 0){
                $sql .= " AND TXT_SEGUIMENTO = ".$_POST['slqSeguimento'];
            }
            else{
                $sql .= " WHERE TXT_SEGUIMENTO = ".$_POST['slqSeguimento'];
            }
            $adicoes++;
        }
        
	}

	$clientes = $sistema->bd->executar($sql, $params, Banco_Dados::FETCH_ALL);

	// Monta os dados que serão enviado via JSON
	$resultado = array();
	$possiveis_datas = array("hoje", "ontem", "essa-semana", "semana-passada", "esse-mes", "mes-passado", "personalizado");
	if((isset($_POST['ligacoes']) && $_POST['ligacoes'] == "s") || (isset($_POST['ligacoesnaoatendidas']) && $_POST['ligacoesnaoatendidas'] == "s")){
        switch($_POST['data-leads']){
            case "hoje":
                $datahj = date('Y-m-d', time());
                $str_ligacoes = "DATE(DT_DIA) = '$datahj'";
                break;
            case "ontem":
                $dataOntem = date('Y-m-d', time() - (24 * 3600));
                $str_ligacoes = "DATE(DT_DIA) = '$dataOntem'";
                break;
            case "essa-semana":
                $dtInicial = date('Y-m-d', strtotime('last monday', strtotime('tomorrow')));
                $dtFinal = date('Y-m-d', time());
                $str_ligacoes = "DATE(DT_DIA) BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case "semana-passada":
                $previous_week = strtotime("-1 week +1 day");
                $start_week = strtotime("last sunday midnight", $previous_week);
                $end_week = strtotime("next saturday", $start_week);
                $start_week = date("Y-m-d", $start_week);
                $end_week = date("Y-m-d", $end_week);
                $dtInicial = $start_week;
                $dtFinal = $end_week;
                $str_ligacoes = "DATE(DT_DIA) BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case "esse-mes":
                $dataMesAtual = date('m', time());
                $dataAnoAtual = date('Y', time());
                $str_ligacoes = "MONTH(DT_DIA) = '$dataMesAtual' AND YEAR(DT_DIA) = '$dataAnoAtual'";
                break;
            case "mes-passado":
                $passado = strtotime("-1 month");
                $dataMesPassado = date('m', $passado);
                $dataAnoAtual = date('Y', $passado);
                $str_ligacoes = "MONTH(DT_DIA) = '$dataMesPassado' AND YEAR(DT_DIA) = '$dataAnoAtual'";
                break;
            case "personalizado":
                $dtInicial = $_POST['datainicial'];
                $dtFinal   = $_POST['datafinal'];
                $dtInicial = str_replace(array(
                    '/'
                ), '-', $dtInicial);
                $dtInicial = new DateTime($dtInicial);
                $dtInicial = $dtInicial->format('Y-m-d');
                $dtFinal   = str_replace(array(
                    '/'
                ), '-', $dtFinal);
                $dtFinal   = new DateTime($dtFinal);
                $dtFinal   = $dtFinal->format('Y-m-d');
                $str_ligacoes       = "DATE(DT_DIA) BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            default:
                break;
        }
    }
    if(isset($_POST['whatsapp']) && $_POST['whatsapp'] == "s"){
        switch($_POST['data-leads']){
            case "hoje":
                $datahj = date('Y-m-d', time());
                $str_whatsapp = "DATE(DT_ATUAL) = '$datahj'";
                break;
            case "ontem":
                $dataOntem = date('Y-m-d', time() - (24 * 3600));
                $str_whatsapp = "DATE(DT_ATUAL) = '$dataOntem'";
                break;
            case "essa-semana":
                $dtInicial = date('Y-m-d', strtotime('last monday', strtotime('tomorrow')));
                $dtFinal = date('Y-m-d', time());
                $str_whatsapp = "DATE(DT_ATUAL) BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case "semana-passada":
                $previous_week = strtotime("-1 week +1 day");
                $start_week = strtotime("last sunday midnight", $previous_week);
                $end_week = strtotime("next saturday", $start_week);
                $start_week = date("Y-m-d", $start_week);
                $end_week = date("Y-m-d", $end_week);
                $dtInicial = $start_week;
                $dtFinal = $end_week;
                $str_whatsapp = "DATE(DT_ATUAL) BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case "esse-mes":
                $dataMesAtual = date('m', time());
                $dataAnoAtual = date('Y', time());
                $str_whatsapp = "MONTH(DT_ATUAL) = '$dataMesAtual' AND YEAR(DT_ATUAL) = '$dataAnoAtual'";
                break;
            case "mes-passado":
                $passado = strtotime("-1 month");
                $dataMesPassado = date('m', $passado);
                $dataAnoAtual = date('Y', $passado);
                $str_whatsapp = "MONTH(DT_ATUAL) = '$dataMesPassado' AND YEAR(DT_ATUAL) = '$dataAnoAtual'";
                break;
            case "personalizado":
                $dtInicial = $_POST['datainicial'];
                $dtFinal   = $_POST['datafinal'];
                $dtInicial = str_replace(array(
                    '/'
                ), '-', $dtInicial);
                $dtInicial = new DateTime($dtInicial);
                $dtInicial = $dtInicial->format('Y-m-d');
                $dtFinal   = str_replace(array(
                    '/'
                ), '-', $dtFinal);
                $dtFinal   = new DateTime($dtFinal);
                $dtFinal   = $dtFinal->format('Y-m-d');
                $str_whatsapp       = "DATE(DT_ATUAL) BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            default:
                break;
        }
    }

    if(isset($_POST['contatos']) && $_POST['contatos'] == "s"){
        switch($_POST['data-leads']){
            case "hoje":
                $datahj = date('Y-m-d', time());
                $str_contatos = "DATE(DT_ATUAL) = '$datahj'";
                break;
            case "ontem":
                $dataOntem = date('Y-m-d', time() - (24 * 3600));
                $str_contatos = "DATE(DT_ATUAL) = '$dataOntem'";
                break;
            case "essa-semana":
                $dtInicial = date('Y-m-d', strtotime('last monday', strtotime('tomorrow')));
                $dtFinal = date('Y-m-d', time());
                $str_contatos = "DATE(DT_ATUAL) BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case "semana-passada":
                $previous_week = strtotime("-1 week +1 day");
                $start_week = strtotime("last sunday midnight", $previous_week);
                $end_week = strtotime("next saturday", $start_week);
                $start_week = date("Y-m-d", $start_week);
                $end_week = date("Y-m-d", $end_week);
                $dtInicial = $start_week;
                $dtFinal = $end_week;
                $str_contatos = "DATE(DT_ATUAL) BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case "esse-mes":
                $dataMesAtual = date('m', time());
                $dataAnoAtual = date('Y', time());
                $str_contatos = "MONTH(DT_ATUAL) = '$dataMesAtual' AND YEAR(DT_ATUAL) = '$dataAnoAtual'";
                break;
            case "mes-passado":
                $passado = strtotime("-1 month");
                $dataMesPassado = date('m', $passado);
                $dataAnoAtual = date('Y', $passado);
                $str_contatos = "MONTH(DT_ATUAL) = '$dataMesPassado' AND YEAR(DT_ATUAL) = '$dataAnoAtual'";
                break;
            case "personalizado":
                $dtInicial = $_POST['datainicial'];
                $dtFinal   = $_POST['datafinal'];
                $dtInicial = str_replace(array(
                    '/'
                ), '-', $dtInicial);
                $dtInicial = new DateTime($dtInicial);
                $dtInicial = $dtInicial->format('Y-m-d');
                $dtFinal   = str_replace(array(
                    '/'
                ), '-', $dtFinal);
                $dtFinal   = new DateTime($dtFinal);
                $dtFinal   = $dtFinal->format('Y-m-d');
                $str_contatos       = "DATE(DT_ATUAL) BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            default:
                break;
        }
    }

	foreach($clientes as $linha){
        if(in_array($_POST['data-leads'], $possiveis_datas) && isset($_POST['ligacoes']) && $_POST['ligacoes'] == "s"){
            // if($linha['NU_POSSUI_WIN7FONE'] == "0" || $linha['NU_CLIENTE_ATIVO'] == "0"){
            // if($linha['NU_CLIENTE_ATIVO'] == "0"){
			// 	continue;
			// }
			// else{
				$sql = "SELECT (SELECT sum(NU_LIGACOES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = ".$linha['ID_CLIENTE']." AND ".$str_ligacoes.") as ligacoes";
				$resultado2 = $sistema->bd->executar($sql, array(), Banco_Dados::FETCH);
				$ligacoes = intval($resultado2['ligacoes']);
				if($ligacoes > 0){
					continue;
				}
			// }
		}

        if(in_array($_POST['data-leads'], $possiveis_datas) && isset($_POST['ligacoesnaoatendidas']) && $_POST['ligacoesnaoatendidas'] == "s"){
            // if($linha['NU_POSSUI_WIN7FONE'] == "0" || $linha['NU_CLIENTE_ATIVO'] == "0"){
            // if($linha['NU_CLIENTE_ATIVO'] == "0"){
            //     continue;
            // }
            // else{
                $sql = "SELECT (SELECT sum(NU_LIGACOES_NAO_ATENDIDAS) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = ".$linha['ID_CLIENTE']." AND ".$str_ligacoes.") as ligacoes";
                $resultado2 = $sistema->bd->executar($sql, array(), Banco_Dados::FETCH);
                $ligacoes = intval($resultado2['ligacoes']);
                if($ligacoes == 0){
                    continue;
                }
            // }
        }

        if(in_array($_POST['data-leads'], $possiveis_datas) && isset($_POST['contatos']) && $_POST['contatos'] == "s"){
			if($linha['NU_CLIENTE_ATIVO'] == "0"){
				continue;
			}
			else{
				$sql = "SELECT (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = ".$linha['ID_CLIENTE']." AND TXT_LEADTIPO = 'Formulário' AND ".$str_contatos.") as forms";
				$resultado2 = $sistema->bd->executar($sql, array(), Banco_Dados::FETCH);
				$contatos = intval($resultado2['forms']);
				if ($contatos > 0){
					continue;
				}
			}
		}

        if(in_array($_POST['data-leads'], $possiveis_datas) && isset($_POST['whatsapp']) && $_POST['whatsapp'] == "s"){
			if($linha['NU_CLIENTE_ATIVO'] == "0"){
				continue;
			}
			else{

				$sql = "SELECT (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = ".$linha['ID_CLIENTE']." AND TXT_LEADTIPO = 'WhatsApp' AND ".$str_whatsapp.") as whatsapp";
				$resultado2 = $sistema->bd->executar($sql, array(), Banco_Dados::FETCH);
				$whatsapp = intval($resultado2['whatsapp']);
				if ($whatsapp > 0){
					continue;
				}
			}
		}

		$adwords = $linha['NU_ADWORDS'] == "" ? "--" : $linha['NU_ADWORDS'];
		
		$data_alteracao = $linha['NU_ACESSOS_SISTEMA_DATA'];
		if(Utilitarios::data_padrao_valida($data_alteracao)){
			$data_alteracao = strtotime($data_alteracao);
			$data_alteracao = date('d/m/Y H:i:s', $data_alteracao);
		}
		else{
			$data_alteracao = "Nunca";
		}
		
		$possuiwin7phone = !empty($linha['NU_VONOID']);

		// Adiciona o cliente na array que será enviada por meio de JSON
		$resultado[] = array(
			"id" => $linha['ID_CLIENTE'],
			"nome" => $linha['TXT_NOME_EMPRESA'],
			"login" => $linha['TXT_LOGIN'],
			"adwords" => $adwords,
			"ramo" => $linha['TXT_RAMO'],
			"acesso" => $data_alteracao,
			"consultoria" => $linha['TXT_CONSULTORIA'] == "0" ? "Não" : "Sim",
			"email" => empty($linha['TXT_EMAIL']) ? "--" : $linha['TXT_EMAIL'],
			"telefone" => empty($linha['NU_TELEFONE_1']) ? "--" : $linha['NU_TELEFONE_1'],
			"whatsapp" => $linha['NU_WHATSAPP'] == "0" ? "Inativo" : "Ativo",
			"ativo" =>  $linha['NU_CLIENTE_ATIVO'] == "0" ? "Não" : "Sim",
			"possuiwin7phone" => $linha['NU_POSSUI_WIN7FONE'] == "0" ? "Não" : "Sim"
		);
	}

	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>