<?php
require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_envio_email == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	$email = $sistema->obter_email($_POST['id']);

	if($sistema->bd->quantidade() == 0){ // Nenhum dado foi encontrado no banco, então a ID é inválida
		echo "-2ID inválida!";
		exit;
	}

	$status = $email['NU_STATUS'];

	if($status != 2){
		echo "-2Não foi possível reenviar e-mail!";
		exit;
	}

	$sistema->reenviar_email($_POST['id']);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>