<?php
require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

if (!$sistema->usuario->super_adm_adm) {
    echo "-2Permissão Insuficiente";
    exit;
}

try {
    $leads = json_decode($_POST['leads']);

    if (json_last_error() != JSON_ERROR_NONE) {
        echo "-2Requisição inválida";
        exit;
    }

    foreach ($leads as $lead) {
        $valor = trim($lead[3]);
        $email = strpos($valor, '@') !== false ? 1 : 0;
        if (strlen($valor) < 8) {
            echo "-2Os leads devem possuir no mínimo 8 caracteres";
            exit;
        }
        if (strpos($valor, ' ') !== false) {
            echo "-2Os leads não podem possuir espaços";
            exit;
        }
        if(!$email && !ctype_digit($valor)){
            echo "-2Os telefones devem possuir apenas números";
            exit;
        }
    }

    $counter = 0;
    foreach ($leads as $lead) {
        $sequencia = intval($lead[0]);
        $id        = $lead[1];
        $deletar   = $lead[2] == "1";
        $valor     = trim($lead[3]);
        $email     = strpos($valor, '@') !== false ? 1 : 0;

        if ($id == "-1") {
            if (!$deletar) {
                $sistema->bd->executar("INSERT INTO falso_lead (valor, email) VALUES (:valor, :email)", [
                    ":valor" => $valor,
                    ":email" => $email,
                ]);
                $lastID             = $sistema->bd->ultima_id();
                $leads[$counter][1] = $lastID;
            }
        } else {
            if ($deletar) {
                $sistema->bd->executar("DELETE FROM falso_lead WHERE id = :id", [
                    ":id" => $id,
                ]);
            } else {
                $sistema->bd->executar("UPDATE falso_lead SET valor = :valor, email = :email WHERE id = :id", [
                    ":valor" => $valor,
                    ":email" => $email,
                    ":id"    => $id,
                ]);
            }
        }

        $counter++;
    }

    echo json_encode_alt($leads);
} catch (Exception $e) {
    echo "-2Houve um erro com o servidor";
    exit;
}
?>