<?php 
/*
 * Este arquivo salva um agendamento do google apps.
 */

require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_gsuite == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!Utilitarios::cpf_cnpj_valido($_POST['cpf'])){
	echo "-2CPF/CNPJ Inválido";
	exit;
}

try{
	// Obtém todos os dados que serão salvos no banco de dados
	$nome = $_POST['nome'];
	$email = trim($_POST['email']);
	$telefone = $_POST['telefone'];
	$cpf_cnpj = preg_replace( '/[^0-9]/is', '', $_POST['cpf']);
	$quantidade = $_POST['quantidade'];
	$valor = str_replace(".","",$_POST['valor']);
	$valor = str_replace(",",".",$valor);
	$valor = floatval($valor);
	$valor = number_format($valor,2);
	$valor = preg_replace("/[^0-9]/", "", $valor);
	$tipo = $_POST['tipo'];
	$vencimento = $_POST['vencimento'];
	$ativado = ($_POST['ativado'] == "Sim" ? 1 : 0);
	$anotacoes = $_POST['anotacoes'];
	$moeda = $_POST['moeda'];
	$plano = $_POST['plano'];
	$taxa30mensal = ($_POST['taxa30mensal'] == "Sim" ? 1 : 0);

	$sistema->bd->executar('UPDATE TBL_GOOGLEAPPS SET TXT_NOME = :nome, TXT_TELEFONE = :telefone, TXT_EMAIL = :email, NU_CPF_CNPJ = :cpf, NU_QUANTIDADE = :quantidade, NU_VALOR = :valor, TXT_TIPO = :tipo, DT_VENCIMENTO = :vencimento, ATIVADO = :ativado, TXT_ANOTACOES = :anotacoes, TXT_MOEDA = :moeda, TXT_SKU = :plano, NU_TAXA_TRINTA_MENSAL = :taxatrintamensal WHERE ID = :id',
	array(
		":nome" => $nome,
		":telefone" => $telefone,
		":email" => $email,
		":cpf" => $cpf_cnpj,
		":quantidade" => $quantidade,
		":valor" => $valor,
		":tipo" => $tipo,
		":vencimento" => $vencimento,
		":id" => $_POST['id'],
		":ativado" => $ativado,
		":anotacoes" => $anotacoes,
		":moeda" => $moeda,
		":plano" => $plano,
		":taxatrintamensal" => $taxa30mensal
	));

	$sistema->logs->adicionar_log_alteracao_agendamento_gsuite($nome, $_POST['id']);

	$status = $ativado == 1 ? "Ativo" : "Inativo";
	$nome = $nome;
	if(strlen($nome) > 30){
		$nome = mb_substr($nome, 0, 30);
		$nome .= "...";
	}

	if ($moeda == "real") {
		$valor = Mascara::converter_para_real($valor);
	}else{
		$valor = Mascara::converter_para_dolar($valor);
	}

	$resultado = array(
		'id' => $_POST['id'],
		'nome' => $nome,
		'email' => $email,
		'cpf_cnpj' => Mascara::mascara_cpf_cnpj($cpf_cnpj),
		'quantidade' => $quantidade,
		'valor' => $valor,
		'tipo' => $tipo,
		'vencimento' => $vencimento,
		'telefone' => $telefone,
		'status' => $status,
		'pesquisa' => $_POST['nome']
	);

	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>