<?php
/*
 * Este arquivo salva os dados do sistema de indicações do cliente da agência.
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_indicacoes_geral == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // Verifica se a ID é um número
	echo "-2ID inválida!";
	exit;
}

if(!ctype_digit($_POST['tiposistema'])){ // Verifica se a ID é um número
	echo "-2Tipo de Sistema Inválido!";
	exit;
}

$tipos_sistema = count($sistema->layout->tipos_sistema_indicacao);
if(intval($_POST['tiposistema']) >= $tipos_sistema){
	echo "-2Tipo de Sistema Inválido!";
	exit;
}

// Garante que o domínio não seja vazio
if(empty($_POST['dominio'])){
	echo "-2Insira um domínio";
	exit;
}

// Garante que sessão não seja vazia
if(empty($_POST['sessao'])){
	echo "-2Insira uma sessão";
	exit;
}

// Verifica se a cor 1 é um hex válido
if(!Utilitarios::hex_valido($_POST['cor1'])){
	echo "-2Cor 1 inválida!";
	exit;
}

// Verifica se a cor 2 é um hex válido
if(!Utilitarios::hex_valido($_POST['cor2'])){
	echo "-2Cor 2 inválida!";
	exit;
}

// Verifica se a cor 3 é um hex válido
if(!Utilitarios::hex_valido($_POST['cor3'])){
	echo "-2Cor 3 inválida!";
	exit;
}

// Verifica se a cor 4 é um hex válido
if(!Utilitarios::hex_valido($_POST['cor4'])){
	echo "-2Cor 4 inválida!";
	exit;
}

// Verifica se a cor 5 é um hex válido
if(!Utilitarios::hex_valido($_POST['cor5'])){
	echo "-2Cor 5 inválida!";
	exit;
}

// Verifica se a lista de bônus é válida
if(!Utilitarios::bonus_valido($_POST['bonus'])){
	echo "-2Bônus inválido!";
	exit;
}

// Garante que o nome de exibição tenha sido inserido
if(empty($_POST['nome'])){
	echo "-2Insira um nome de exibição!";
	exit;
}

// Garante que a URL do favicon tenha sido inserida
if(empty($_POST['favicon'])){
	echo "-2Insira a URL do favicon!";
	exit;
}

// Garante que a URL do logo tenha sido inserida
if(empty($_POST['logo'])){
	echo "-2Insira a URL da logo!";
	exit;
}

// Garante que o telefone tenha sido informado
if(empty($_POST['telefone'])){
	echo "-2Insira um telefone!";
	exit;
}

// Garante que o email de avisos seja válido CASO tenha sido inserido
if(!empty($_POST['email']) & !Utilitarios::email_valido($_POST['email'])){
	echo "-2Insira um email válido!";
	exit;
}

$ativado = $_POST['ativado'] == "Sim" ? 1 : 0; // verifica se o sistema está ativado
$adm = $_POST['administrador'] == "Sim" ? 1 : 0; // verifica se o usuário deve ser super adm
$ad_contato = $_POST['adicionar-contato'] == "Sim" ? 1 : 0;
$aceitar_termos = $_POST['ativar-termos'] == "Sim" ? 1 : 0;
$proibir_cpf = $_POST['proibir-cpf'] == "Sim" ? 1 : 0;
$comissao_fixa = $_POST['comissaofixa'] == "Sim" ? 1 : 0;
$distribuir_comissoes = $_POST['distribuir-comissao'] == "Sim" ? 1 : 0;
$upline = $_POST['upline'] == "Sim" ? 1 : 0;
$downlines = $_POST['downlines'] == "Sim" ? 1 : 0;
$permitir_cnpj1 = $_POST['permitir-cnpj1'] == "Sim" ? 1 : 0;
$permitir_cnpj2 = $_POST['permitir-cnpj2'] == "Sim" ? 1 : 0;
$permitir_transferencia = $_POST['permitir-transferencia'] == "Sim" ? 1 : 0;
$ativar_inscricoes = $_POST['ativar-inscricoes'] == "Sim" ? 1 : 0;
$flag_pontos = $_POST['flag-pontos'] == "Sim" ? 1 : 0;
$tipo_sistema = $_POST['tiposistema'];
$ajuste = $_POST['coeficiente-ajuste'];
$comissao_multipla = $_POST['comissaomultipla'] == "Sim";
$ativar_recorrencia = $_POST['ativarrecorrencia'] == "Sim";
$comissao_multipla_bd = $_POST['comissaomultipla'] == "Sim" ? 1 : 0;
$fidelidade = $_POST['comissao-fidelidade'];
$comissao_cadastro = $_POST['comissao-cadastro'];
$cadastro_indicado = $_POST['cadastro-indicado'] == "Sim" ? 1 : 0;

$link_site_menu = $_POST['txtSiteMenu'];
$link_site_menu_label = $_POST['txtSiteMenuLabel'];
$txt_cpf_cnpj_alternativo = $_POST['txtCpfCnpjAlternativo'];

$simbolo_dinheiro = $_POST['slqDinheiroSimbolo'];
$mascara_dinheiro = $_POST['slqDinheiroMascara'];

if($comissao_multipla == true){
	if(!ctype_digit($_POST['qtdComissoes'])){
		echo "-2Dados inválidos!";
		exit;
	}
	$quantidade_comissoes = intval($_POST['qtdComissoes']);
	if($quantidade_comissoes <= 0){
		echo "-2Não há comissões adicionadas!";
		exit;
	}
}

/* Trata o POST com o numero do WhatsApp, limpa os caracteres especiais */
if ($_POST['txtNumeroWhatsAppLinkRodape'] !== '') {
	$txt_numero_whatsapp_link_rodape = str_replace([" ", "-", "(", ")", "+"], '', $_POST['txtNumeroWhatsAppLinkRodape']);
} else {
	$txt_numero_whatsapp_link_rodape = null;
}

try{
	$sistema->bd->executar("SELECT * FROM TBL_CLI_DADOS WHERE ID_FK = :id", array('id' => $_POST['id']), Banco_Dados::FETCH);
	$row_count = $sistema->bd->quantidade();

	if($row_count > 0){ // Caso já haja algum registro do sistema de indicações, só atualiza o registro existente
		if($comissao_multipla == true){
			$sql = 'UPDATE TBL_CLI_DADOS SET TXT_HOST = :dominio, TXT_SESSION = :sessao, NU_ATIVADO = :ativado, TXT_COR1 = :cor1, TXT_COR2 = :cor2, TXT_COR3 = :cor3, TXT_COR4 = :cor4, TXT_COR5 = :cor5, TXT_NOME = :nome, TXT_EMAIL = :email, TXT_LOGO = :logo, TXT_FAVICON = :favicon, TXT_TELEFONE = :telefone, TXT_CONTATO = :contato, NU_SUPERADM = :adm, TXT_TIPO_SISTEMA_INDICACAO = :tipo, NU_ADICIONAR_CONTATO = :adcontato, NU_ATIVAR_TERMOS = :aceitartermos, TXT_LINK_TERMOS = :linktermos, NU_PROIBIR_CPF = :proibircpf, NU_DISTRIBUIR_COMISSOES = :distribuircomissoes, NU_DOWNLINES = :downlines, NU_UPLINE = :upline, NU_PERM_CNPJ_INDICADO = :permitircnpj1, NU_PERM_CNPJ_INDICADOR = :permitircnpj2, NU_PERM_TRANSFERENCIAS = :permitirtransferencia, TXT_IMAGEM_SOCIAL = :imgsocial, NU_PERMITIR_INSCRICOES = :ativarinscricoes, NU_FLAG_PONTOS = :flagpontos, NU_COMISSAO_MULTIPLA = :comissaomultipla, NU_PERM_RECORRENCIA = :ativarrecorrencia, NU_PERM_CADASTRO_INDICADO = :cadastroindicado, NU_COMISSAO_CADASTRO = :comissaocadastro, NU_COMISSAO_FIXA = :comissaofixa, TXT_AJUSTE = :ajuste, TXT_LINK_SITE_MENU = :linksitemenu, TXT_LABEL_SITE_MENU = :linksitemenulabel, TXT_CPFCNPJ_ALTERNATIVO = :cpfcnpjalternativo, NU_WHATSAPP_RODAPE = :txtnumerowhatsapplinkrodape, TXT_DINHEIRO_SIMBOLO = :simbolodinheiro, TXT_DINHEIRO_MASCARA = :mascaradinheiro WHERE ID_FK = :id';
			$parametros = array(
				':id' => $_POST['id'],
				':sessao' => $_POST['sessao'],
				':dominio' => $_POST['dominio'],
				':ativado' => $ativado,
				':cor1' => $_POST['cor1'],
				':cor2' => $_POST['cor2'],
				':cor3' => $_POST['cor3'],
				':cor4' => $_POST['cor4'],
				':cor5' => $_POST['cor5'],
				':nome' => $_POST['nome'],
				':email' => $_POST['email'],
				':favicon' => $_POST['favicon'],
				':logo' => $_POST['logo'],
				':telefone' => $_POST['telefone'],
				':contato' => $_POST['contato'],
				':adm' => $adm,
				':tipo' => $tipo_sistema,
				':adcontato' => $ad_contato,
				':aceitartermos' => $aceitar_termos,
				':linktermos' => $_POST['termos-uso'],
				':proibircpf' => $proibir_cpf,
				':distribuircomissoes' => $distribuir_comissoes,
				':upline' => $upline,
				':downlines' => $downlines,
				':permitircnpj1' => $permitir_cnpj1,
				':permitircnpj2' => $permitir_cnpj2,
				':permitirtransferencia' => $permitir_transferencia,
				':imgsocial' => $_POST['imagem-social'],
				':ativarinscricoes' => $ativar_inscricoes,
				':flagpontos' => $flag_pontos,
				':comissaomultipla' => $comissao_multipla_bd,
				':ativarrecorrencia' => $ativar_recorrencia,
				':cadastroindicado' => $cadastro_indicado,
				':comissaocadastro' => $comissao_cadastro,
				':comissaofixa' => $comissao_fixa,
				':ajuste' => $ajuste,
				':linksitemenu' => $link_site_menu,
				':linksitemenulabel' => $link_site_menu_label,
				':cpfcnpjalternativo' => $txt_cpf_cnpj_alternativo,
				':txtnumerowhatsapplinkrodape' => $txt_numero_whatsapp_link_rodape,
				':simbolodinheiro' => $simbolo_dinheiro,
				':mascaradinheiro' => $mascara_dinheiro
			);
		}
		else{
			$sql = 'UPDATE TBL_CLI_DADOS SET TXT_HOST = :dominio, TXT_SESSION = :sessao, NU_ATIVADO = :ativado, TXT_COR1 = :cor1, TXT_COR2 = :cor2, TXT_COR3 = :cor3, TXT_COR4 = :cor4, TXT_COR5 = :cor5, TXT_NOME = :nome, TXT_EMAIL = :email, TXT_LOGO = :logo, TXT_FAVICON = :favicon, TXT_TELEFONE = :telefone, TXT_CONTATO = :contato, TXT_BONUS = :bonus, NU_SUPERADM = :adm, TXT_TIPO_SISTEMA_INDICACAO = :tipo, NU_ADICIONAR_CONTATO = :adcontato, NU_ATIVAR_TERMOS = :aceitartermos, TXT_LINK_TERMOS = :linktermos, NU_COMISSAO_AGENCIA = :comissao, NU_PROIBIR_CPF = :proibircpf, NU_DISTRIBUIR_COMISSOES = :distribuircomissoes, NU_DOWNLINES = :downlines, NU_UPLINE = :upline, NU_PERM_CNPJ_INDICADO = :permitircnpj1, NU_PERM_CNPJ_INDICADOR = :permitircnpj2, NU_PERM_TRANSFERENCIAS = :permitirtransferencia, TXT_IMAGEM_SOCIAL = :imgsocial, NU_PERMITIR_INSCRICOES = :ativarinscricoes, NU_COMISSAO_FIXA = :comissaofixa, NU_FLAG_PONTOS = :flagpontos, TXT_AJUSTE = :ajuste, NU_COMISSAO_MULTIPLA = :comissaomultipla, NU_COMISSAO_FIDELIDADE = :fidelidade, NU_PERM_RECORRENCIA = :ativarrecorrencia, NU_PERM_CADASTRO_INDICADO = :cadastroindicado, NU_COMISSAO_CADASTRO = :comissaocadastro, TXT_LINK_SITE_MENU = :linksitemenu, TXT_LABEL_SITE_MENU = :linksitemenulabel, TXT_CPFCNPJ_ALTERNATIVO = :cpfcnpjalternativo, NU_WHATSAPP_RODAPE = :txtnumerowhatsapplinkrodape, TXT_DINHEIRO_SIMBOLO = :simbolodinheiro, TXT_DINHEIRO_MASCARA = :mascaradinheiro WHERE ID_FK = :id';
			$parametros = array(
				':id' => $_POST['id'],
				':sessao' => $_POST['sessao'],
				':dominio' => $_POST['dominio'],
				':ativado' => $ativado,
				':cor1' => $_POST['cor1'],
				':cor2' => $_POST['cor2'],
				':cor3' => $_POST['cor3'],
				':cor4' => $_POST['cor4'],
				':cor5' => $_POST['cor5'],
				':nome' => $_POST['nome'],
				':email' => $_POST['email'],
				':favicon' => $_POST['favicon'],
				':logo' => $_POST['logo'],
				':telefone' => $_POST['telefone'],
				':contato' => $_POST['contato'],
				':bonus' => $_POST['bonus'],
				':adm' => $adm,
				':tipo' => $tipo_sistema,
				':adcontato' => $ad_contato,
				':aceitartermos' => $aceitar_termos,
				':linktermos' => $_POST['termos-uso'],
				':comissao' => $_POST['comissao-agencia'],
				':proibircpf' => $proibir_cpf,
				':distribuircomissoes' => $distribuir_comissoes,
				':upline' => $upline,
				':downlines' => $downlines,
				':permitircnpj1' => $permitir_cnpj1,
				':permitircnpj2' => $permitir_cnpj2,
				':permitirtransferencia' => $permitir_transferencia,
				':imgsocial' => $_POST['imagem-social'],
				':ativarinscricoes' => $ativar_inscricoes,
				':comissaofixa' => $comissao_fixa,
				':flagpontos' => $flag_pontos,
				':ajuste' => $ajuste,
				':comissaomultipla' => $comissao_multipla_bd,
				':ativarrecorrencia' => $ativar_recorrencia,
				':fidelidade' => $fidelidade,
				':comissaocadastro' => $comissao_cadastro,
				':cadastroindicado' => $cadastro_indicado,
				':linksitemenu' => $link_site_menu,
				':linksitemenulabel' => $link_site_menu_label,
				':cpfcnpjalternativo' => $txt_cpf_cnpj_alternativo,
				':txtnumerowhatsapplinkrodape' => $txt_numero_whatsapp_link_rodape,
				':simbolodinheiro' => $simbolo_dinheiro,
				':mascaradinheiro' => $mascara_dinheiro
			);
		}
	}
	else{  // Caso não haja algum registro do sistema de indicações, criar um registro novo
		if($comissao_multipla == true){
			$sql = 'INSERT INTO TBL_CLI_DADOS (ID_FK, TXT_HOST, TXT_SESSION, NU_ATIVADO, TXT_COR1, TXT_COR2, TXT_COR3, TXT_COR4, TXT_COR5, TXT_NOME, TXT_EMAIL, TXT_LOGO, TXT_FAVICON, TXT_TELEFONE, TXT_CONTATO, NU_SUPERADM, TXT_TIPO_SISTEMA_INDICACAO, NU_ADICIONAR_CONTATO, NU_ATIVAR_TERMOS, TXT_LINK_TERMOS, NU_PROIBIR_CPF, NU_DISTRIBUIR_COMISSOES, NU_DOWNLINES, NU_UPLINE, NU_PERM_CNPJ_INDICADO, NU_PERM_CNPJ_INDICADOR, NU_PERM_TRANSFERENCIAS, TXT_IMAGEM_SOCIAL, NU_PERMITIR_INSCRICOES, NU_FLAG_PONTOS, NU_COMISSAO_MULTIPLA, NU_PERM_RECORRENCIA, NU_PERM_CADASTRO_INDICADO, NU_COMISSAO_CADASTRO, NU_COMISSAO_FIXA, TXT_AJUSTE, TXT_LINK_SITE_MENU, TXT_LABEL_SITE_MENU, TXT_CPFCNPJ_ALTERNATIVO, NU_WHATSAPP_RODAPE, TXT_DINHEIRO_SIMBOLO, TXT_DINHEIRO_MASCARA) VALUES (:id, :dominio, :sessao, :ativado, :cor1, :cor2, :cor3, :cor4, :cor5, :nome, :email, :logo, :favicon, :telefone, :contato, :adm, :tipo, :adcontato, :aceitartermos, :linktermos, :proibircpf, :distribuircomissoes, :downlines, :upline, :permitircnpj1, :permitircnpj2, :permitirtransferencia, :imgsocial, :ativarinscricoes, :flagpontos, :comissaomultipla, :ativarrecorrencia, :cadastroindicado, :comissaocadastro, :comissaofixa, :ajuste, :linksitemenu, :linksitemenulabel, :cpfcnpjalternativo, :txtnumerowhatsapplinkrodape, :simbolodinheiro, :mascaradinheiro)';
			$parametros = array(
				':id' => $_POST['id'],
				':sessao' => $_POST['sessao'],
				':dominio' => $_POST['dominio'],
				':ativado' => $ativado,
				':cor1' => $_POST['cor1'],
				':cor2' => $_POST['cor2'],
				':cor3' => $_POST['cor3'],
				':cor4' => $_POST['cor4'],
				':cor5' => $_POST['cor5'],
				':nome' => $_POST['nome'],
				':email' => $_POST['email'],
				':favicon' => $_POST['favicon'],
				':logo' => $_POST['logo'],
				':telefone' => $_POST['telefone'],
				':contato' => $_POST['contato'],
				':adm' => $adm,
				':tipo' => $tipo_sistema,
				':adcontato' => $ad_contato,
				':aceitartermos' => $aceitar_termos,
				':linktermos' => $_POST['termos-uso'],
				':proibircpf' => $proibir_cpf,
				':distribuircomissoes' => $distribuir_comissoes,
				':upline' => $upline,
				':downlines' => $downlines,
				':permitircnpj1' => $permitir_cnpj1,
				':permitircnpj2' => $permitir_cnpj2,
				':permitirtransferencia' => $permitir_transferencia,
				':imgsocial' => $_POST['imagem-social'],
				':ativarinscricoes' => $ativar_inscricoes,
				':flagpontos' => $flag_pontos,
				':comissaomultipla' => $comissao_multipla_bd,
				':ativarrecorrencia' => $ativar_recorrencia,
				':cadastroindicado' => $cadastro_indicado,
				':comissaocadastro' => $comissao_cadastro,
				':comissaofixa' => $comissao_fixa,
				':ajuste' => $ajuste,
				':linksitemenu' => $link_site_menu,
				':linksitemenulabel' => $link_site_menu_label,
				':cpfcnpjalternativo' => $txt_cpf_cnpj_alternativo,
				':txtnumerowhatsapplinkrodape' => $txt_numero_whatsapp_link_rodape,
				':simbolodinheiro' => $simbolo_dinheiro,
				':mascaradinheiro' => $mascara_dinheiro
			);
		}
		else{
			$sql = 'INSERT INTO TBL_CLI_DADOS (ID_FK, TXT_HOST, TXT_SESSION, NU_ATIVADO, TXT_COR1, TXT_COR2, TXT_COR3, TXT_COR4, TXT_COR5, TXT_NOME, TXT_EMAIL, TXT_LOGO, TXT_FAVICON, TXT_TELEFONE, TXT_CONTATO, TXT_BONUS, NU_SUPERADM, TXT_TIPO_SISTEMA_INDICACAO, NU_ADICIONAR_CONTATO, NU_ATIVAR_TERMOS, TXT_LINK_TERMOS, NU_COMISSAO_AGENCIA, NU_PROIBIR_CPF, NU_DISTRIBUIR_COMISSOES, NU_DOWNLINES, NU_UPLINE, NU_PERM_CNPJ_INDICADO, NU_PERM_CNPJ_INDICADOR, NU_PERM_TRANSFERENCIAS, TXT_IMAGEM_SOCIAL, NU_PERMITIR_INSCRICOES, NU_COMISSAO_FIXA, NU_FLAG_PONTOS, TXT_AJUSTE, NU_COMISSAO_MULTIPLA, NU_PERM_RECORRENCIA, NU_COMISSAO_FIDELIDADE, NU_PERM_CADASTRO_INDICADO, NU_COMISSAO_CADASTRO, TXT_LINK_SITE_MENU, TXT_LABEL_SITE_MENU, TXT_CPFCNPJ_ALTERNATIVO, NU_WHATSAPP_RODAPE, TXT_DINHEIRO_SIMBOLO, TXT_DINHEIRO_MASCARA) VALUES (:id, :dominio, :sessao, :ativado, :cor1, :cor2, :cor3, :cor4, :cor5, :nome, :email, :logo, :favicon, :telefone, :contato, :bonus, :adm, :tipo, :adcontato, :aceitartermos, :linktermos, :comissao, :proibircpf, :distribuircomissoes, :downlines, :upline, :permitircnpj1, :permitircnpj2, :permitirtransferencia, :imgsocial, :ativarinscricoes, :comissaofixa, :flagpontos, :ajuste, :comissaomultipla, :ativarrecorrencia, :fidelidade, :cadastroindicado, :comissaocadastro, :linksitemenu, :linksitemenulabel, :cpfcnpjalternativo, :txtnumerowhatsapplinkrodape, :simbolodinheiro, :mascaradinheiro)';
			$parametros = array(
				':id' => $_POST['id'],
				':sessao' => $_POST['sessao'],
				':dominio' => $_POST['dominio'],
				':ativado' => $ativado,
				':cor1' => $_POST['cor1'],
				':cor2' => $_POST['cor2'],
				':cor3' => $_POST['cor3'],
				':cor4' => $_POST['cor4'],
				':cor5' => $_POST['cor5'],
				':nome' => $_POST['nome'],
				':email' => $_POST['email'],
				':favicon' => $_POST['favicon'],
				':logo' => $_POST['logo'],
				':telefone' => $_POST['telefone'],
				':contato' => $_POST['contato'],
				':bonus' => $_POST['bonus'],
				':adm' => $adm,
				':tipo' => $tipo_sistema,
				':adcontato' => $ad_contato,
				':aceitartermos' => $aceitar_termos,
				':linktermos' => $_POST['termos-uso'],
				':comissao' => $_POST['comissao-agencia'],
				':proibircpf' => $proibir_cpf,
				':distribuircomissoes' => $distribuir_comissoes,
				':upline' => $upline,
				':downlines' => $downlines,
				':permitircnpj1' => $permitir_cnpj1,
				':permitircnpj2' => $permitir_cnpj2,
				':permitirtransferencia' => $permitir_transferencia,
				':imgsocial' => $_POST['imagem-social'],
				':ativarinscricoes' => $ativar_inscricoes,
				':comissaofixa' => $comissao_fixa,
				':flagpontos' => $flag_pontos,
				':ajuste' => $ajuste,
				':comissaomultipla' => $comissao_multipla_bd,
				':ativarrecorrencia' => $ativar_recorrencia,
				':fidelidade' => $fidelidade,
				':comissaocadastro' => $comissao_cadastro,
				':cadastroindicado' => $cadastro_indicado,
				':linksitemenu' => $link_site_menu,
				':linksitemenulabel' => $link_site_menu_label,
				':cpfcnpjalternativo' => $txt_cpf_cnpj_alternativo,
				':txtnumerowhatsapplinkrodape' => $txt_numero_whatsapp_link_rodape,
				':simbolodinheiro' => $simbolo_dinheiro,
				':mascaradinheiro' => $mascara_dinheiro
			);
		}
	}

	$sistema->bd->executar($sql, $parametros);

	global $duplicando;
	
	if($comissao_multipla == true){
		$quantidade_comissoes = intval($_POST['qtdComissoes']);
		$ids_comissoes = array();

		for($counterComissoes = 1;$counterComissoes <= $quantidade_comissoes;$counterComissoes++){
			$id_comissao = $_POST['idComissao'.$counterComissoes];
			$nome_comissao = $_POST['nomeComissao'.$counterComissoes];
			$bonus_comissao = $_POST['bonus'.$counterComissoes];
			$agencia_comissao = $_POST['comissao-agencia'.$counterComissoes];
			$coeficiente_comissao = $_POST['coeficiente-ajuste'.$counterComissoes];
			$fidelidade_comissao = $_POST['comissao-fidelidade'.$counterComissoes];
			$comissao_fixa2 = $_POST['comissaofixa'.$counterComissoes] == "Sim" ? 1 : 0;

			if($id_comissao == "-1" || (isset($duplicando) && $duplicando == true)){
				$sistema->bd->executar('INSERT INTO TBL_INDICACOES_COMISSOES (TXT_NOME, TXT_AJUSTE, TXT_BONUS, NU_COMISSAO_AGENCIA, NU_COMISSAO_FIXA, ID_CLIENTE_FK,NU_COMISSAO_FIDELIDADE) VALUES (:nome, :ajuste, :bonus, :comissao, :comissaofixa, :id, :fidelidade)', array(
					':nome' => $nome_comissao,
					':ajuste' => $coeficiente_comissao,
					':bonus' => $bonus_comissao,
					':comissao' => $agencia_comissao,
					':comissaofixa' => $comissao_fixa2,
					':fidelidade' => $fidelidade_comissao,
					':id' => $_POST['id']
				));
				$ids_comissoes[] = intval($sistema->bd->ultima_id());
			}
			else{
				if(!ctype_digit($id_comissao)){
					continue;
				}
				$sistema->bd->executar('UPDATE TBL_INDICACOES_COMISSOES SET TXT_NOME = :nome, TXT_AJUSTE = :ajuste, TXT_BONUS = :bonus, NU_COMISSAO_AGENCIA = :comissao, NU_COMISSAO_FIXA = :comissaofixa, NU_COMISSAO_FIDELIDADE = :fidelidade WHERE NU_ID = :id AND ID_CLIENTE_FK = :id2 AND NU_DELETADO = 0', array(
					':nome' => $nome_comissao,
					':ajuste' => $coeficiente_comissao,
					':bonus' => $bonus_comissao,
					':comissao' => $agencia_comissao,
					':comissaofixa' => $comissao_fixa2,
					':fidelidade' => $fidelidade_comissao,
					':id' => $id_comissao,
					':id2' => $_POST['id']
				));
				$ids_comissoes[] = intval($id_comissao);
			}
		}
		if(count($ids_comissoes) == 1){
			$sql = "UPDATE TBL_INDICACOES_COMISSOES SET NU_DELETADO = 1 WHERE ID_CLIENTE_FK = :id AND NU_ID != '".$ids_comissoes[0]."'";
			$sistema->bd->executar($sql, array(':id' => $_POST['id']));
		}
		else if(count($ids_comissoes) > 1){
			$sql = "UPDATE TBL_INDICACOES_COMISSOES SET NU_DELETADO = 1 WHERE ID_CLIENTE_FK = :id AND NU_ID != '".$ids_comissoes[0]."'";
			$total = count($ids_comissoes);
			for($i = 1; $i < $total;$i++){
				$sql .= " AND NU_ID != '".$ids_comissoes[$i]."'";
			}
			$sistema->bd->executar($sql, array(':id' => $_POST['id']));
		}
	}

	if($row_count > 0){
		$contador = 0;
		while($contador <= 30){
			$vocab = $_POST['texto'.($contador+1)];
			$sistema->bd->executar("UPDATE TBL_INDICACOES_VOCAB SET TXT_CONTEUDO = :con WHERE ID_CLIENTE = :id AND NU_ORDEM = :ordem", array(":id" => $_POST['id'],":con" => $vocab,":ordem" => $contador));
			$contador++;
		}
	}
	else{
		$contador = 0;
		while($contador <= 30){
			$vocab = $_POST['texto'.($contador+1)];
			$sistema->bd->executar("INSERT INTO TBL_INDICACOES_VOCAB (ID_CLIENTE, TXT_CONTEUDO, NU_ORDEM) VALUES (:id, :con, :ordem)", array(":id" => $_POST['id'],":con" => $vocab,":ordem" => $contador));
			$contador++;
		}
	}

	$sistema->logs->adicionar_log_salvar_dados_indicacao($_POST['nome'], $_POST['id']);

	

	if(!(isset($duplicando) && $duplicando == true)){
		$resultado = array(
			"nome" => $_POST['nome'],
			"id" => $_POST['id']
		);

		echo json_encode_alt($resultado);
	}
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>