<?php
require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, false, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_resultados == Usuario::PERM_NENHUMA) $sistema->redirecionar("home");

$sistema->logs->adicionar_log_visualizacao_resultado_gerais();
?>
<!DOCTYPE html>
<html>
<head><!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-MFFM5J3');</script>
<!-- End Google Tag Manager -->
<script>
    (function() {
      try {
        var theme = localStorage.getItem('theme');
        if (!theme) {
          theme = window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light';
        }
        document.documentElement.setAttribute('data-theme', theme);
      } catch (e) {}
    })();
  </script>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<title>Resultados Gerais - Sistema Win7</title>
	<link rel="icon" type="image/ico" href="favicon.png" />
	<link rel="stylesheet" href="../css/bootstrap.min.css">
	<link rel="stylesheet" href="../css/datatables.min.css"/>
	<link rel="stylesheet" href="../css/bootstrap-xl-xxl.css">
	<link rel="stylesheet" href="../css/font-awesome.min.css">
	<link rel="stylesheet" href="../css/ionicons.min.css">
	<link rel="stylesheet" href="../css/AdminLTE.min.css">
	<link rel="stylesheet" href="../css/skin-blue.min.css">
	<link rel="stylesheet" href="css/custom2.0.1.css">
	<link rel="stylesheet" href="../css/toastr.min.css">
	<link rel="stylesheet" href="../css/bootstrap-datepicker.min.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->criar_meta_tags();?>
</head>

<body data-theme="dark" class="hold-transition skin-blue sidebar-mini <?php if($sistema->usuario->sidebar) {echo "sidebar-collapse"; }?>">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MFFM5J3"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<div class="wrapper">
	<?php $sistema->layout->exibir_cabecalho('resultados-gerais');?>

	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
			Resultados Gerais
			<small>Visualize o gráfico geral de todos os clientes ativos</small>
			</h1>
			<ol class="breadcrumb">
				<li><a href="resultados-gerais"><i class="fa green-text fa-bar-chart"></i> Resultados Gerais</a></li>
			</ol>
		</section>

		<section class="content container-fluid">
			<form action="" method="POST" id="formGrafico">
			<div class="row">
				<div class="col-xs-12">
          			<div class="box">
          				<div class="box-body">
          					<div class="row">
          						<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
          							<div class="form-group">
										<label>Eixo X:</label>
										<select name="eixox" id="eixox" class="form-control eixografico" title="Selecione o valor que deseja mostrar no eixo X">
											<option value="forms" selected>Formulários</option>
											<option value="whatsapp" >WhatsApp</option>
											<option value="ligacoes" >Ligações</option>
										</select>
									</div>
          						</div>
          						<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
          							<div class="form-group">
										<label>Eixo Y:</label>
										<select name="eixoy" id="eixoy" class="form-control eixografico" title="Selecione o valor que deseja mostrar no eixo Y">
											<option value="forms" >Formulários</option>
											<option value="whatsapp" selected>WhatsApp</option>
											<option value="ligacoes" >Ligações</option>
										</select>
									</div>
          						</div>
          						<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
          							<div class="form-group">
										<label>Eixo R:</label>
										<select name="eixor" id="eixor" class="form-control eixografico" title="Selecione o valor que deseja mostrar no eixo R">
											<option value="forms" >Formulários</option>
											<option value="whatsapp" >WhatsApp</option>
											<option value="ligacoes" selected>Ligações</option>
										</select>
									</div>
          						</div>
          						<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
          							<div class="form-group">
	          							<label>Período:</label>
										<select name="data" id="data" class="form-control" title="Selecione um período">
											<?php $sistema->layout->select_periodo(); ?>
										</select>
									</div>
          						</div>
          						<div class="<?php if($sistema->filtro->valor() != "CUSTOM_DATE") { echo "hide"; } ?> datadiv">
          							<div class="col-xl-2 col-lg-2 col-md-4 col-sm-6 col-xs-12">
	          							<div class="form-group">
											<label>Data Inicial:</label>
											<div class="input-group date">
												<div class="input-group-addon">
													<i class="fa fa-calendar"></i>
												</div>
												<input type="text" class="form-control pull-right datepicker" name="datainicial" id="datainicial" value="<?php echo $sistema->filtro->data_inicio(); ?>">
											</div>
										</div>
									</div>
									<div class="col-xl-2 col-lg-2 col-md-4 col-sm-6 col-xs-12">
										<div class="form-group">
											<label>Data Final:</label>
											<div class="input-group date">
												<div class="input-group-addon">
													<i class="fa fa-calendar"></i>
												</div>
												<input type="text" class="form-control pull-right datepicker" class="datepicker" name="datafinal" id="datafinal" value="<?php echo $sistema->filtro->data_fim(); ?>">
											</div>
										</div>
									</div>
									<div class="col-xl-2 col-lg-2 col-md-4 col-sm-6 col-xs-12">
										<a id="datapersonalizada" class="btn btn-block btn-primary btn-flat">Pesquisar</a>
									</div>
								</div>
								
          					</div>
          				</div>
          				<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
          			<div class="box">
          				<div class="box-header with-border">
          					<h3 class="box-title">Opções Extras</h5>
							<div class="box-tools pull-right">
								<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
								</button>
							</div>
          				</div>
          				<div class="box-body">
          					<div class="col-xl-2 col-lg-4 col-md-6 col-sm-6 col-xs-12">
								<label style="font-weight: 500;">
									<input type="checkbox" name="atualizar-auto" id="atualizar-auto" class="atualizar-auto" value="s" checked>
									Atualizar Gráfico Automaticamente
								</label>
							</div>
          				</div>
          				<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
          		</div>
				<div class="col-xs-12">
					<div class="box">
						<div class="box-header with-border">
							<div class="row">
								<div class="col-sm-6 dataTables_wrapper">
									<div class="dataTables_length">
		  								<a href="javascript:void(0);" onclick="fullscreen()" class="btn btn-primary " style="margin-bottom: 10px; ">Habilitar Tela Cheia</a>
		  							</div>
								</div>
								<div class="col-sm-6 dataTables_wrapper">
									<div class="dataTables_filter">
										<label>Procurar:<input type="search" id="procurar" name="inputSearch" class="form-control input-sm" placeholder=""></label>
										<button type="buttom" class="btn btn-primary">Buscar</button>
									</div>
									
								</div>
							</div>
          				</div>
          				<div class="box-body">
          					<div class="chart-container" id="chart-container">
          						<canvas id="canvas"></canvas>
          					</div>
          				</div>
          				<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
				</div>
			</div>
			</form>
		</section>
	</div>

	<?php $sistema->layout->exibir_rodape();?>
</div>

<script src="../js/jquery.min.js"></script>
<script src="../js/datatables.min.js"></script>
<script src="../js/bootstrap.min.js"></script>
<script src="../js/adminlte.min.js"></script>
<script src="../js/bootstrap-datepicker.min.js"></script>
<script src="../js/bootstrap-datepicker.pt-BR.min.js"></script>
<script src="../js/toastr.min.js"></script>
<script src="../js/jquery.mask.min.js"></script>
<script src="../js/moment-with-locales.min.js"></script>
<script src="../js/datetime-moment.js"></script>
<script src="../js/date.js"></script>
<script src="../js/filtros.js"></script>
<script src="../js/Chart.min.js"></script>
<script src="../js/chart-utils.js"></script>
<script src="js/resultados-gerais1.0.4.js"></script>
</body>
</html>