<?php

/***
	Esta classe é responsável por controlar o sistema de contatos.
 ***/

class Sistema_Contatos
{
	const SUCESSO = 0;
	const FALHOU_REGISTRO_CONTATO = 1;
	const FALHOU_ENVIO_EMAIL_CLIENTE = 2;
	const FALHOU_ENVIO_EMAIL_LEAD = 3;
	const FALHOU_CONTATO_EXISTE = 4;

	function __construct($sistema)
	{
		$this->sistema = $sistema;
	}

	function montar_tag_manager_head($tag)
	{
		if (!empty($tag)) {
?>
			<!-- Google Tag Manager -->
			<script>
				(function(w, d, s, l, i) {
					w[l] = w[l] || [];
					w[l].push({
						'gtm.start': new Date().getTime(),
						event: 'gtm.js'
					});
					var f = d.getElementsByTagName(s)[0],
						j = d.createElement(s),
						dl = l != 'dataLayer' ? '&l=' + l : '';
					j.async = true;
					j.src =
						'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
					f.parentNode.insertBefore(j, f);
				})(window, document, 'script', 'dataLayer', '<?php echo $tag; ?>');
			</script>
			<!-- End Google Tag Manager -->
		<?php
		}
	}

	function montar_tag_manager_body($tag)
	{
		if (!empty($tag)) {
		?>
			<!-- Google Tag Manager (noscript) -->
			<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=<?php echo $tag; ?>" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
			<!-- End Google Tag Manager (noscript) -->
<?php
		}
	}

	function obter_tags($id_cliente)
	{
		try {
			$this->sistema->iniciar_bd_leads();
			$cliente = $this->sistema->bd_leads->executar("SELECT TXT_ID_TAG_FORMS, TXT_ID_TAG_WHATSAPP FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $id_cliente), Banco_Dados::FETCH);
			return array($cliente['TXT_ID_TAG_FORMS'], $cliente['TXT_ID_TAG_WHATSAPP']);
		} catch (Exception $e) {
			return array("", "");
		}
	}

	function obter_whatsapps_cliente($id_cliente)
	{
		$id_cliente = Sistema::descriptografar($id_cliente);
		try {
			$this->sistema->iniciar_bd_leads();
			$cliente = $this->sistema->bd_leads->executar("SELECT NU_WHATSAPPS FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $id_cliente), Banco_Dados::FETCH);
			return $cliente['NU_WHATSAPPS'];
		} catch (Exception $e) {
			return "sem-whatsapps-banco";
		}
	}

	function obter_smss_cliente($id_cliente)
	{
		$id_cliente = Sistema::descriptografar($id_cliente);
		try {
			$this->sistema->iniciar_bd_leads();
			$cliente = $this->sistema->bd_leads->executar("SELECT NU_SMSS FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $id_cliente), Banco_Dados::FETCH);
			return $cliente['NU_SMSS'];
		} catch (Exception $e) {
			return "sem-smss-banco";
		}
	}

	function salvar_nova_lista_whatsapps_cliente($id_cliente, $novaListaWhatsApp)
	{
		$id_cliente = Sistema::descriptografar($id_cliente);
		try {
			$this->sistema->iniciar_bd_leads();
			// Salva a nova lista de numeros do WhatsApp no banco
			$sql = 'UPDATE TBL_CLIENTE SET NU_WHATSAPPS = :numeroswhatsapp WHERE ID_CLIENTE = :id';
			$params = array(':numeroswhatsapp' => $novaListaWhatsApp, ':id' => $id_cliente);
			return $this->sistema->bd_leads->executar($sql, $params);
		} catch (Exception $e) {
			return $e;
			return "erro-salvar-nova-lista-whatsapp";
		}
	}

	function salvar_nova_lista_smss_cliente($id_cliente, $novaListaSMS)
	{
		$id_cliente = Sistema::descriptografar($id_cliente);
		try {
			$this->sistema->iniciar_bd_leads();
			// Salva a nova lista de numeros do SMS no banco
			$sql = 'UPDATE TBL_CLIENTE SET NU_SMSS = :numerossms WHERE ID_CLIENTE = :id';
			$params = array(':numerossms' => $novaListaSMS, ':id' => $id_cliente);
			return $this->sistema->bd_leads->executar($sql, $params);
		} catch (Exception $e) {
			return $e;
			return "erro-salvar-nova-lista-sms";
		}
	}

	function busca_confirmacao_link_banco($id_cliente)
	{
		$id_cliente = Sistema::descriptografar($id_cliente);
		try {
			$this->sistema->iniciar_bd_leads();
			$cliente = $this->sistema->bd_leads->executar("SELECT TXT_WHATSAPP_LINK FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $id_cliente), Banco_Dados::FETCH);
			return $cliente['TXT_WHATSAPP_LINK'];
		} catch (Exception $e) {
			return "erro-ao-buscar-dado";
		}
	}

	function busca_confirmacao_link_banco_sms($id_cliente)
	{
		$id_cliente = Sistema::descriptografar($id_cliente);
		try {
			$this->sistema->iniciar_bd_leads();
			$cliente = $this->sistema->bd_leads->executar("SELECT TXT_SMS_LINK FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $id_cliente), Banco_Dados::FETCH);
			return $cliente['TXT_SMS_LINK'];
		} catch (Exception $e) {
			return "erro-ao-buscar-dado-sms";
		}
	}

	/*
		Função que valida uma url
	*/
	function validar_url($url)
	{
		try {
			if (!preg_match("#https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~=]{1,256}\.[a-zA-Z0-9()]{1,6}\b([-a-zA-Z0-9()@:%_\+.~?&//=]*)#i", $url)) {
				echo '<div style="position: absolute;display: flex;justify-content: center;align-items: center;height: auto;background-color: red;margin: 0px -8px 0px -8px;padding: 5px 5px;color: white;font-size: 12px;top: 0;z-index: 9999;text-align: center;width: 100%;box-sizing: border-box;opacity: 0.8;background: linear-gradient(90deg, rgba(255,255,255,0) -10%, rgba(255,0,0,1) 50%, rgba(255,255,255,0) 110%);"><p style="font-size:12px;text-shadow: none;">Url de retorno inválida!</p></div>';
			}
		} catch (Exception $e) {
		}
	}

	/*
		Verifica se o whatsapp esta sendo usado pelo link (1) ou banco (0) e retorna o valor
	*/
	function verifica_whatsapp_link_banco($id_cliente, $telefone)
	{
		try {
			$this->sistema->iniciar_bd_leads();
			/* Obtém os dados do cliente */
			$cliente = $this->sistema->bd_leads->executar("SELECT TXT_WHATSAPP_LINK FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $id_cliente), Banco_Dados::FETCH);

			// Verifica se o telefone pelo link esta ativo e verifica se esta em branco, se sim, emite o aviso de erro
			if ($cliente['TXT_WHATSAPP_LINK'] == '1' && $telefone == '') {
				echo '<div style="position: absolute;display: flex;justify-content: center;align-items: center;height: auto;background-color: red;margin: 0px -8px 0px -8px;padding: 5px 5px;color: white;font-size: 12px;top: 0;z-index: 9999;text-align: center;width: 100%;box-sizing: border-box;opacity: 0.8;background: linear-gradient(90deg, rgba(255,255,255,0) -10%, rgba(255,0,0,1) 50%, rgba(255,255,255,0) 110%);"><p style="font-size:12px;text-shadow: none;">Telefone url não informado!</p></div>';
			}
		} catch (Exception $e) {
		}
	}

	/*
		Verifica se o sms esta sendo usado pelo link (1) ou banco (0) e retorna o valor
	*/
	function verifica_sms_link_banco($id_cliente, $telefone)
	{
		try {
			$this->sistema->iniciar_bd_leads();
			/* Obtém os dados do cliente */
			$cliente = $this->sistema->bd_leads->executar("SELECT TXT_SMS_LINK FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $id_cliente), Banco_Dados::FETCH);

			// Verifica se o telefone pelo link esta ativo e verifica se esta em branco, se sim, emite o aviso de erro
			if ($cliente['TXT_SMS_LINK'] == '1' && $telefone == '') {
				echo '<div style="position: absolute;display: flex;justify-content: center;align-items: center;height: auto;background-color: red;margin: 0px -8px 0px -8px;padding: 5px 5px;color: white;font-size: 12px;top: 0;z-index: 9999;text-align: center;width: 100%;box-sizing: border-box;opacity: 0.8;background: linear-gradient(90deg, rgba(255,255,255,0) -10%, rgba(255,0,0,1) 50%, rgba(255,255,255,0) 110%);"><p style="font-size:12px;text-shadow: none;">Telefone url não informado!</p></div>';
			}
		} catch (Exception $e) {
		}
	}

	/*
		Faz a verificação de o código do formulário informado, existe nos formulários configurados do cliente.
		Se não existe, envia um aviso em HTML que fica em desta que no formulário
	*/
	function verifica_existencia_email_configurado($id_cliente, $id_formulario)
	{
		try {
			$this->sistema->iniciar_bd_leads();
			/* Obtém os dados do cliente */
			$cliente = $this->sistema->bd_leads->executar("SELECT TXT_FORMS, NU_FORMS_ATIVADO FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $id_cliente), Banco_Dados::FETCH);

			if (!preg_match("/{$id_formulario}/i", $cliente['TXT_FORMS'])) {
				echo '<div style="position: absolute;display: flex;justify-content: center;align-items: center;height: auto;background-color: red;margin: 0px -8px 0px -8px;padding: 5px 5px;color: white;font-size: 12px;top: 0;z-index: 9999;text-align: center;width: 100%;box-sizing: border-box;opacity: 0.8;background: linear-gradient(90deg, rgba(255,255,255,0) -10%, rgba(255,0,0,1) 50%, rgba(255,255,255,0) 110%);"><p style="font-size:12px;text-shadow: none;">E-mails não configurados!</p></div>';
			}
		} catch (Exception $e) {
		}
	}

	/*
		Faz a busca e processamento dos dados dos emails configurados no sistema
	*/
	function processa_emails_sistemawin7($id_cliente, $id_formulario)
	{

		return $this->buscarEmailsSalvosSitemaWin7($id_cliente, $id_formulario);
	}

	/*
		Registra o contato no banco, e envia os devidos emails ao cliente.
		Essa função retorna um código que informa o resultado do processo.
	*/
	function processar_contato($id_cliente, $nome, $email, $telefone1, $telefone2, $mensagem, $campos_extras, $mensagem_cliente, $assunto_cliente, $destinatarios_cliente, $copias_ocultas_cliente, $mensagem_lead, $assunto_lead, $destinatarios_lead, $copias_ocultas_lead, $nome_lead, $email_lead, $arquivo, $enviar_email_lead, $id_formulario = "")
	{

		// Limpa as variáveis que são nulas
		$mensagem = empty($mensagem) ? "" : $mensagem;
		$telefone1 = empty($telefone1) ? "" : $telefone1;
		$telefone2 = empty($telefone2) ? "" : $telefone2;
		$campos_extras = empty($campos_extras) ? "" : $campos_extras;
		$email = empty($email) ? "" : $email;

		//if(!Utilitarios::email_valido($email)){
		//	return self::FALHOU_ENVIO_EMAIL_LEAD;
		//}

		try {
			$this->sistema->iniciar_bd_leads();
			/* Obtém os dados do cliente */
			$cliente = $this->sistema->bd_leads->executar("SELECT TXT_NOME, TXT_RAMO, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $id_cliente), Banco_Dados::FETCH);
			$login_cliente = $cliente['TXT_LOGIN'];
			$tags_cliente = $cliente['TXT_RAMO'];
			$nome_cliente = $cliente['TXT_NOME'];
			$dia = date('Y-m-d');
			$hora = date('H:i');

			// Inicializa o VCARD do contato
			$vcard = "BEGIN:VCARD\r\nVERSION:2.1\r\nFN:" . $nome . " - " . $nome_cliente;
			if (!empty($telefone1)) $vcard .= "\r\nTEL;CELL:" . $telefone1;
			if (!empty($email)) $vcard .= "\r\nEMAIL:" . $email;
			$vcard .= "\r\nEND:VCARD";
			$nome_vcard = "Novo Contato - " . $nome_cliente . ".vcf";

			/* Verifica se o contato já existe */
			$now = date("Y-m-d H:i:s", time());
			$last10 = date("Y-m-d H:i:s", strtotime("-10 minutes"));
			$sql = "SELECT TXT_NOME FROM TBL_LEADS WHERE ID_CLIENTE_FK = :ID_CLIENTE_FK AND TXT_NOME = :TXT_NOME AND TXT_EMAIL = :TXT_EMAIL AND NU_TELEFONE1 = :NU_TELEFONE1 AND TXT_MENSAGEM = :TXT_MENSAGEM AND TXT_DADOS_EXTRAS = :TXT_DADOS_EXTRAS AND TXT_LEADTIPO = :TXT_LEADTIPO AND DT_ATUAL BETWEEN '" . $last10 . "' AND '" . $now . "'";
			$params = array(
				':ID_CLIENTE_FK' => $id_cliente,
				':TXT_NOME' => $nome,
				':TXT_EMAIL' => $email,
				':NU_TELEFONE1' => $telefone1,
				':TXT_MENSAGEM' => $mensagem,
				':TXT_DADOS_EXTRAS' => $campos_extras,
				':TXT_LEADTIPO' => "Formulário"
			);
			$this->sistema->bd_leads->executar($sql, $params, Banco_Dados::FETCH_ALL);
			if ($this->sistema->bd_leads->quantidade() > 0) {
				return self::FALHOU_CONTATO_EXISTE;
			}

			$identificadortextoToSave = "";
			if ($id_formulario != "") {
				// Busca o identificador do form/whats
				$responseIdentificador = $this->buscarFormWhatsIdentificadorSitemaWin7($id_cliente, $id_formulario);

				if ($responseIdentificador['identificadorativo'] == "1") {
					$identificadortextoToSave = $responseIdentificador['identificadortexto'];
				}
			}


			/* Insere o contato no banco de dados*/
			$sql = 'INSERT INTO TBL_LEADS (ID_CLIENTE_FK,TXT_NOME,TXT_EMAIL,NU_TELEFONE1,NU_TELEFONE2,TXT_MENSAGEM,DT_DATA_MSG,DT_HORA_MSG,TXT_LEAD_RAMO,TXT_LEAD_CLIENTE,TXT_IDENTIFICADOR,TXT_DADOS_EXTRAS)
	        VALUES (:ID_CLIENTE_FK,:TXT_NOME,:TXT_EMAIL,:NU_TELEFONE1,:NU_TELEFONE2,:TXT_MENSAGEM,:DT_DATA_MSG,:DT_HORA_MSG,:TXT_LEAD_RAMO,:TXT_LEAD_CLIENTE,:TXT_IDENTIFICADOR,:TXT_DADOS_EXTRAS)';
			$params = array(
				':ID_CLIENTE_FK' => $id_cliente,
				':TXT_NOME' => $nome,
				':TXT_EMAIL' => $email,
				':NU_TELEFONE1' => $telefone1,
				':NU_TELEFONE2' => $telefone2,
				':TXT_MENSAGEM' => $mensagem,
				':DT_DATA_MSG' => $dia,
				':DT_HORA_MSG' => $hora,
				':TXT_LEAD_RAMO' => $tags_cliente,
				':TXT_LEAD_CLIENTE' => $login_cliente,
				':TXT_IDENTIFICADOR' => $identificadortextoToSave,
				':TXT_DADOS_EXTRAS' => $campos_extras
			);
			$this->sistema->bd_leads->executar($sql, $params);

			/* Insere os campos extras */
			if (empty($campos_extras) || $campos_extras == "")
				$dados_extras = array();
			else {
				$dados_extras = $campos_extras;
				$dados_extras = explode(' |$| ', $dados_extras);
				$dados_extras = ($dados_extras == false) ? array() : $dados_extras;
				if (count($dados_extras) % 2 != 0) {
					$dados_extras = array();
				}
			}
			$ultima_id = $this->sistema->bd_leads->ultima_id();
			$quantidade_campos = 1;
			$max_dados = count($dados_extras);
			$sql = "INSERT INTO TBL_LEADS_CAMPOS (NU_ID_LEAD, TXT_NOME, TXT_CONTEUDO, NU_ORDEM) VALUES";
			$params = array();
			if ($max_dados >= 2) {
				$sql .= " (:a_1_id, :a_1_nome, :a_1_conteudo, :a_1_ordem)";
				$params[':a_1_id'] = $ultima_id;
				$params[':a_1_nome'] = $dados_extras[0];
				$params[':a_1_conteudo'] = $dados_extras[1];
				$params[':a_1_ordem'] = 1;
			}
			if ($max_dados >= 4) {
				for ($contador = 2; $contador < $max_dados; $contador += 2) {
					$quantidade_campos++;
					$sql .= ", (:a_" . $quantidade_campos . "_id, :a_" . $quantidade_campos . "_nome, :a_" . $quantidade_campos . "_conteudo, :a_" . $quantidade_campos . "_ordem)";
					$params[':a_' . $quantidade_campos . '_id'] = $ultima_id;
					$params[':a_' . $quantidade_campos . '_nome'] = $dados_extras[$contador];
					$params[':a_' . $quantidade_campos . '_conteudo'] = $dados_extras[$contador + 1];
					$params[':a_' . $quantidade_campos . '_ordem'] = $quantidade_campos;
				}
			}
			if ($max_dados >= 2) {
				$this->sistema->bd_leads->executar($sql, $params);
			}
		} catch (Exception $e) {
			return self::FALHOU_REGISTRO_CONTATO;
		}


		/* Registra o email do cliente para envio */
		try {
			$id_email = Sistema::registrar_email($mensagem_cliente, $assunto_cliente, $destinatarios_cliente, $copias_ocultas_cliente, "Não Responda", "nao-responda@win7.com.br", $arquivo, Sistema::TIPO_EMAIL_CLIENTE, $vcard, $nome_vcard);
		} catch (Exception $e) {
			try {
				$this->sistema->bd_leads->executar("DELETE FROM TBL_LEADS WHERE NU_ID = :id", array(':id' => $ultima_id));
				$this->sistema->bd_leads->executar("DELETE FROM TBL_LEADS_CAMPOS WHERE NU_ID_LEAD = :id", array(':id' => $ultima_id));
			} catch (Exception $e) {
			}
			return self::FALHOU_ENVIO_EMAIL_CLIENTE;
		}

		if ($enviar_email_lead) {
			/* Registra o email do lead para envio */
			try {
				Sistema::registrar_email($mensagem_lead, $assunto_lead, $destinatarios_lead, $copias_ocultas_lead, $nome_lead, $email_lead, $arquivo, Sistema::TIPO_EMAIL_LEAD);
			} catch (Exception $e) {
				try {
					$this->sistema->bd_leads->executar("DELETE FROM TBL_LEADS WHERE NU_ID = :id", array(':id' => $ultima_id));
					$this->sistema->bd_leads->executar("DELETE FROM TBL_LEADS_CAMPOS WHERE NU_ID_LEAD = :id", array(':id' => $ultima_id));
					$this->sistema->bd->executar("DELETE FROM TBL_ENVIO_EMAIL WHERE NU_ID = :id", array(':id' => $id_email));
				} catch (Exception $e) {
				}
				return self::FALHOU_ENVIO_EMAIL_LEAD;
			}
		}

		return self::SUCESSO;
	}

	/*
		COPIA DA FUNCAO processar_contato() PERSONALIZADA PARA A GUARDA O LEAD EM DOIS OU MAIS SISTEMAS DIFERENTES
	*/
	function processar_contato_OUTRO_SISTEMA($id_cliente, $nome, $email, $telefone1, $telefone2, $mensagem, $campos_extras)
	{

		// Limpa as variáveis que são nulas
		$mensagem = empty($mensagem) ? "" : $mensagem;
		$telefone1 = empty($telefone1) ? "" : $telefone1;
		$telefone2 = empty($telefone2) ? "" : $telefone2;
		$campos_extras = empty($campos_extras) ? "" : $campos_extras;
		$email = empty($email) ? "" : $email;

		//if(!Utilitarios::email_valido($email)){
		//	return self::FALHOU_ENVIO_EMAIL_LEAD;
		//}

		try {
			$this->sistema->iniciar_bd_leads();
			/* Obtém os dados do cliente */
			$cliente = $this->sistema->bd_leads->executar("SELECT TXT_NOME, TXT_RAMO, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $id_cliente), Banco_Dados::FETCH);
			$login_cliente = $cliente['TXT_LOGIN'];
			$tags_cliente = $cliente['TXT_RAMO'];
			$nome_cliente = $cliente['TXT_NOME'];
			$dia = date('Y-m-d');
			$hora = date('H:i');

			// Inicializa o VCARD do contato
			// $vcard = "BEGIN:VCARD\r\nVERSION:2.1\r\nFN:".$nome." - ".$nome_cliente;
			// if(!empty($telefone1)) $vcard .= "\r\nTEL;CELL:".$telefone1;
			// if(!empty($email)) $vcard .= "\r\nEMAIL:".$email;
			// $vcard .= "\r\nEND:VCARD";
			// $nome_vcard = "Novo Contato - ".$nome_cliente.".vcf";

			/* Verifica se o contato já existe */
			$now = date("Y-m-d H:i:s", time());
			$last10 = date("Y-m-d H:i:s", strtotime("-10 minutes"));
			$sql = "SELECT TXT_NOME FROM TBL_LEADS WHERE ID_CLIENTE_FK = :ID_CLIENTE_FK AND TXT_NOME = :TXT_NOME AND TXT_EMAIL = :TXT_EMAIL AND NU_TELEFONE1 = :NU_TELEFONE1 AND TXT_MENSAGEM = :TXT_MENSAGEM AND TXT_DADOS_EXTRAS = :TXT_DADOS_EXTRAS AND TXT_LEADTIPO = :TXT_LEADTIPO AND DT_ATUAL BETWEEN '" . $last10 . "' AND '" . $now . "'";
			$params = array(
				':ID_CLIENTE_FK' => $id_cliente,
				':TXT_NOME' => $nome,
				':TXT_EMAIL' => $email,
				':NU_TELEFONE1' => $telefone1,
				':TXT_MENSAGEM' => $mensagem,
				':TXT_DADOS_EXTRAS' => $campos_extras,
				':TXT_LEADTIPO' => "Formulário"
			);
			$this->sistema->bd_leads->executar($sql, $params, Banco_Dados::FETCH_ALL);
			if ($this->sistema->bd_leads->quantidade() > 0) {
				return self::FALHOU_CONTATO_EXISTE;
			}

			/* Insere o contato no banco de dados*/
			$sql = 'INSERT INTO TBL_LEADS (ID_CLIENTE_FK,TXT_NOME,TXT_EMAIL,NU_TELEFONE1,NU_TELEFONE2,TXT_MENSAGEM,DT_DATA_MSG,DT_HORA_MSG,TXT_LEAD_RAMO,TXT_LEAD_CLIENTE,TXT_DADOS_EXTRAS)
	        VALUES (:ID_CLIENTE_FK,:TXT_NOME,:TXT_EMAIL,:NU_TELEFONE1,:NU_TELEFONE2,:TXT_MENSAGEM,:DT_DATA_MSG,:DT_HORA_MSG,:TXT_LEAD_RAMO,:TXT_LEAD_CLIENTE,:TXT_DADOS_EXTRAS)';
			$params = array(
				':ID_CLIENTE_FK' => $id_cliente,
				':TXT_NOME' => $nome,
				':TXT_EMAIL' => $email,
				':NU_TELEFONE1' => $telefone1,
				':NU_TELEFONE2' => $telefone2,
				':TXT_MENSAGEM' => $mensagem,
				':DT_DATA_MSG' => $dia,
				':DT_HORA_MSG' => $hora,
				':TXT_LEAD_RAMO' => $tags_cliente,
				':TXT_LEAD_CLIENTE' => $login_cliente,
				':TXT_DADOS_EXTRAS' => $campos_extras
			);
			$this->sistema->bd_leads->executar($sql, $params);

			/* Insere os campos extras */
			if (empty($campos_extras) || $campos_extras == "")
				$dados_extras = array();
			else {
				$dados_extras = $campos_extras;
				$dados_extras = explode(' |$| ', $dados_extras);
				$dados_extras = ($dados_extras == false) ? array() : $dados_extras;
				if (count($dados_extras) % 2 != 0) {
					$dados_extras = array();
				}
			}
			$ultima_id = $this->sistema->bd_leads->ultima_id();
			$quantidade_campos = 1;
			$max_dados = count($dados_extras);
			$sql = "INSERT INTO TBL_LEADS_CAMPOS (NU_ID_LEAD, TXT_NOME, TXT_CONTEUDO, NU_ORDEM) VALUES";
			$params = array();
			if ($max_dados >= 2) {
				$sql .= " (:a_1_id, :a_1_nome, :a_1_conteudo, :a_1_ordem)";
				$params[':a_1_id'] = $ultima_id;
				$params[':a_1_nome'] = $dados_extras[0];
				$params[':a_1_conteudo'] = $dados_extras[1];
				$params[':a_1_ordem'] = 1;
			}
			if ($max_dados >= 4) {
				for ($contador = 2; $contador < $max_dados; $contador += 2) {
					$quantidade_campos++;
					$sql .= ", (:a_" . $quantidade_campos . "_id, :a_" . $quantidade_campos . "_nome, :a_" . $quantidade_campos . "_conteudo, :a_" . $quantidade_campos . "_ordem)";
					$params[':a_' . $quantidade_campos . '_id'] = $ultima_id;
					$params[':a_' . $quantidade_campos . '_nome'] = $dados_extras[$contador];
					$params[':a_' . $quantidade_campos . '_conteudo'] = $dados_extras[$contador + 1];
					$params[':a_' . $quantidade_campos . '_ordem'] = $quantidade_campos;
				}
			}
			if ($max_dados >= 2) {
				$this->sistema->bd_leads->executar($sql, $params);
			}
		} catch (Exception $e) {
			return self::FALHOU_REGISTRO_CONTATO;
		}


		/* Registra o email do cliente para envio */
		// try{
		// 	$id_email = Sistema::registrar_email($mensagem_cliente, $assunto_cliente, $destinatarios_cliente, $copias_ocultas_cliente, "Não Responda", "nao-responda@win7.com.br", $arquivo, Sistema::TIPO_EMAIL_CLIENTE, $vcard, $nome_vcard);
		// }
		// catch(Exception $e){
		// 	try{
		// 		$this->sistema->bd_leads->executar("DELETE FROM TBL_LEADS WHERE NU_ID = :id", array( ':id' => $ultima_id));
		// 		$this->sistema->bd_leads->executar("DELETE FROM TBL_LEADS_CAMPOS WHERE NU_ID_LEAD = :id", array( ':id' => $ultima_id));
		// 	}
		// 	catch(Exception $e){}
		// 	return self::FALHOU_ENVIO_EMAIL_CLIENTE;
		// }

		// if($enviar_email_lead){
		// 	/* Registra o email do lead para envio */
		// 	try{
		// 		Sistema::registrar_email($mensagem_lead, $assunto_lead, $destinatarios_lead, $copias_ocultas_lead, $nome_lead, $email_lead, $arquivo, Sistema::TIPO_EMAIL_LEAD);
		// 	}
		// 	catch(Exception $e){
		// 		try{
		// 			$this->sistema->bd_leads->executar("DELETE FROM TBL_LEADS WHERE NU_ID = :id", array( ':id' => $ultima_id));
		// 			$this->sistema->bd_leads->executar("DELETE FROM TBL_LEADS_CAMPOS WHERE NU_ID_LEAD = :id", array( ':id' => $ultima_id));
		// 			$this->sistema->bd->executar("DELETE FROM TBL_ENVIO_EMAIL WHERE NU_ID = :id", array( ':id' => $id_email));
		// 		}
		// 		catch(Exception $e){}
		// 		return self::FALHOU_ENVIO_EMAIL_LEAD;
		// 	}
		// }

		return self::SUCESSO;
	}


	function obter_codigo_conversao_whatsapp($id)
	{
		$id_cliente = Sistema::descriptografar($id);
		try {
			$res = $this->sistema->bd->executar("SELECT * FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $id_cliente), Banco_Dados::FETCH);
			return $res['TXT_CONVERSAO_WHATSAPP'];
		} catch (Exception $e) {
			return "";
		}
		return "";
	}

	function obter_codigo_conversao_sms($id)
	{
		$id_cliente = Sistema::descriptografar($id);
		try {
			$res = $this->sistema->bd->executar("SELECT * FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $id_cliente), Banco_Dados::FETCH);
			return $res['TXT_CONVERSAO_SMS'];
		} catch (Exception $e) {
			return "";
		}
		return "";
	}

	function obter_codigo_conversao_geral($id)
	{
		$id_cliente = Sistema::descriptografar($id);
		try {
			$res = $this->sistema->bd->executar("SELECT * FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $id_cliente), Banco_Dados::FETCH);
			return $res['TXT_CONVERSAO_GERAL'];
		} catch (Exception $e) {
			return "";
		}
		return "";
	}

	function processar_whatsapp($id, $telefone, $nome, $identificacaoDoLead, $campos_extras = null)
	{
		$id_cliente = Sistema::descriptografar($id);

		$this->sistema->iniciar_bd_leads();

		try {
			/* Obtém os dados do cliente */
			$cliente = $this->sistema->bd_leads->executar("SELECT TXT_RAMO, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $id_cliente), Banco_Dados::FETCH);
			$login_cliente = $cliente['TXT_LOGIN'];
			$tags_cliente = $cliente['TXT_RAMO'];
			$dia = date('Y-m-d');
			$hora = date('H:i');

			/* Verifica se o contato já existe */
			$now = date("Y-m-d H:i:s", time());
			$last10 = date("Y-m-d H:i:s", strtotime("-10 minutes"));
			$sql = "SELECT TXT_NOME FROM TBL_LEADS WHERE ID_CLIENTE_FK = :ID_CLIENTE_FK AND NU_TELEFONE1 = :NU_TELEFONE1 AND TXT_LEADTIPO = :TXT_LEADTIPO AND DT_ATUAL BETWEEN '" . $last10 . "' AND '" . $now . "'";
			$params = array(
				':ID_CLIENTE_FK' => $id_cliente,
				':NU_TELEFONE1' => $telefone,
				':TXT_LEADTIPO' => "WhatsApp"
			);
			$this->sistema->bd_leads->executar($sql, $params, Banco_Dados::FETCH_ALL);
			if ($this->sistema->bd_leads->quantidade() > 0) {
				return;
			}

			if ($campos_extras == null) {
				$campos_extras = " ";
			}

			if ($nome == null) {
				$nome = "Novo Contato WhatsApp";
			}

			if ($identificacaoDoLead != null) {
				$nome .= " - " . $identificacaoDoLead;
			}

			/* Insere o contato no banco de dados*/
			$sql = 'INSERT INTO TBL_LEADS (ID_CLIENTE_FK,TXT_NOME,NU_TELEFONE1,DT_DATA_MSG,DT_HORA_MSG,TXT_LEAD_RAMO,TXT_LEAD_CLIENTE,TXT_DADOS_EXTRAS,TXT_LEADTIPO)
	        VALUES (:ID_CLIENTE_FK,:TXT_NOME,:NU_TELEFONE1,:DT_DATA_MSG,:DT_HORA_MSG,:TXT_LEAD_RAMO,:TXT_LEAD_CLIENTE,:TXT_DADOS_EXTRAS,:TXT_LEADTIPO)';
			$params = array(
				':ID_CLIENTE_FK' => $id_cliente,
				':TXT_NOME' => $nome,
				':NU_TELEFONE1' => $telefone,
				':DT_DATA_MSG' => $dia,
				':DT_HORA_MSG' => $hora,
				':TXT_LEAD_RAMO' => $tags_cliente,
				':TXT_LEAD_CLIENTE' => $login_cliente,
				':TXT_DADOS_EXTRAS' => $campos_extras,
				':TXT_LEADTIPO' => "WhatsApp"
			);
			$this->sistema->bd_leads->executar($sql, $params);

			/* Insere os campos extras */
			if (empty($campos_extras) || $campos_extras == "")
				$dados_extras = array();
			else {
				$dados_extras = $campos_extras;
				$dados_extras = explode(' |$| ', $dados_extras);
				$dados_extras = ($dados_extras == false) ? array() : $dados_extras;
				if (count($dados_extras) % 2 != 0) {
					$dados_extras = array();
				}
			}
			$ultima_id = $this->sistema->bd_leads->ultima_id();
			$quantidade_campos = 1;
			$max_dados = count($dados_extras);
			$sql = "INSERT INTO TBL_LEADS_CAMPOS (NU_ID_LEAD, TXT_NOME, TXT_CONTEUDO, NU_ORDEM) VALUES";
			$params = array();
			if ($max_dados >= 2) {
				$sql .= " (:a_1_id, :a_1_nome, :a_1_conteudo, :a_1_ordem)";
				$params[':a_1_id'] = $ultima_id;
				$params[':a_1_nome'] = $dados_extras[0];
				$params[':a_1_conteudo'] = $dados_extras[1];
				$params[':a_1_ordem'] = 1;
			}
			if ($max_dados >= 4) {
				for ($contador = 2; $contador < $max_dados; $contador += 2) {
					$quantidade_campos++;
					$sql .= ", (:a_" . $quantidade_campos . "_id, :a_" . $quantidade_campos . "_nome, :a_" . $quantidade_campos . "_conteudo, :a_" . $quantidade_campos . "_ordem)";
					$params[':a_' . $quantidade_campos . '_id'] = $ultima_id;
					$params[':a_' . $quantidade_campos . '_nome'] = $dados_extras[$contador];
					$params[':a_' . $quantidade_campos . '_conteudo'] = $dados_extras[$contador + 1];
					$params[':a_' . $quantidade_campos . '_ordem'] = $quantidade_campos;
				}
			}
			if ($max_dados >= 2) {
				$this->sistema->bd_leads->executar($sql, $params);
			}
		} catch (Exception $e) {
		}
	}



	/* Funcao que processar os dados do whatsapp, e enviar o e-mail para nosso cliente */
	function processar_link_lp($id, $identificacao, $identificacaoperso, $ip_lead = NULL)
	{
		$id_cliente = Sistema::descriptografar($id);

		$this->sistema->iniciar_bd_leads();

		try {
			/* Obtém os dados do cliente */
			$cliente = $this->sistema->bd_leads->executar("SELECT TXT_RAMO, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $id_cliente), Banco_Dados::FETCH);
			$login_cliente = $cliente['TXT_LOGIN'];
			$tags_cliente = $cliente['TXT_RAMO'];
			$dia = date('Y-m-d');
			$hora = date('H:i');

			/* Verifica se o contato já existe no ultimos 10 minutos */
			$now = date("Y-m-d H:i:s", time());
			$last10 = date("Y-m-d H:i:s", strtotime("-10 minutes"));
			$sql = "SELECT TXT_NOME FROM TBL_LEADS WHERE ID_CLIENTE_FK = :ID_CLIENTE_FK AND TXT_IP_LEAD = :TXT_IP_LEAD AND TXT_LEADTIPO = :TXT_LEADTIPO AND TXT_LEAD_CLIQUE_IDENTIFICADOR = :TXT_LEAD_CLIQUE_IDENTIFICADOR AND DT_ATUAL BETWEEN '" . $last10 . "' AND '" . $now . "'";
			$params = array(
				':ID_CLIENTE_FK' => $id_cliente,
				':TXT_IP_LEAD' => $ip_lead,
				':TXT_LEAD_CLIQUE_IDENTIFICADOR' => $identificacao != "outro" ? $identificacao : $identificacao . "|#|" . ucwords(strtolower($identificacaoperso)),
				':TXT_LEADTIPO' => "Link Clique"
			);

			$this->sistema->bd_leads->executar($sql, $params, Banco_Dados::FETCH_ALL);

			// Se exisit algum nos ultimos 10 minutos, nao salva
			if ($this->sistema->bd_leads->quantidade() > 0) {
				return;
			}

			switch ($identificacao) {
				case 'waze':
					$nome = "Clique Waze";
					break;

				case 'uber':
					$nome = "Clique Uber";
					break;

				case 'maps':
					$nome = "Clique Maps";
					break;

				case 'linkedin':
					$nome = "Clique LinkedIn";
					break;

				case 'instagram':
					$nome = "Clique Instagram";
					break;

				case 'facebook':
					$nome = "Clique Facebook";
					break;

				case 'novenove':
					$nome = "Clique 99";
					break;

				case 'ifood':
					$nome = "Clique iFood";
					break;

				case 'ubereats':
					$nome = "Clique Uber Eats";
					break;

				case 'loggi':
					$nome = "Clique Loggi";
					break;

				case 'rappi':
					$nome = "Clique Rappi";
					break;

				default:
					$nome = "Clique " . ucwords(strtolower($identificacaoperso));
					break;
			}

			/* Insere o contato no banco de dados*/
			$sql = 'INSERT INTO TBL_LEADS (ID_CLIENTE_FK,TXT_NOME,NU_TELEFONE1,DT_DATA_MSG,DT_HORA_MSG,TXT_LEAD_RAMO,TXT_LEAD_CLIENTE,TXT_LEADTIPO,TXT_IP_LEAD,TXT_LEAD_CLIQUE_IDENTIFICADOR)
						VALUES (:ID_CLIENTE_FK,:TXT_NOME,:NU_TELEFONE1,:DT_DATA_MSG,:DT_HORA_MSG,:TXT_LEAD_RAMO,:TXT_LEAD_CLIENTE,:TXT_LEADTIPO,:TXT_IP_LEAD,:TXT_LEAD_CLIQUE_IDENTIFICADOR)';
			$params = array(
				':ID_CLIENTE_FK' => $id_cliente,
				':TXT_NOME' => $nome,
				':NU_TELEFONE1' => NULL,
				':DT_DATA_MSG' => $dia,
				':DT_HORA_MSG' => $hora,
				':TXT_LEAD_RAMO' => $tags_cliente,
				':TXT_LEAD_CLIENTE' => $login_cliente,
				':TXT_LEADTIPO' => "Link Clique",
				':TXT_IP_LEAD' => $ip_lead,
				':TXT_LEAD_CLIQUE_IDENTIFICADOR' => $identificacao != "outro" ? $identificacao : $identificacao . "|#|" . ucwords(strtolower($identificacaoperso))
			);

			/* Salva o lead acima no banco */
			$this->sistema->bd_leads->executar($sql, $params);
		} catch (Exception $e) {
		}
	}

	/* Funcao que processa os dados do whatsapp, e envia o e-mail para nosso cliente */
	function processar_whatsapp_e_enviar_email($id, $telefone, $nome, $email = null, $identificacaoDoLead, $idemails, $arquivo)
	{
		$id_cliente = Sistema::descriptografar($id);

		$this->sistema->iniciar_bd_leads();

		try {
			/* Obtém os dados do cliente */
			$cliente = $this->sistema->bd_leads->executar("SELECT TXT_RAMO, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $id_cliente), Banco_Dados::FETCH);
			$login_cliente = $cliente['TXT_LOGIN'];
			$tags_cliente = $cliente['TXT_RAMO'];
			$dia = date('Y-m-d');
			$hora = date('H:i');

			/* Verifica se o contato já existe */
			$now = date("Y-m-d H:i:s", time());
			$last10 = date("Y-m-d H:i:s", strtotime("-10 minutes"));
			$sql = "SELECT TXT_NOME FROM TBL_LEADS WHERE ID_CLIENTE_FK = :ID_CLIENTE_FK AND NU_TELEFONE1 = :NU_TELEFONE1 AND TXT_LEADTIPO = :TXT_LEADTIPO AND DT_ATUAL BETWEEN '" . $last10 . "' AND '" . $now . "'";
			$params = array(
				':ID_CLIENTE_FK' => $id_cliente,
				':NU_TELEFONE1' => $telefone,
				':TXT_LEADTIPO' => "WhatsApp"
			);

			$this->sistema->bd_leads->executar($sql, $params, Banco_Dados::FETCH_ALL);

			if ($this->sistema->bd_leads->quantidade() > 0) {
				return;
			}

			if ($nome == null) {
				$nome = "Novo Contato WhatsApp";
			}

			if ($identificacaoDoLead != null) {
				$nome .= " - " . $identificacaoDoLead;
			}

			// Busca o identificador do form/whats
			$responseIdentificador = $this->buscarFormWhatsIdentificadorSitemaWin7($id_cliente, $idemails);

			$identificadortextoToSave = "";
			if ($responseIdentificador['identificadorativo'] == "1") {
				$identificadortextoToSave = $responseIdentificador['identificadortexto'];
			}

			/* Insere o contato no banco de dados*/
			$sql = 'INSERT INTO TBL_LEADS (ID_CLIENTE_FK,TXT_NOME,TXT_EMAIL,NU_TELEFONE1,DT_DATA_MSG,DT_HORA_MSG,TXT_LEAD_RAMO,TXT_LEAD_CLIENTE,TXT_LEADTIPO,TXT_IDENTIFICADOR)
						VALUES (:ID_CLIENTE_FK,:TXT_NOME,:TXT_EMAIL,:NU_TELEFONE1,:DT_DATA_MSG,:DT_HORA_MSG,:TXT_LEAD_RAMO,:TXT_LEAD_CLIENTE,:TXT_LEADTIPO,:TXT_IDENTIFICADOR)';
			$params = array(
				':ID_CLIENTE_FK' => $id_cliente,
				':TXT_NOME' => $nome,
				':TXT_EMAIL' => $email,
				':NU_TELEFONE1' => $telefone,
				':DT_DATA_MSG' => $dia,
				':DT_HORA_MSG' => $hora,
				':TXT_LEAD_RAMO' => $tags_cliente,
				':TXT_LEAD_CLIENTE' => $login_cliente,
				':TXT_LEADTIPO' => "WhatsApp",
				':TXT_IDENTIFICADOR' => $identificadortextoToSave
			);

			/* Salva o lead acima no banco */
			$this->sistema->bd_leads->executar($sql, $params);

			/* Verifica se existe algum id de Email para a busca, se não tiver, pula o envio de email */
			if ($idemails != null) {

				/* Busca os emails salvos no sistema win7 */
				$response = $this->buscarEmailsSalvosSitemaWin7($id_cliente, $idemails);

				/* Limpa os caracteres especiais do telefone */
				$telefoneFormatado = preg_replace('/[^A-Za-z0-9]/', '', trim($telefone));

				/* Configura a mensagem do link do WhatsApp */
				$msgUrlWhatsApp = $nome != 'Novo Contato WhatsApp' ? "Olá " . $nome . "!" : 'Olá! Em que podemos ajudar?';

				/* Monsta a mensagem do e-mail */
				$msgEmailCliente = '
					<div style="color: #dc143c;background-color: #fff4f4;padding: 1px 16px;border-radius: 5px;"><p><i><b>ATENÇÃO:</b> Por favor, não responda esse e-mail!<br>
					Esse e-mail é enviado e autenticado pelo nosso sistema automático, por isso, para responder ao cliente,	entre em contato pelo número abaixo.</i></p></div><hr style="border: none;height: 2px;background-color: #d8d8d8;"><br>
					<p><b>AVISO DE ENVIO DE WHATSAPP</b></p>';
				$msgEmailCliente .= $nome != 'Novo Contato WhatsApp' ? '<p><b>NOME:</b> ' . $nome . '</p>' : '';
				$msgEmailCliente .= $email != "" ? '<p><b>EMAIL:</b> ' . $email . '</p>' : '';
				$msgEmailCliente .= '<p><b>WhatsApp informado:</b> ' . $telefone . '</p><br>
					<hr style="border: none;height: 2px;background-color: #d8d8d8;">
					<p>Preenchido pelo ' . $this->sistema->maquina_usuario . '</p>
					<hr style="border: none;height: 2px;background-color: #d8d8d8;"><br>
					<a href="tel:' . $telefoneFormatado . '" target="_blank" style="background-color: #00BCD4;padding: 8px 12px;border-radius: 40px;color: white;text-decoration: none;line-height: 34px;">☎ Clique para ligar: ' . $telefone . ' </a><br><a href="https://api.whatsapp.com/send?phone=+55' . $telefoneFormatado . '&text=' . $msgUrlWhatsApp . '" target="_blank" style="background-color: #31c558;padding: 8px 12px;border-radius: 40px;color: white;text-decoration: none;line-height: 34px;">📱 Clique para chamar no WhatsApp*</a><p><i>*Talvez o número do contato acima não possua WhatsApp</i></p>';

				/* Registra o email do cliente para envio */
				try {
					$id_email = Sistema::registrar_email($msgEmailCliente, $response['assuntoemail'], $response['destinatarios'], $response['copiasocultas'], "Não Responda", "nao-responda@win7.com.br", $arquivo, Sistema::TIPO_EMAIL_CLIENTE);
				} catch (Exception $e) {
					try {
						$this->sistema->bd->executar("DELETE FROM TBL_ENVIO_EMAIL WHERE NU_ID = :id", array(':id' => $id_email));
					} catch (Exception $e) {
					}
					return self::FALHOU_ENVIO_EMAIL_CLIENTE;
				}
			}
		} catch (Exception $e) {
		}
	}

	/* Funcao que processa os dados do sms, e envia o e-mail para nosso cliente */
	function processar_sms_e_enviar_email($id, $telefone, $nome, $email = null, $identificacaoDoLead, $idemails, $arquivo, $idioma)
	{
		$id_cliente = Sistema::descriptografar($id);

		$this->sistema->iniciar_bd_leads();

		try {
			/* Obtém os dados do cliente */
			$cliente = $this->sistema->bd_leads->executar("SELECT TXT_RAMO, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $id_cliente), Banco_Dados::FETCH);
			$login_cliente = $cliente['TXT_LOGIN'];
			$tags_cliente = $cliente['TXT_RAMO'];
			$dia = date('Y-m-d');
			$hora = date('H:i');

			/* Verifica se o contato já existe */
			$now = date("Y-m-d H:i:s", time());
			$last10 = date("Y-m-d H:i:s", strtotime("-10 minutes"));
			$sql = "SELECT TXT_NOME FROM TBL_LEADS WHERE ID_CLIENTE_FK = :ID_CLIENTE_FK AND NU_TELEFONE1 = :NU_TELEFONE1 AND TXT_LEADTIPO = :TXT_LEADTIPO AND DT_ATUAL BETWEEN '" . $last10 . "' AND '" . $now . "'";
			$params = array(
				':ID_CLIENTE_FK' => $id_cliente,
				':NU_TELEFONE1' => $telefone,
				':TXT_LEADTIPO' => "SMS"
			);

			$this->sistema->bd_leads->executar($sql, $params, Banco_Dados::FETCH_ALL);

			if ($this->sistema->bd_leads->quantidade() > 0) {
				return;
			}

			$isNomeNull = $nome == null;

			if ($nome == null) {
				switch ($idioma) {
					case 'en':
						$nome = "New Contact SMS";
						break;
					case 'es':
						$nome = "SMS de nuevo contacto";
						break;
					case 'pt':
						$nome = "Novo Contato SMS";
						break;
					default:
						$nome = "Novo Contato SMS";
				}
			}

			if ($identificacaoDoLead != null) {
				$nome .= " - " . $identificacaoDoLead;
			}

			// Busca o identificador do form/whats
			$responseIdentificador = $this->buscarFormWhatsIdentificadorSitemaWin7($id_cliente, $idemails);

			$identificadortextoToSave = "";
			if ($responseIdentificador['identificadorativo'] == "1") {
				$identificadortextoToSave = $responseIdentificador['identificadortexto'];
			}

			/* Insere o contato no banco de dados*/
			$sql = 'INSERT INTO TBL_LEADS (ID_CLIENTE_FK,TXT_NOME,TXT_EMAIL,NU_TELEFONE1,DT_DATA_MSG,DT_HORA_MSG,TXT_LEAD_RAMO,TXT_LEAD_CLIENTE,TXT_LEADTIPO,TXT_IDENTIFICADOR)
						VALUES (:ID_CLIENTE_FK,:TXT_NOME,:TXT_EMAIL,:NU_TELEFONE1,:DT_DATA_MSG,:DT_HORA_MSG,:TXT_LEAD_RAMO,:TXT_LEAD_CLIENTE,:TXT_LEADTIPO,:TXT_IDENTIFICADOR)';
			$params = array(
				':ID_CLIENTE_FK' => $id_cliente,
				':TXT_NOME' => $nome,
				':TXT_EMAIL' => $email,
				':NU_TELEFONE1' => $telefone,
				':DT_DATA_MSG' => $dia,
				':DT_HORA_MSG' => $hora,
				':TXT_LEAD_RAMO' => $tags_cliente,
				':TXT_LEAD_CLIENTE' => $login_cliente,
				':TXT_LEADTIPO' => "SMS",
				':TXT_IDENTIFICADOR' => $identificadortextoToSave
			);

			/* Salva o lead acima no banco */
			$this->sistema->bd_leads->executar($sql, $params);

			/* Verifica se existe algum id de Email para a busca, se não tiver, pula o envio de email */
			if ($idemails != null) {

				/* Busca os emails salvos no sistema win7 */
				$response = $this->buscarEmailsSalvosSitemaWin7($id_cliente, $idemails);

				/* Limpa os caracteres especiais do telefone */
				$telefoneFormatado = preg_replace('/[^A-Za-z0-9]/', '', trim($telefone));

				switch ($idioma) {
					case 'en':/* Configura a mensagem do link do WhatsApp */
						$msgUrlSMS = $isNomeNull ? 'Hi! How can we help?' : "Hi, " . $nome . "!";

						/* Monsta a mensagem do e-mail */
						$msgEmailCliente = '
							<div style="color: #dc143c;background-color: #fff4f4;padding: 1px 16px;border-radius: 5px;"><p><i><b>ATTENTION:</b> Please do not reply to this email!<br>
							This email is sent and authenticated by our automatic system, so to respond to the customer, contact the number below.</i></p></div><hr style="border: none;height: 2px;background-color: #d8d8d8;"><br>
							<p><b>SMS SEND NOTICE</b></p>';
						$msgEmailCliente .= !$isNomeNull ? '<p><b>NAME:</b> ' . $nome . '</p>' : '';
						$msgEmailCliente .= $email != "" ? '<p><b>EMAIL:</b> ' . $email . '</p>' : '';
						$msgEmailCliente .= '<p><b>Phone/SMS:</b> ' . $telefone . '</p><br>
							<hr style="border: none;height: 2px;background-color: #d8d8d8;">
							<p>Filled in by ' . $this->sistema->maquina_usuario . '</p>
							<hr style="border: none;height: 2px;background-color: #d8d8d8;"><br>
							<a href="tel:' . $telefoneFormatado . '" target="_blank" style="background-color: #00BCD4;padding: 8px 12px;border-radius: 40px;color: white;text-decoration: none;line-height: 34px;">☎ Click to call: ' . $telefone . ' </a><br><a href="sms:' . $telefoneFormatado . '&body=' . $msgUrlSMS . '" target="_blank" style="background-color: #31c558;padding: 8px 12px;border-radius: 40px;color: white;text-decoration: none;line-height: 34px;">📱 Click to send SMS</a>';
						break;

					case 'es':
						/* Configura a mensagem do link do WhatsApp */
						$msgUrlSMS = $isNomeNull ? '¡Hola! ¿Cómo podemos ayudar?' : "¡Hola, " . $nome . "!";

						/* Monsta a mensagem do e-mail */
						$msgEmailCliente = '
							<div style="color: #dc143c;background-color: #fff4f4;padding: 1px 16px;border-radius: 5px;"><p><i><b>ADVERTENCIA:</b> ¡Por favor no responder a este email!<br>
							Este correo electrónico es enviado y autenticado por nuestro sistema automático, por lo que para responder al cliente, comuníquese con el número a continuación.</i></p></div><hr style="border: none;height: 2px;background-color: #d8d8d8;"><br>
							<p><b>AVISO DE ENVÍO DE SMS</b></p>';
						$msgEmailCliente .= !$isNomeNull ? '<p><b>NOMBRE:</b> ' . $nome . '</p>' : '';
						$msgEmailCliente .= $email != "" ? '<p><b>EMAIL:</b> ' . $email . '</p>' : '';
						$msgEmailCliente .= '<p><b>Teléfono/SMS:</b> ' . $telefone . '</p><br>
							<hr style="border: none;height: 2px;background-color: #d8d8d8;">
							<p>Llenado por ' . $this->sistema->maquina_usuario . '</p>
							<hr style="border: none;height: 2px;background-color: #d8d8d8;"><br>
							<a href="tel:' . $telefoneFormatado . '" target="_blank" style="background-color: #00BCD4;padding: 8px 12px;border-radius: 40px;color: white;text-decoration: none;line-height: 34px;">☎ Haz clic para llamar: ' . $telefone . ' </a><br><a href="sms:' . $telefoneFormatado . '&body=' . $msgUrlSMS . '" target="_blank" style="background-color: #31c558;padding: 8px 12px;border-radius: 40px;color: white;text-decoration: none;line-height: 34px;">📱 Haga clic para enviar SMS</a>';
						break;

					case 'pt':
						/* Configura a mensagem do link do WhatsApp */
						$msgUrlSMS = $isNomeNull ? 'Olá! Em que podemos ajudar?' : "Olá " . $nome . "!";

						/* Monsta a mensagem do e-mail */
						$msgEmailCliente = '
							<div style="color: #dc143c;background-color: #fff4f4;padding: 1px 16px;border-radius: 5px;"><p><i><b>ATENÇÃO:</b> Por favor, não responda esse e-mail!<br>
							Esse e-mail é enviado e autenticado pelo nosso sistema automático, por isso, para responder ao cliente,	entre em contato pelo número abaixo.</i></p></div><hr style="border: none;height: 2px;background-color: #d8d8d8;"><br>
							<p><b>AVISO DE ENVIO DE SMS</b></p>';
						$msgEmailCliente .= !$isNomeNull ? '<p><b>NOME:</b> ' . $nome . '</p>' : '';
						$msgEmailCliente .= $email != "" ? '<p><b>EMAIL:</b> ' . $email . '</p>' : '';
						$msgEmailCliente .= '<p><b>Telefone/SMS:</b> ' . $telefone . '</p><br>
							<hr style="border: none;height: 2px;background-color: #d8d8d8;">
							<p>Preenchido pelo ' . $this->sistema->maquina_usuario . '</p>
							<hr style="border: none;height: 2px;background-color: #d8d8d8;"><br>
							<a href="tel:' . $telefoneFormatado . '" target="_blank" style="background-color: #00BCD4;padding: 8px 12px;border-radius: 40px;color: white;text-decoration: none;line-height: 34px;">☎ Clique para ligar: ' . $telefone . ' </a><br><a href="sms:' . $telefoneFormatado . '&body=' . $msgUrlSMS . '" target="_blank" style="background-color: #31c558;padding: 8px 12px;border-radius: 40px;color: white;text-decoration: none;line-height: 34px;">📱 Clique para enviar SMS</a>';
						break;

					default:
						/* Configura a mensagem do link do WhatsApp */
						$msgUrlSMS = $isNomeNull ? 'Olá! Em que podemos ajudar?' : "Olá " . $nome . "!";

						/* Monsta a mensagem do e-mail */
						$msgEmailCliente = '
						<div style="color: #dc143c;background-color: #fff4f4;padding: 1px 16px;border-radius: 5px;"><p><i><b>ATENÇÃO:</b> Por favor, não responda esse e-mail!<br>
						Esse e-mail é enviado e autenticado pelo nosso sistema automático, por isso, para responder ao cliente,	entre em contato pelo número abaixo.</i></p></div><hr style="border: none;height: 2px;background-color: #d8d8d8;"><br>
						<p><b>AVISO DE ENVIO DE SMS</b></p>';
						$msgEmailCliente .= !$isNomeNull ? '<p><b>NOME:</b> ' . $nome . '</p>' : '';
						$msgEmailCliente .= $email != "" ? '<p><b>EMAIL:</b> ' . $email . '</p>' : '';
						$msgEmailCliente .= '<p><b>Telefone/SMS:</b> ' . $telefone . '</p><br>
						<hr style="border: none;height: 2px;background-color: #d8d8d8;">
						<p>Preenchido pelo ' . $this->sistema->maquina_usuario . '</p>
						<hr style="border: none;height: 2px;background-color: #d8d8d8;"><br>
						<a href="tel:' . $telefoneFormatado . '" target="_blank" style="background-color: #00BCD4;padding: 8px 12px;border-radius: 40px;color: white;text-decoration: none;line-height: 34px;">☎ Clique para ligar: ' . $telefone . ' </a><br><a href="sms:' . $telefoneFormatado . '&body=' . $msgUrlSMS . '" target="_blank" style="background-color: #31c558;padding: 8px 12px;border-radius: 40px;color: white;text-decoration: none;line-height: 34px;">📱 Clique para enviar SMS</a>';
				}

				/* Registra o email do cliente para envio */
				try {
					$id_email = Sistema::registrar_email($msgEmailCliente, $response['assuntoemail'], $response['destinatarios'], $response['copiasocultas'], "Não Responda", "nao-responda@win7.com.br", $arquivo, Sistema::TIPO_EMAIL_CLIENTE);
				} catch (Exception $e) {
					try {
						$this->sistema->bd->executar("DELETE FROM TBL_ENVIO_EMAIL WHERE NU_ID = :id", array(':id' => $id_email));
					} catch (Exception $e) {
					}
					return self::FALHOU_ENVIO_EMAIL_CLIENTE;
				}
			}
		} catch (Exception $e) {
		}
	}



	/* Função que faz a busca dos e-mails configurados no sistemawin7 */
	function buscarEmailsSalvosSitemaWin7($id_cliente, $idemails)
	{

		try {

			$this->sistema->iniciar_bd_leads();

			// Variável que vai armazenar o tipo do erro
			$codigoErro = '';

			/* Obtém os dados do cliente */
			$forms_dados = $this->sistema->bd_leads->executar("SELECT TXT_FORMS, NU_FORMS_ATIVADO, TXT_NOME_EMPRESA FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $id_cliente), Banco_Dados::FETCH_ALL);

			// Verifica se o código informado existe para esse cliente
			if (!preg_match("/{$idemails}/i", $forms_dados[0]['TXT_FORMS'])) {
				// echo '<p>Nenhum e-mail configurado!</p>';
				// return false;
				$codigoErro = '0';
			}

			/* INÍCIO DO ALGORÍTIMO QUE FAZ A BUSCA DOS EMAILS DO CLIENTE E DOS EMAILS OCULTOS DA WIN7 */
			$formularioSelecionado = [];

			/* EMAILS DA EMPRESA QUE RECEBE OS CONTATOS DO FORMULARIO */
			$destinatarios = [];

			/** Os e-mails abaixo recebem uma copia oculta **/
			$copiasOcultas = [];

			foreach ($forms_dados as $row) {

				// Verifica se esse cliente está com os novos formulários ativado, se sim, busca os e-mails do sistemawin7
				if ($row['NU_FORMS_ATIVADO'] == 1) {

					// Pega os formulários existentes
					$forms = explode("|#|", $row['TXT_FORMS']);
					// Verifica se exisite a string dos formulários configurados
					if ($forms[0] != "") {

						// Varre os formulários
						for ($i = 0; $i <= count($forms) - 1; $i++) {

							// Explode o array para dividir 3 partes (formDadosTopo, formEmailsOcultos, formEmailsCliente)
							$formDados = explode("|@|", $forms[$i]);
							$formDadosTopo = explode("|$|", $formDados[0]);

							// Verifica se existe algum formulário com o ID do formulario informado
							if ($formDadosTopo[1] == $idemails) {

								$formEmailsOcultos = explode("|$|", $formDados[1]);
								$formEmailsCliente = explode("|%|", $formDados[2]);

								// $formularioSelecionado['nome'] = $formDadosTopo[0]; // nao usado
								// $formularioSelecionado['id'] = $formDadosTopo[1]; // nao usado
								$formularioSelecionado['nomeempresa'] = $formDadosTopo[2];
								$formularioSelecionado['assuntoemail'] = $formDadosTopo[3];
								$formularioSelecionado['formorganico'] = $formDadosTopo[4];
								$formularioSelecionado['emailsocultos'] = $formEmailsOcultos;
								$formularioSelecionado['emails'] = [];

								// Varre os emails e junta todos na vetor emails abaixo
								for ($j = 0; $j <= count($formEmailsCliente) - 1; $j++) {
									array_push($formularioSelecionado['emails'], explode("|$|", $formEmailsCliente[$j]));
								}
							}
						} // fim do for que varre os formularios
					} else {
						// Formulário vazio, o cliente não tem nada configurado ainda ou algum bug aconteceu e não salvou nada na hora de salvar lá no sistemawin7
						$codigoErro = '1';
					}
				} else {
					// Nenhum formulário configurado no sistemawin7 para esse cliente no momento
					// Tudo indica que ele ainda está usando a forma antiga dos formulário
					// echo 'Erro ao enviar formulário #3';
					$codigoErro = '2';
					// return false;
				}
			}

			// Loop para buscar todos os e-mails do cliente configurados no sistemaWin7
			foreach ($formularioSelecionado['emails'] as $dadosEmailsCliente) {

				// $dadosEmailsCliente[0]; // nome
				// $dadosEmailsCliente[1]; // email
				// $dadosEmailsCliente[2]; // enviar ou nao (0 ou 1)

				// Verifica se é para enviar o e-mail para esse e-mail ou não
				if ($dadosEmailsCliente[2] != 0) {
					// Se sim, adiciona ele no array de DESTINATÁRIOS
					// Obs.: Pode acontecer de nao ter nenhum destinaraio, daí a variável fica com um array vazio mesmo
					$destinatarios += [$dadosEmailsCliente[1] => $dadosEmailsCliente[0]];
				}
			}

			// Verifica se existe pelo menos 1 email oculto para entrar no <if>
			// Isso evita erros no explode
			if ($formularioSelecionado['emailsocultos'][0] != '--') {
				// Loop para buscar todos os e-mails ocultos configurados no sistemaWin7
				foreach ($formularioSelecionado['emailsocultos'] as $emailOcultoWin7) {
					// Pega o nome do usuário do e-mail até o @
					$usuarioDoEmailOculto = explode("@", $emailOcultoWin7);
					$copiasOcultas += [$emailOcultoWin7 => $usuarioDoEmailOculto[0]];
				}
			}

			// Verifica se não existem email do cliente e emails ocultos na win7 configurados
			// Se não existir nenhum dos dois, eu seto um e-mail para não bugar o envio do e-mail, que espera-se pelo menos um argumento para pode enviar o e-mail e não dar erro
			if (count($destinatarios) == 0 && $formularioSelecionado['emailsocultos'][0] == '--') {
				$destinatarios += ['desenvolvimento@grupolead.com.br' => 'Desenvolvimento'];
			}

			/* Nome da empresa */
			$empresaNome = $formularioSelecionado['nomeempresa'];

			/* Assunto do e-mail para o LEAD */
			$empresaAssunto = "Contato " . $formularioSelecionado['nomeempresa'];

			/* Assunto do e-mail  */
			$assuntoEmail = $formularioSelecionado['formorganico'] == 0 ? $formularioSelecionado['assuntoemail'] . ' - Anúncios Google/Agência Win7 - ' . date('d/m/Y H:i:s') : $formularioSelecionado['assuntoemail'] . ' - ' . date('d/m/Y H:i:s');

			/* Faz a verificação de erros */
			$destinatariosDosErros = [
				'desenvolvimento@grupolead.com.br' => 'Desenvolvimento',
				'vinicius.dourado@win7.com.br' => 'Vinícius'
			];

			if ($codigoErro == '0') {

				return [
					"empresanome" => $forms_dados[0]['TXT_NOME_EMPRESA'],
					"empresaassunto" => "Contato " . $forms_dados[0]['TXT_NOME_EMPRESA'],
					"assuntoemail" => "Erro [#0][Código do form não existe] no cliente: " . $id_cliente . " / formid: " . $idemails . " / local: " . $_SERVER["REQUEST_URI"] . " / " . date('d/m/Y H:i:s'),
					"copiasocultas" => [],
					"destinatarios" => $destinatariosDosErros,
					"erro" => "1"
				];
			} else if ($codigoErro == '1') {

				return [
					"empresanome" => $forms_dados[0]['TXT_NOME_EMPRESA'],
					"empresaassunto" => "Contato " . $forms_dados[0]['TXT_NOME_EMPRESA'],
					"assuntoemail" => "Erro [#1][Formulário vazio] no cliente: " . $id_cliente . " / formid: " . $idemails . " / local: " . $_SERVER["REQUEST_URI"] . " / " . date('d/m/Y H:i:s'),
					"copiasocultas" => [],
					"destinatarios" => $destinatariosDosErros,
					"erro" => "1"
				];
			} else if ($codigoErro == '2') {

				return [
					"empresanome" => $forms_dados[0]['TXT_NOME_EMPRESA'],
					"empresaassunto" => "Contato " . $forms_dados[0]['TXT_NOME_EMPRESA'],
					"assuntoemail" => "Erro [#2][Formulário não configurado] no cliente: " . $id_cliente . " / formid: " . $idemails . " / local: " . $_SERVER["REQUEST_URI"] . " / " . date('d/m/Y H:i:s'),
					"copiasocultas" => [],
					"destinatarios" => $destinatariosDosErros,
					"erro" => "1"
				];
			} else {

				// Retorna os dados para o form
				return [
					"empresanome" => $empresaNome,
					"empresaassunto" => $empresaAssunto,
					"assuntoemail" => $assuntoEmail,
					"copiasocultas" => $copiasOcultas,
					"destinatarios" => $destinatarios,
					"erro" => "0"
				];
			}
		} catch (Exception $e) {
		}
	}


	/* Função que faz a busca do identificador do form/whats no sistemawin7 */
	function buscarFormWhatsIdentificadorSitemaWin7($id_cliente, $idemails)
	{

		try {

			$this->sistema->iniciar_bd_leads();

			// Variável que vai armazenar o tipo do erro
			$codigoErro = '';

			$formIdentificadorTexto = "";
			$formIdentificadorAtivo = "0";

			/* Obtém os dados do cliente */
			$forms_dados = $this->sistema->bd_leads->executar("SELECT TXT_FORMS, NU_FORMS_ATIVADO, TXT_NOME_EMPRESA FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $id_cliente), Banco_Dados::FETCH_ALL);

			// Verifica se o código informado existe para esse cliente
			if (!preg_match("/{$idemails}/i", $forms_dados[0]['TXT_FORMS'])) {
				// echo '<p>Nenhum e-mail configurado!</p>';
				// return false;
				$codigoErro = '0';
				// Retorna os dados para o form
				return [
					"identificadortexto" => $formIdentificadorTexto,
					"identificadorativo" => $formIdentificadorAtivo,
				];
			}

			foreach ($forms_dados as $row) {

				// Verifica se esse cliente está com os novos formulários ativado, se sim, busca os e-mails do sistemawin7
				if ($row['NU_FORMS_ATIVADO'] == 1) {

					// Pega os formulários existentes
					$forms = explode("|#|", $row['TXT_FORMS']);
					// Verifica se exisite a string dos formulários configurados
					if ($forms[0] != "") {

						// Varre os formulários
						for ($i = 0; $i <= count($forms) - 1; $i++) {

							// Explode o array para dividir 4 partes (0 formDadosTopo, 1 formEmailsOcultos, 2 formEmailsCliente, 3 formIdentificador)
							$formDados = explode("|@|", $forms[$i]);
							$formDadosTopo = explode("|$|", $formDados[0]);

							// Verifica se existe algum formulário com o ID do formulario informado
							if ($formDadosTopo[1] == $idemails) {

								$formIdentificador = explode("|$|", $formDados[3]);

								$formIdentificadorTexto = $formIdentificador[0];
								$formIdentificadorAtivo = $formIdentificador[1];
							}
						} // fim do for que varre os formularios
					} else {
						// Formulário vazio, o cliente não tem nada configurado ainda ou algum bug aconteceu e não salvou nada na hora de salvar lá no sistemawin7
						$codigoErro = '1';
					}
				} else {
					// Nenhum formulário configurado no sistemawin7 para esse cliente no momento
					// Tudo indica que ele ainda está usando a forma antiga dos formulário
					// echo 'Erro ao enviar formulário #3';
					$codigoErro = '2';
					// return false;
				}
			}

			// Retorna os dados para o form
			return [
				"identificadortexto" => $formIdentificadorTexto,
				"identificadorativo" => $formIdentificadorAtivo,
			];
		} catch (Exception $e) {
			return [
				"identificadortexto" => "",
				"identificadorativo" => "0",
			];
		}
	}
}
?>