<?php
/***
	Este arquivo exibe a tela de login padrão do sistema win7, 
	que é acessada por nossos clientes.
***/

require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::GOOGLE_DRIVE);
$sistema = new Sistema();

// Caso o cliente já esteja logado, enviamos ele para a home
if($sistema->sessao->logado()) $sistema->redirecionar("home"); 
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<meta name='theme-color' content="<?php echo $sistema->drive->cor2; ?>">
	<title><?php echo $sistema->drive->nome_sistema; ?> <?php echo $sistema->drive->nome; ?></title>
	<link rel="icon" type="image/ico" href="<?php echo $sistema->drive->favicon; ?>" />
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/ionicons.min.css">
	<link rel="stylesheet" href="css/AdminLTE.min.css">
	<link rel="stylesheet" href="css/custom-not-logged.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->exibir_css_drive_index();?>
</head>

<body class="hold-transition login-page" style="height: auto;">
	<div class="login-box">
		<div class="login-logo">
			<a href="./"><img src="<?php echo $sistema->drive->logo; ?>" width="150"></a>
		</div>
		<div class="login-box-body">
			<?php if(isset($_SESSION['errologin'])) { ?>
			<div class="alert alert-danger alert-dismissible">
				<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
				<?php
				switch($_SESSION['errologin']){
					case 0:
						echo "Houve um erro ao conectar com o servidor! Atualize a página e tente novamente.";
						break;
					case 1:
						echo "Usuário ou Senha incorretos! Tente novamente.";
						break;
					case 3:
						echo "Faça login para acessar o sistema!";
						break;
					case 4:
						echo "Houve um erro ao acessar o servidor!";
						break;
				}
				?>
			</div>
			<?php unset($_SESSION['errologin']); } ?>
			<div class="cabecalho"><p class="login-box-msg">Faça login para acessar o sistema</p></div>
			<form action="action/login" method="post">
				<div class="form-group has-feedback">
					<input id="usuario" name="usuario" type="text" class="form-control" alt="Usuário" placeholder="Login" required>
        			<span class="glyphicon glyphicon-user form-control-feedback"></span>
				</div>
				<div class="form-group has-feedback">
					<input id="senha" name="senha" type="password" class="form-control" alt="Senha" placeholder="Senha" required>
        			<span class="glyphicon glyphicon-lock form-control-feedback"></span>
				</div>
				<div class="row">
					<div class="col-xs-12">
						<button type="submit" class="btn btn-primary btn-block btn-flat">Entrar</button>
					</div>
				</div>
			</form>
		</div>
	</div>
	<script src="js/jquery.min.js"></script>
	<script src="js/bootstrap.min.js"></script>
</body>
</html>