<?php
require_once(__DIR__ . "/classes/Sistema.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true);

// Permissão apenas para admins e/ou Redireciona o cliente para a home caso ele não tenha permissão de acesso às campanhas do google
if (!isset($sistema->usuario->permissao_comparacao_adm) == true || ($sistema->usuario->permissao_comparacao_adm == Usuario::PERM_NENHUMA) == true) {
    if ($sistema->usuario->permissao_comparacao == Usuario::PERM_NENHUMA && (($sistema->usuario->permissao_dados_gerais == Usuario::PERM_ESCRITA) || ($sistema->usuario->permissao_dados_gerais == Usuario::PERM_LEITURA))) {
        $sistema->redirecionar("home");
    }
}

?>
<!DOCTYPE html>
<html>

<head>
    <!-- Google Tag Manager -->
    <script>
        (function(w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                'gtm.start': new Date().getTime(),
                event: 'gtm.js'
            });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s),
                dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src =
                'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', 'GTM-MFFM5J3');
    </script>
    <!-- End Google Tag Manager -->
    <script>
    (function() {
      try {
        var theme = localStorage.getItem('theme');
        if (!theme) {
          theme = window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light';
        }
        document.documentElement.setAttribute('data-theme', theme);
      } catch (e) {}
    })();
  </script>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <title>Dados Gerais - Sistema Win7</title>
    <link rel="icon" type="image/ico" href="favicon.png" />
    <link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap-xl-xxl.css">
    <link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/font-awesome.min.css">
    <link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/ionicons.min.css">
    <link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/AdminLTE.min.css">
    <link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/skin-blue.min.css">
    <link rel="stylesheet" href="css/custom2.0.1.css">
    <link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/toastr.min.css">
    <link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap-datepicker.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <?php $sistema->layout->criar_meta_tags(); ?>
</head>

<body data-theme="dark" class="hold-transition skin-blue sidebar-mini <?php if ($sistema->usuario->sidebar) {
                                                        echo "sidebar-collapse";
                                                    } ?>">

    <!-- Google Tag Manager (noscript) -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MFFM5J3" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->
    <div class="wrapper referencia-fixar-datas">
        <?php $sistema->layout->exibir_cabecalho('geral-comparacao'); ?>

        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    Dados Gerais Comparação
                    <small>Veja o comparativo dos dados mais importantes de suas campanhas</small>
                </h1>
                <ol class="breadcrumb">
                    <li><a href="javascript:void(0)"><i class="fa green-text fa-google"></i> Anúncios Google</a></li>
                    <li><a href="geral"><i class="fa fa-bar-chart"></i> Dados Gerais Comparação</a></li>
                </ol>
            </section>

            <section class="content container-fluid">
                <form action="" method="POST" id="formHome">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="box">
                                <div class="box-body">
                                    <div class="row">
                                        <div class="col-xl-3 col-xl-3 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                            <label>Período 1: <span style="color:red; font-style: italic;">(obrigatório)</span></label>
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-calendar"></i>
                                                    </div>
                                                    <input type="text" class="form-control pull-right datepicker" name="datainicial1" id="datainicial1" placeholder="Data Inicial:" value="<?php echo $sistema->filtro->data_inicio(); ?>">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-calendar"></i>
                                                    </div>
                                                    <input type="text" class="form-control pull-right datepicker" class="datepicker" name="datafinal1" id="datafinal1" placeholder="Data Final:" value="<?php echo $sistema->filtro->data_fim(); ?>">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-xl-3 col-xl-3 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                            <label>Período 2:</label>
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-calendar"></i>
                                                    </div>
                                                    <input type="text" class="form-control pull-right datepicker" name="datainicial2" id="datainicial2" placeholder="Data Inicial:" value="<?php echo $sistema->filtro->data_3(); ?>">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-calendar"></i>
                                                    </div>
                                                    <input type="text" class="form-control pull-right datepicker" class="datepicker" name="datafinal2" id="datafinal2" placeholder="Data Final:" value="<?php echo $sistema->filtro->data_4(); ?>">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-xl-3 col-xl-3 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                            <label>Período 3:</label>
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-calendar"></i>
                                                    </div>
                                                    <input type="text" class="form-control pull-right datepicker" name="datainicial3" id="datainicial3" placeholder="Data Inicial:" value="<?php echo $sistema->filtro->data_5(); ?>">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-calendar"></i>
                                                    </div>
                                                    <input type="text" class="form-control pull-right datepicker" class="datepicker" name="datafinal3" id="datafinal3" placeholder="Data Final:" value="<?php echo $sistema->filtro->data_6(); ?>">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-xl-3 col-xl-3 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                            <label>Período 4:</label>
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-calendar"></i>
                                                    </div>
                                                    <input type="text" class="form-control pull-right datepicker" name="datainicial4" id="datainicial4" placeholder="Data Inicial:" value="<?php echo $sistema->filtro->data_7(); ?>">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-calendar"></i>
                                                    </div>
                                                    <input type="text" class="form-control pull-right datepicker" class="datepicker" name="datafinal4" id="datafinal4" placeholder="Data Final:" value="<?php echo $sistema->filtro->data_8(); ?>">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-6 col-xs-12">

                                            <div class="input-group">
                                                <div class="input-group-addon"><i class="fa fa-filter"></i></div>
                                                <select name="selectFiltro" id="selectFiltro" class="form-control pull-right">
                                                    <option value="personalizado" selected>Personalizado</option>
                                                    <option value="ultimosDiasESubs">Últimos [?] dias e anteriores</option>
                                                    <option value="esteMesESubs">Este mês e anteriores</option>
                                                    <option value="esteMesAteHojeESubs">Este mês até hoje e anteriores</option>
                                                    <option value="esteMesAteOntemESubs">Este mês até ontem e anteriores</option>
                                                    <option value="mesPassadoESubs">Mês passado e anteriores</option>
                                                    <optgroup label="Dia da Semana:">
                                                    <option value="ultimas1DiaSemana4MesesESubs">Últimas 1ªs [?] dos últimos 4 meses</option>
                                                    <option value="ultimas2DiaSemana4MesesESubs">Últimas 2ªs [?] dos últimos 4 meses</option>
                                                    <option value="ultimas3DiaSemana4MesesESubs">Últimas 3ªs [?] dos últimos 4 meses</option>
                                                    <option value="ultimas4DiaSemana4MesesESubs">Últimas 4ªs [?] dos últimos 4 meses</option>
                                                    </optgroup>
                                                    <optgroup label="Fins de Semana:">
                                                    <option value="ultimosFinsDeSemana">Últimos 4 fins de semana</option>
                                                    <option value="ultimas1FimDeSemana4MesesESubs">Últimos 1ºs Fins de Semana dos últimos 4 meses</option>
                                                    <option value="ultimas2FimDeSemana4MesesESubs">Últimos 2ºs Fins de Semana dos últimos 4 meses</option>
                                                    <option value="ultimas3FimDeSemana4MesesESubs">Últimos 3ºs Fins de Semana dos últimos 4 meses</option>
                                                    <option value="ultimas4FimDeSemana4MesesESubs">Últimos 4ºs Fins de Semana dos últimos 4 meses</option>
                                                    </optgroup>
                                                    <optgroup label="Dias Úteis:">
                                                    <option value="ultimasSemanasDiasUteis">Últimas 4 semanas dias úteis</option>
                                                    <option value="ultimas1SemanaDiasUteis4MesesESubs">Últimas 1ªs Semana Dias Úteis dos últimos 4 meses</option>
                                                    <option value="ultimas2SemanaDiasUteis4MesesESubs">Últimas 2ªs Semana Dias Úteis dos últimos 4 meses</option>
                                                    <option value="ultimas3SemanaDiasUteis4MesesESubs">Últimas 3ªs Semana Dias Úteis dos últimos 4 meses</option>
                                                    <option value="ultimas4SemanaDiasUteis4MesesESubs">Últimas 4ªs Semana Dias Úteis dos últimos 4 meses</option>
                                                    </optgroup>
                                                </select>
                                            </div>

                                            
                                        </div>

                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-6 col-xs-12">

                                            <div class="form-group" id="qtdUltimosDiasContainer" style="display: none;">
                                                <div class="input-group date">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-filter"></i>
                                                    </div>
                                                    <input type="number" class="form-control pull-right" id="qtdUltimosDias" name="qtdUltimosDias" min="1" max="90" step="1" value="7"  >
                                                </div>
                                            </div>

                                            <div class="input-group" id="selectFiltroDiaSemanaContainer" style="display: none;">
                                                <div class="input-group-addon"><i class="fa fa-filter"></i></div>
                                                    <select name="selectFiltroDiaSemana" id="selectFiltroDiaSemana" class="form-control pull-right" >
                                                        <option value="segunda" selected>Segundas-feiras</option>
                                                        <option value="terca">Terças-feiras</option>
                                                        <option value="quarta">Quartas-feiras</option>
                                                        <option value="quinta">Quintas-feiras</option>
                                                        <option value="sexta">Sextas-feiras</option>
                                                        <option value="sabado">Sábados</option>
                                                        <option value="domingo">Domingos</option>
                                                    </select>
                                                </div>
                                            </div>

                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                            <div class="checkbox">
                                                <label>
                                                    <input type="checkbox" name="display" id="switch" class="buscarAPI" value="s" checked>
                                                    Incluir Display
                                                </label>
                                            </div>
                                        </div>

                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                            <a id="datapersonalizada" class="btn btn-block btn-primary btn-flat">Buscar e Comparar</a>
                                        </div>

                                    </div>
                                </div>
                                <div class="overlay preloader">
                                    <i class="fa fa-refresh fa-spin"></i>
                                </div>
                            </div>
                        </div>

                        <!-- PERIODOS -->
                        <div id="periodos">

                </form>
        </div>

    </div>
    </section>
    </div>

    <?php $sistema->layout->exibir_rodape(); ?>
    </div>

    <script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/jquery.min.js"></script>
    <script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap.min.js"></script>
    <script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/adminlte.min.js"></script>
    <script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap-datepicker.min.js"></script>
    <script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap-datepicker.pt-BR.min.js"></script>
    <script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/toastr.min.js"></script>
    <script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/jquery.mask.min.js"></script>
    <script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/filtros.js"></script>
    <script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/geral-comparacao1.0.0.js"></script>

</body>

</html>