<?php
/***
	Este arquivo exibe a tela de login padrão do sistema win7, 
	que é acessada por nossos clientes.
***/

require_once(__DIR__ . "/classes/Sistema.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema();

// Caso o cliente já esteja logado, enviamos ele para a home
if($sistema->sessao->logado()) $sistema->redirecionar("home"); 

// Garante que somente o login de demonstração pode ser usado no GET
if (isset($_GET['l'])) { if($_GET['l'] != "demonstracao") unset($_GET['l']); }
if (isset($_GET['s'])) { if($_GET['s'] != "123456") unset($_GET['s']); }
?>

<!DOCTYPE html>
<html>
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-MFFM5J3');</script>
<!-- End Google Tag Manager -->
<script>
    (function() {
      try {
        var theme = localStorage.getItem('theme');
        if (!theme) {
          theme = window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light';
        }
        document.documentElement.setAttribute('data-theme', theme);
      } catch (e) {}
    })();
  </script>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<title>Login - Sistema Win7</title>
	<link rel="icon" type="image/ico" href="favicon.png" />
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/ionicons.min.css">
	<link rel="stylesheet" href="css/AdminLTE.min.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">

    <meta name="description" content="Sistema criado e disponibilizado pela Agência Win7 para você acompanhar os resultados da sua empresa no Google Ads em tempo real." />
    <link rel="shortcut icon" href="https://google.win7.com.br/imgLink.png" type="image/png"/>
    <link rel="apple-touch-icon" href="https://google.win7.com.br/imgLink.png" type="image/png"/>
    <meta property="og:image" content="https://google.win7.com.br/imgLink.png">
    <meta property="og:image:type" content="image/png">
    <meta property="og:type" content="website">

	<?php $sistema->layout->criar_meta_tags();?>
</head>

<body data-theme="dark" class="hold-transition login-page" >
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MFFM5J3"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
	<div class="login-box">
		<div class="login-logo">
			<a href="./"><img src="img/logo.png"></a>
		</div>
		<div class="login-box-body">
			<?php if(isset($_SESSION['errologin'])) { ?>
			<div class="alert alert-danger alert-dismissible">
				<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
				<?php
				switch($_SESSION['errologin']){
					case 0:
						echo "Login ou senha estão incorretos!";
						break;
					case 1:
						echo "Ocorreu um erro com o servidor!";
						break;
					case 2:
						echo "É necessário logar para ver esta página!";
						break;
				}
				?>
			</div>
			<?php unset($_SESSION['errologin']); } ?>
			<p class="login-box-msg">Faça login para acessar o sistema</p>

			<form action="action/login" method="post">
				<div class="form-group has-feedback">
					<input id="usuario" name="usuario" type="text" class="form-control" alt="Usuário" title="Insira um nome de usuário." value="<?php if(isset($_GET['l'])){ echo $_GET['l'];} ?>" placeholder="Usuário" autocomplete="off" autocorrect="off" autocapitalize="off" required>
        			<span class="glyphicon glyphicon-user form-control-feedback"></span>
				</div>
				<div class="form-group has-feedback">
					<input id="senha" name="senha" type="password" class="form-control" alt="Senha" title="Insira sua senha." value="<?php if(isset($_GET['s'])) {echo $_GET['s'];} ?>" placeholder="Senha" autocomplete="off" autocorrect="off" autocapitalize="off" required>
        			<span class="glyphicon glyphicon-lock form-control-feedback"></span>
					<span toggle="#password-field" class="glyphicon glyphicon-eye-open toggle-password" style="float: right;margin: -24px 36px 0px 0px;cursor:pointer;"></span>
				</div>
				<div class="row">
					<div class="col-xs-12">
						<button type="submit" class="btn btn-primary btn-block btn-flat">Entrar</button>
					</div>
				</div>
				<br><p style="text-align: center;margin:0;padding:0">

					Deseja ter um sistema como esse?<br><b>Fale conosco!</b> <a href="tel:6137720710">(61) 3772-0710</a>
				</p>
			</form>
		</div>
	</div>
	<script src="js/jquery.min.js"></script>
	<script src="js/bootstrap.min.js"></script>
	<script>
		$(document).on('click', '.toggle-password', function() {
			$(this).toggleClass("glyphicon-eye-close");
			var input = $("#senha");
			input.attr('type') === 'password' ? input.attr('type','text') : input.attr('type','password')
		});
	</script>
</body>
</html>