<?php
/*
 * Este arquivo é responsável por montar a modal que serve para editar uma indicação especificada.
 */

require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema(true, true);

if(empty($sistema->usuario->senha_transf)) $sistema->redirecionar("../senha-transferencia");

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

if(!$sistema->indicacoes->indicador_possui_permissao($sistema->usuario->id, $_POST['id'])){
	echo "-2ID inválida!";
	exit;
}

try{
	// Obtém os dados do usuário no banco de dados
	$dados = $sistema->indicacoes->obter_usuario($_POST['id']);

	if($sistema->bd->quantidade() == 0){ // Os dados não foram encontrados, então a ID é inválida
		echo "-2ID inválida!";
		exit;
	}
	
	// Prepara os dados para a exibição no modal
	$nome = $dados['TXT_NOME'];
	$telefone = $dados['TEL_CEL'];
	$email = $dados['TXT_EMAIL'];
	$flag_cpf = strlen($dados['NU_CPF']) == 11;
	$cpf = Mascara::mascara_cpf_cnpj($dados['NU_CPF']);
	$status = $dados['TXT_STATUS'];
	$qualidade = $dados['TXT_QUALIDADE'];

	// Formata os valores monetários
	$fechado = number_format(floatval($dados['VALOR_FECHADO']/100),2,',','.');
	$combinado = number_format(floatval($dados['VALOR_COMBINADO']/100),2,',','.');
	$saldo = number_format(floatval($dados['TXT_SALDO']/100),2,',','.');

	// Se o sistema for do tipo de faculdades, carrega os dados específicos desse sistema
	if($sistema->indicacoes->tipo ==  Sistema_Indicacoes::FACULDADES){
		$unidade = $dados['TXT_UNIDADE'];
		$unidade = empty($unidade) ? "Não Informada" : $unidade;
		$curso = $dados['TXT_CURSO'];
		$curso = empty($curso) ? "Não Informado" : $curso;
		$data_prova = $dados['TXT_DATA_PROVA'];
		$data_prova = empty($data_prova) ? "Não Informada" : $data_prova;
		$bairro = $dados['TXT_BAIRRO'];
		$bairro = empty($bairro) ? "Não Informado" : $bairro;
		$cidade = $dados['TXT_CIDADE'];
		$cidade = empty($cidade) ? "Não Informada" : $cidade;

		if($dados["NU_TIPO"] == "1"){
			$tipo_captador = $sistema->indicacoes->funcionario_faculdade();
			$tipo_captador = $tipo_captador[intval($dados['NU_TIPO_FUNC'])];
		}
	}

	if(empty($dados['NU_CPF_IND'])) // Se o usuário não foi indicado por ninguém específico, consideramos que ele foi indicado pela Win7
		$indicador_por = "Agência Win7";
	else{
		$dado = $sistema->indicacoes->obter_usuario_por_cpf($dados['NU_CPF_IND']);
		$indicador_por = $dado['TXT_NOME'];
	}
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}

?>
<div class="modal-header">
	<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
	<span aria-hidden="true">&times;</span></button>
	<h4 class="modal-title"><?php echo $nome;?></h4>
</div>
<div class="modal-body">
	<div class="row">
		<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
			<label>Telefone:</label>
			<div class="input-group">
				<div class="input-group-addon"><i class="fa fa-phone"></i></div>
				<input type="text" class="form-control pull-right" id="telefone" name="telefone" alt="Telefone" value="<?php echo $telefone;?>" readonly/>
			</div>
		</div></div>
		<div class="col-xs-12 col-sm-6 col-md-6"><div class="form-group">
			<label>Email:</label>
			<div class="input-group">
				<div class="input-group-addon"><i class="fa fa-envelope"></i></div>
				<input type="text" class="form-control pull-right" id="email" name="email" alt="Email" value="<?php echo $email;?>" readonly/>
			</div>
		</div></div>
		<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
			<label>Status:</label>
			<div class="input-group">
				<div class="input-group-addon"><i class="fa fa-check-circle"></i></div>
				<select name="status" id="status" class="form-control pull-right" disabled>
					<?php $sistema->layout->select_status($status);?>
				</select>
			</div>
		</div></div>
		<?php if($sistema->indicacoes->tipo ==  Sistema_Indicacoes::FACULDADES) {?>
		<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
			<label>Unidade:</label>
			<div class="input-group">
				<div class="input-group-addon"><i class="fa fa-building"></i></div>
				<input type="text" class="form-control pull-right" id="unidade" name="unidade" value="<?php echo $unidade;?>" readonly/>
			</div>
		</div></div>
		<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
			<label>Cidade:</label>
			<div class="input-group">
				<div class="input-group-addon"><i class="fa fa-building"></i></div>
				<input type="text" class="form-control pull-right" id="cidade" name="cidade" value="<?php echo $cidade;?>" readonly/>
			</div>
		</div></div>
		<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
			<label>Bairro:</label>
			<div class="input-group">
				<div class="input-group-addon"><i class="fa fa-building"></i></div>
				<input type="text" class="form-control pull-right" id="bairro" name="bairro" value="<?php echo $bairro;?>" readonly/>
			</div>
		</div></div>
		<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
			<label>Curso:</label>
			<div class="input-group">
				<div class="input-group-addon"><i class="fa fa-graduation-cap"></i></div>
				<input type="text" class="form-control pull-right" id="curso" name="curso" value="<?php echo $curso;?>" readonly/>
			</div>
		</div></div>
		<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
			<label>Data da Prova:</label>
			<div class="input-group">
				<div class="input-group-addon"><i class="fa fa-calendar"></i></div>
				<input type="text" class="form-control pull-right" id="data-prova" name="data-prova" value="<?php echo $data_prova;?>" readonly/>
			</div>
		</div></div>
		<?php } ?>
	</div>
</div>
<div class="modal-footer">
	<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
</div>
<div class="overlay preloader">
	<i class="fa fa-refresh fa-spin"></i>
</div>
<script>
function atualizar_status(){
	var current = $('#status').val();
	if(current == "Fechado")
		$('#status').css('color','green');
	else if(current == "Perdeu" || current == "Não é Cliente")
		$('#status').css('color','red');
	else if(current == "Novo")
		$('#status').css('color','blue');
	else
		$('#status').css('color','#555');
}
$(document).ready(function(){
	atualizar_status();
	$('.dinheiro').mask('000.000.000.000.000,00', {reverse: true});
});
</script>