<?php
require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema();

if($sistema->indicacoes->permissao_inscricoes == "0"){
	$_SESSION['erro-cadastro-indicador'] = 3;
	$sistema->redirecionar('../indicado');
}

try{
	$usuario = preg_replace('#[^0-9]#','',strip_tags($_POST['usuario-indicado']));
	$nome = $_POST['nome-indicado'];
	$email = $_POST['email-indicado'];
	$telefone = $_POST['telefone-indicado'];

	if(strlen($telefone) < 8 || strlen($nome) <= 1){
		$_SESSION['erro-cadastro-indicado'] = 2;
		$sistema->redirecionar('../indicado');
	}

	if(strlen($usuario) == 11 & !Utilitarios::cpf_cnpj_valido($usuario)){
		$_SESSION['erro-cadastro-indicado'] = 2;
		$sistema->redirecionar('../indicado');
	}
	else if($sistema->indicacoes->permissao_cnpj_indicado == "0" & !Utilitarios::cpf_cnpj_valido($usuario)){
		$_SESSION['erro-cadastro-indicado'] = 2;
		$sistema->redirecionar('../indicado');
	}
	else if(strlen($usuario) == 14 & !Utilitarios::cpf_cnpj_valido($usuario)){
		$_SESSION['erro-cadastro-indicado'] = 2;
		$sistema->redirecionar('../indicado');
	}
	else if(strlen($usuario) != 11 & strlen($usuario) != 14){
		$_SESSION['erro-cadastro-indicado'] = 2;
		$sistema->redirecionar('../indicado');
	}

	if($sistema->indicacoes->proibir_cpf == "1"){
		$dados = $sistema->bd->executar("SELECT ID_LEAD FROM TBL_LEADS WHERE (TXT_CPF = :TXT_CPF OR TXT_CPF = :NU_CPF) AND ID_CLIENTE_FK = :ID",array(
			':NU_CPF' => $usuario,
			':TXT_CPF' => Mascara::mascara_cpf_cnpj($usuario),
			':ID' => $sistema->indicacoes->id
		), Banco_Dados::FETCH);
		if($sistema->bd->quantidade() > 0){
			$_SESSION['erro-cadastro-indicado'] = 0;
			$sistema->redirecionar('../indicado');
		}
	}

	$params = array();
	if($sistema->indicacoes->tipo == Sistema_Indicacoes::FACULDADES){
		$params['curso'] = $_POST['curso-indicado'];
		$params['unidade'] = $_POST['unidade-indicado'];
		$params['bairro'] = $_POST['bairro-indicado'];
		$params['data-prova'] = $_POST['data-prova-indicado'];
		$params['cidade'] = $_POST['cidade-indicado'];
	}

	$resultado = $sistema->indicacoes->registrar_indicado($usuario, $nome, $email, $telefone, $params);

	if($resultado != -1){
		$_SESSION['erro-cadastro-indicado'] = $resultado;
		$sistema->redirecionar('../indicado');
	}
	else{
		$_SESSION['cadastro-sucesso-indicado'] = 0;
		$sistema->redirecionar('../indicado');
	}
}
catch(Exception $e){
	$_SESSION['erro-cadastro-indicado'] = 1;
	$sistema->redirecionar('../indicado');
}

?>