<?php
require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema();

if($sistema->indicacoes->permissao_inscricoes == "0"){
	$_SESSION['erro-cadastro-indicador'] = 4;
	$sistema->redirecionar('../indicador');
}

if($sistema->indicacoes->ativar_termos == "1" & $_POST['aceitar-termos'] != "Sim"){
	$_SESSION['erro-cadastro-indicador'] = 3;
	$sistema->redirecionar('../indicador');
}

try{
	$usuario = preg_replace('#[^0-9]#','',strip_tags($_POST['usuario']));
	$nome = $_POST['nome'];
	$email = $_POST['email'];
	$telefone = $_POST['telefone'];
	$senha1 = $_POST['senha1'];
	$senha2 = $_POST['senha2'];

	if(!Utilitarios::email_valido($email) || strlen($telefone) < 8 || 
			strlen($nome) <= 1 || $senha1 != $senha2 || strlen($senha1) < 8 || strlen($senha1) > 64){
		$_SESSION['erro-cadastro-indicador'] = 2;
		$sistema->redirecionar('../indicador');
	}

	if(strlen($usuario) == 11 & !Utilitarios::cpf_cnpj_valido($usuario)){
		$_SESSION['erro-cadastro-indicador'] = 2;
		$sistema->redirecionar('../indicador');
	}
	else if($sistema->indicacoes->permissao_cnpj_indicador == "0" & !Utilitarios::cpf_cnpj_valido($usuario)){
		$_SESSION['erro-cadastro-indicador'] = 2;
		$sistema->redirecionar('../indicador');
	}
	else if(strlen($usuario) == 14 & !Utilitarios::cpf_cnpj_valido($usuario)){
		$_SESSION['erro-cadastro-indicador'] = 2;
		$sistema->redirecionar('../indicador');
	}
	else if(strlen($usuario) != 11 & strlen($usuario) != 14){
		$_SESSION['erro-cadastro-indicador'] = 2;
		$sistema->redirecionar('../indicador');
	}
	if($sistema->indicacoes->tipo == Sistema_Indicacoes::FACULDADES){
		$tipos_sistema = count($sistema->layout->tipos_funcionario_faculdade());
		if(!ctype_digit($_POST['tipofunc']) || intval($_POST['tipofunc']) >= $tipos_sistema || intval($_POST['tipofunc']) < 0){
			$_SESSION['erro-cadastro-indicador'] = 2;
			$sistema->redirecionar('../indicador');
		}
		$tipo_func = $_POST['tipofunc'];
	}

	$params = array("tipofunc" => $tipo_func);
	$resultado = $sistema->indicacoes->registrar_indicador($usuario, $nome, $email, $telefone, $senha1, $params);

	if($resultado != -1){
		$_SESSION['erro-cadastro-indicador'] = $resultado;
		$sistema->redirecionar('../indicador');
	}
	else{
		$_SESSION['cadastro-sucesso-indicador'] = 0;
		$sistema->redirecionar('../indicador');
	}
}
catch(Exception $e){
	$_SESSION['erro-cadastro-indicador'] = 1;
	$sistema->redirecionar('../indicador');
}

?>