var timeoutHandle;
function toast(message, type = 0) {
  var x = document.getElementById("toast");
  if (timeoutHandle) {
    clearTimeout(timeoutHandle);
    timeoutHandle = null;
  }
  x.innerHTML = message;
  if (type == 0) x.className = "show";
  else if (type == 1) x.className = "show green";
  else x.className = "show red";
  timeoutHandle = setTimeout(function () {
    x.className = x.className
      .replace("show", "")
      .replace("green", "")
      .replace("red", "");
  }, 3000);
}

function toast_sucesso(message) {
  toast(message, 1);
}

function toast_erro(message) {
  toast(message, 2);
}

/* Tema */
const toggleButton = document.getElementById("darkModeToggle");
const icon = document.getElementById("icon");

function setTheme(theme) {
  document.body.setAttribute("data-theme", theme);
  icon.textContent = theme === "dark" ? "☀️" : "🌙";
}

function detectSystemTheme() {
  const prefersDark = window.matchMedia("(prefers-color-scheme: dark)").matches;
  return prefersDark ? "dark" : "light";
}

toggleButton.addEventListener("click", () => {
  const currentTheme = document.body.getAttribute("data-theme");
  const newTheme = currentTheme === "dark" ? "light" : "dark";
  setTheme(newTheme);
  localStorage.setItem("theme", newTheme);
});

window.addEventListener("load", () => {
  const savedTheme = localStorage.getItem("theme");
  if (savedTheme) {
    setTheme(savedTheme);
  } else {
    const systemTheme = detectSystemTheme();
    setTheme(systemTheme);
  }
});
