$('.datepicker').datepicker({
	format: 'dd/mm/yyyy',
	endDate: '0d',
	autoclose: true,
	language: 'pt-BR'
});

$('.datepicker').mask('00/00/0000');

function carregar_dados(){
	$(document).ready(function() {
		var dados = jQuery('#formHome').serialize();
		jQuery.ajax({
			type: "POST",
			url: "action/atualizar_geral",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				var json = JSON.parse(data);
				$('#impressoes').html(json.impressoes);
				$('#cliques').html(json.cliques);
				$('#conversoes').html(json.conversoes);
				$('#taxaconversao').html(json.taxaconversao);
				$('#ctr').html(json.ctr);
				$('#posicaomedia').html(json.posicaomedia);
				$('#invalidos').html(json.invalidos);
				$('#custo').html(json.custo);
				$('#cpc').html(json.cpc);
				$('#forms').html(json.forms);
				$('#whatsapp').html(json.whatsapp);
				$('#ligacoes').html(json.ligacoes);
				$('#cpl').html(json.custolead);
			},
			beforeSend: function(){
				$('.info-box-number').html('<div class="preloader"><i class="fa fa-refresh fa-spin"></i></div>');
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao atualizar"); return;
			}
		});
	});
}

function atualizar(){
	var valor = $('#data').val();
	if(valor == "CUSTOM_DATE")
		$('.datadiv').removeClass("hide");
	else{
		$('.datadiv').addClass("hide");
		carregar_dados();
		salvarFiltro(valor,'','');
	}
}

pegarFiltro(function(filtro,data1,data2){
	$('#data').val(filtro);
	$('#datainicial').val(data1);
	$('#datafinal').val(data2);
	if(filtro == "CUSTOM_DATE")
		$('.datadiv').removeClass("hide");
	carregar_dados();
});

$('#data, #switch').change(function(){ atualizar(); });
$('#datapersonalizada').click(function(){
	salvarFiltro($('#data').val(),$('#datainicial').val(),$('#datafinal').val());
	carregar_dados();
});