$(".datepicker").datepicker({
  format: "dd/mm/yyyy",
  endDate: "0d",
  autoclose: true,
  language: "pt-BR",
});

$(".datepicker").mask("00/00/0000");

// Função para limpar e converter
function extrairNumero(valor) {
  if (typeof valor === "number") return valor;
  if (typeof valor !== "string") return 0;

  let limpo = valor.replace("R$", "").replace("%", "").trim();

  if (limpo.includes(",")) {
    // Ex: "2.302,55" --> ponto é milhar, vírgula é decimal
    limpo = limpo.replace(/\./g, ""); // remove milhar
    limpo = limpo.replace(",", "."); // vírgula vira ponto para parseFloat
  }

  // Se não tem vírgula, assume que ponto é decimal (não remove o ponto!)
  return parseFloat(limpo) || 0;
}

// Função para descobrir casas decimais
function detectarCasasDecimais(valorOriginal) {
  if (typeof valorOriginal !== "string") return 0;

  const valorLimpo = valorOriginal.replace("R$", "").replace("%", "").trim();

  if (valorLimpo.includes(",")) {
    const partes = valorLimpo.split(",");
    return partes[1]?.length || 0;
  }
  if (valorLimpo.includes(".")) {
    const partes = valorLimpo.split(".");
    return partes[1]?.length || 0;
  }
  return 0;
}

// Função para formatar de volta
function formatarOriginal(valorOriginal, numeroFinal) {
  if (`${valorOriginal}`.includes("R$")) {
    // Valor monetário: vírgula como separador decimal
    return "R$ " + numeroFinal.toFixed(2).replace(".", ",");
  }
  if (`${valorOriginal}`.includes("%")) {
    // Percentual: vírgula como separador decimal
    const casas = detectarCasasDecimais(valorOriginal);
    return numeroFinal.toFixed(casas).replace(".", ",") + "%";
  }
  if (`${valorOriginal}`.includes(",")) {
    // Número com vírgula (ex: "69,8")
    const casas = detectarCasasDecimais(valorOriginal);
    return numeroFinal.toFixed(casas).replace(".", ",");
  }
  if (`${valorOriginal}`.includes(".")) {
    // Número com ponto (ex: "7.9")
    const casas = detectarCasasDecimais(valorOriginal);
    return numeroFinal.toFixed(casas);
  }
  return Math.round(numeroFinal).toString();
}

function carregar_dados() {
  $(document).ready(function () {
    var dados = jQuery("#formHome").serialize();
    jQuery.ajax({
      type: "POST",
      url: "action/atualizar_geral",
      data: dados,
      success: function (data) {
        $(".preloader").css({ display: "none" });
        if (data == "-1") {
          window.location.href = "./";
          return;
        }
        if (data.substring(0, 2) == "-2") {
          toastr.clear();
          toastr.error(data.substring(2));
          return;
        }
        var json = JSON.parse(data);

        // if(json.topimpressions != null){
        //     $('#topimpressions').html(json.topimpressions+"%");
        //     $('#topimpressionsabsolute').html(json.topimpressionsabsolute+"%");
        // }

        // $("#impressoes").html(json.impressoes);
        // $("#cliques").html(json.cliques);
        // $("#taxaconversao").html(json.taxaconversao);
        // $("#ctr").html(json.ctr);
        // // $('#posicaomedia').html(json.posicaomedia);
        // $("#invalidos").html(json.invalidos);
        // $("#custo").html(json.custo);
        // $("#cpc").html(json.cpc);
        // $("#forms").html(json.forms);
        // $("#whatsapp").html(json.whatsapp);
        // $("#ligacoes").html(json.ligacoes);
        // $("#cpl").html(json.custolead);
        // $("#impressoeslead").html(json.impressoeslead);
        // $("#cliqueslead").html(json.cliqueslead);
        // $("#totalcontatos").html(json.totalcontatos);
        // $("#medialeads").html(json.medialeads);

        if (json.linkclique != undefined) {
          // $("#linkclique").html(json.linkclique);
          // $('#linkcliquebox').html(json.linkcliquedados);

          const linkdados = [];
          let contador = 0;
          let divData = '<div class="link-cliques-wraper">';
          for (let i = 0; i < json.linkcliquedados.length; i++) {
            Object.entries(json.linkcliquedados[i]).forEach(([key, value]) => {
              if (value === null) {
                return false;
              }
              if (key === "outro") {
                divData += `<div class="link-cliques-box" title="`;
                // divData += `<div class="link-clique-outros" title="`;
                value.map((item) => {
                  Object.entries(item).forEach(([key, value]) => {
                    contador += value;
                    divData += `${key}: ${value} \n`;
                    // divData += `<span class="link-title">${key}:</span><span class="link-qtty">${value}</span>`;
                  });
                });
                divData += `"><span class="link-title">${key}:</span><span class="link-qtty">${contador}</span></div>`;
              } else {
                linkdados[key] = value; // key - value
                divData += `<div class="link-cliques-box"><img src="../img/svglinkcliques/${
                  key === "outro" ? "circle" : key
                }.svg" width="20px" height="20px"></img><span class="link-title">${key}:</span><span class="link-qtty">${value}</span></div>`;
              }
            });

            contador = 0;
          }

          divData += "</div>";

          $("#linkcliquebox").html(divData);
        }

        // Monta os dados a serem animados
        const DADOS_FORMATAR = {
          impressoes: json.impressoes,
          cliques: json.cliques,
          taxaconversao: json.taxaconversao,
          ctr: json.ctr,
          invalidos: json.invalidos,
          custo: json.custo,
          cpc: json.cpc,
          forms: json.forms,
          whatsapp: json.whatsapp,
          ligacoes: json.ligacoes,
          cpl: json.custolead,
          impressoeslead: json.impressoeslead,
          cliqueslead: json.cliqueslead,
          totalcontatos: json.totalcontatos,
          medialeads: json.medialeads,
          linkclique: json?.linkclique ?? 0,
        };

        // Faz um for para animar os itens do objeto acima
        for (const key in DADOS_FORMATAR) {
          const el = document.getElementById(key);
          if (el) {
            const valorOriginal = DADOS_FORMATAR[key];
            const valorNumerico = extrairNumero(valorOriginal);
            const casasDecimais = detectarCasasDecimais(valorOriginal);

            const contador = new CountUp(
              key,
              0,
              valorNumerico,
              casasDecimais,
              2,
              {
                formattingFn: function (n) {
                  return formatarOriginal(valorOriginal, n);
                },
                decimal: ".", // Usamos ponto só internamente no CountUp
              }
            );

            if (!contador.error) {
              contador.start();
            } else {
              console.error(contador.error);
            }
          }
        }
      },
      beforeSend: function () {
        $(".info-box-number").html(
          '<div class="preloader"><i class="fa fa-refresh fa-spin"></i></div>'
        );
        $(".preloader").css({ display: "block" });
      },
      complete: function () {
        $(".preloader").css({ display: "none" });
      },
      error: function () {
        $(".preloader").css({ display: "none" });
        toastr.clear();
        toastr.error("Houve um erro ao atualizar");
        return;
      },
    });
  });
}

function atualizar() {
  var valor = $("#data").val();
  if (valor == "CUSTOM_DATE") $(".datadiv").removeClass("hide");
  else {
    $(".datadiv").addClass("hide");
    carregar_dados();
    salvarFiltro(valor, "", "");
  }
}

pegarFiltro(function (filtro, data1, data2) {
  $("#data").val(filtro);
  $("#datainicial").val(data1);
  $("#datafinal").val(data2);
  if (filtro == "CUSTOM_DATE") $(".datadiv").removeClass("hide");
  carregar_dados();
});

$("#data, #switch").change(function () {
  atualizar();
});
$("#datapersonalizada").click(function () {
  salvarFiltro(
    $("#data").val(),
    $("#datainicial").val(),
    $("#datafinal").val()
  );
  carregar_dados();
});
