Number.prototype.formatNumber = function(c, d, t){
	var n = this, 
	c = isNaN(c = Math.abs(c)) ? 2 : c, 
	d = d == undefined ? "." : d, 
	t = t == undefined ? "," : t, 
	s = n < 0 ? "-" : "", 
	i = String(parseInt(n = Math.abs(Number(n) || 0).toFixed(c))), 
	j = (j = i.length) > 3 ? j % 3 : 0;
	return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
 };

window.myLine = null;

$('.datepicker').datepicker({
	format: 'dd/mm/yyyy',
	endDate: '0d',
	autoclose: true,
	language: 'pt-BR'
});

$('.datepicker').mask('00/00/0000');

function carregar_dados(){
	$(document).ready(function() {
		var dados = jQuery('#formGrafico').serialize() + "&grafico=s";
		jQuery.ajax({
			type: "POST",
			url: "action/atualizar_ligacoes_geral",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				var json = JSON.parse(data);
				$(document).ready(function() {
					dadosGerais = json;
					desenharGrafico();
				});
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao atualizar"); return;
			}
		});
	});
}

function atualizar(){
	var valor = $('#data').val();
	if(valor == "CUSTOM_DATE")
		$('.datadiv').removeClass("hide");
	else{
		$('.datadiv').addClass("hide");
		carregar_dados();
		salvarFiltro(valor,'','');
	}
}

function formataData(data){
	var dataf = Date.parse(data);
	dataf.setHours(0);
	dataf.setMinutes(0);
	dataf.setSeconds(0);
	return dataf;
}

function getSunday(d) {
	d = new Date(d);
	var day = d.getDay(),
	diff = d.getDate() - day;
	return new Date(d.setDate(diff));
}

function geraGraficoDiariamente(){
	var e2 = document.getElementById("selectGrafico");
	var visualizacao = e2.options[e2.selectedIndex].value;

	var dias = {};
	var dataFinal = Date.parse(dadosGerais[0].data);

	for (var dateAtual = Date.parse(dadosGerais[0].data2); dateAtual <= dataFinal; dateAtual.setDate(dateAtual.getDate() + 1)) {
		var date = dateAtual.toString('yyyy-MM-dd');
		dias[date] = {};
		for(var i = 0; i < dadosGerais[0].ids.length; i++){
			var id = dadosGerais[0].ids[i];
			dias[date][id] = 0;
		}
	}
	
	var counter = 0;
	for (var i=1; i < dadosGerais.length; i++){
		var date = dadosGerais[i].data;
		var ramal = dadosGerais[i].fonte;
		if(!dias.hasOwnProperty(date)){
			dias[date] = {};
			for(var i2=0;i2 < dadosGerais[0].ids.length;i2++){
				var id = dadosGerais[0].ids[i2];
				dias[date][id] = 0;
			}
		}
		dias[date][ramal] += (visualizacao == "gastos") ? parseInt(dadosGerais[i].valor.substring(2).replace(/,/g , "")) : 1;
	}
	
	for (var property in dias) {
		labels.push(formataData(property));
		var diaRegistroDados = dias[property];

		for(var i=0;i < dadosGerais[0].ids.length;i++){
			var dado = diaRegistroDados[dadosGerais[0].ids[i]];
			if(visualizacao == "gastos"){ dado /= 100; }
			dadosGrafico[i].push(dado);
		}
	}
}

function geraGraficoSemanalmente(){
	var e2 = document.getElementById("selectGrafico");
	var visualizacao = e2.options[e2.selectedIndex].value;
	
	var dias = {};
	var dataFinal = Date.parse(dadosGerais[0].data);

	for (var dateAtual = Date.parse(dadosGerais[0].data2); dateAtual <= dataFinal; dateAtual.setDate(dateAtual.getDate() + 7)) {
		var date = getSunday(dateAtual).toString('yyyy-MM-dd');
		dias[date] = {};
		for(var i=0;i < dadosGerais[0].ids.length;i++){
			var id = dadosGerais[0].ids[i];
			dias[date][id] = 0;
		}
	}
	
	for (var i=1; i<dadosGerais.length; i++){
		var date = getSunday(dadosGerais[i].data).toString('yyyy-MM-dd');
		var ramal = dadosGerais[i].fonte;
		if(!dias.hasOwnProperty(date)){
			dias[date] = {};
			for(var i2=0;i2 < dadosGerais[0].ids.length;i2++){
				var id = dadosGerais[0].ids[i2];
				dias[date][id] = 0;
			}
		}
		dias[date][ramal] += (visualizacao == "gastos") ? parseInt(dadosGerais[i].valor.substring(2).replace(/,/g , "")) : 1;
	}
	
	for (var property in dias) {
		labels.push(formataData(property));
		var diaRegistroDados = dias[property];

		for(var i=0;i < dadosGerais[0].ids.length;i++){
			var dado = diaRegistroDados[dadosGerais[0].ids[i]];
			if(visualizacao == "gastos"){ dado /= 100; }
			dadosGrafico[i].push(dado);
		}
	}
}

function geraGraficoMensalmente(){
	var e2 = document.getElementById("selectGrafico");
	var visualizacao = e2.options[e2.selectedIndex].value;
	
	var dias = {};
	var dataFinal = Date.parse(dadosGerais[0].data);

	for (var dateAtual = Date.parse(dadosGerais[0].data2); dateAtual <= dataFinal; dateAtual.setMonth(dateAtual.getMonth() + 1)) {
		var date = new Date(dateAtual);
		date.setDate(1);
		date = date.toString('yyyy-MM-dd'); 
		dias[date] = {};
		for(var i=0;i < dadosGerais[0].ids.length;i++){
			var id = dadosGerais[0].ids[i];
			dias[date][id] = 0;
		}
	}
	
	for (var i=1; i<dadosGerais.length; i++){
		var ramal = dadosGerais[i].fonte;
		var date = Date.parse(dadosGerais[i].data);
		date.setDate(1);
		date = date.toString('yyyy-MM-dd');

		if(!dias.hasOwnProperty(date)){
			dias[date] = {};
			for(var i2=0;i2 < dadosGerais[0].ids.length;i2++){
				var id = dadosGerais[0].ids[i2];
				dias[date][id] = 0;
			}
		}
		dias[date][ramal] += (visualizacao == "gastos") ? parseInt(dadosGerais[i].valor.substring(2).replace(/,/g , "")) : 1;
	}
	
	for (var property in dias) {
		labels.push(formataData(property));
		var diaRegistroDados = dias[property];

		for(var i=0;i < dadosGerais[0].ids.length;i++){
			var dado = diaRegistroDados[dadosGerais[0].ids[i]];
			if(visualizacao == "gastos"){ dado /= 100; }
			dadosGrafico[i].push(dado);
		}
	}
}

function desenharGrafico(){
	var active = [true];
	dadosGrafico = [[]];
	labels = [];
	for(var i=1;i < dadosGerais[0].ids.length;i++){
		active[i] = false;
		dadosGrafico[i] = [];
	}

	if(window.myLine != null){
		cur_legend = window.myLine.legend.legendItems;
		for(var i=0;i < dadosGerais[0].ids.length;i++){
			active[i] = cur_legend[i] == null ? active[i] : !cur_legend[i]['hidden'];
		}
		window.myLine.destroy();
	}

	moment.locale('pt-BR');
	
	var timeFormat = 'DD/MM/YYYY';

	if(dadosGerais[0].ids.length > 0){
		var e = document.getElementById("periodo");
		var frequencia = e.options[e.selectedIndex].value;
		if(frequencia == "diariamente")
			geraGraficoDiariamente();
		else if(frequencia == "mensalmente")
			geraGraficoMensalmente();
		else
			geraGraficoSemanalmente();
	}

	var backgroundColors = ['rgba(60, 141, 188, 0.5)', 'rgba(0, 192, 239, 0.5)', 'rgba(0, 166, 90, 0.5)', 'rgba(243, 156, 18, 0.5)', 'rgba(221, 75, 57, 0.5)', 'rgba(96, 92, 168, 0.5)', 'rgba(0, 32, 63, 0.5)', 'rgba(17, 17, 17, 0.5)'];
	var borderColors = ['rgba(60, 141, 188, 1)', 'rgba(0, 192, 239, 1)', 'rgba(0, 166, 90, 1)', 'rgba(243, 156, 18, 1)', 'rgba(221, 75, 57, 1)', 'rgba(96, 92, 168, 1)', 'rgba(0, 32, 63, 1)', 'rgba(17, 17, 17, 1)'];
	var datasets = [];

	for(var i=0;i < dadosGerais[0].ids.length;i++){
		datasets.push({
			label: dadosGerais[0].ids[i],
			fill: false,
			data: dadosGrafico[i],
			backgroundColor: backgroundColors[i%8],
			borderColor: borderColors[i%8],
			tension: 0,
			hidden: !active[i]
		});
	}

	var e2 = document.getElementById("selectGrafico");
	var visualizacao = e2.options[e2.selectedIndex].value;

	var config = {
		type: 'LineWithLine',
		data: {
			labels: labels,
			datasets: datasets
		},
		options: {
			responsive: true,
			scaleShowVerticalLines: false,
			maintainAspectRatio: false,
			title: {
				text: "Gráfico Geral"
			},
			tooltips: {
				mode: 'index',
				intersect: false,
				titleFontFamily: "'Source Sans Pro',sans-serif",
				bodyFontFamily: "'Source Sans Pro',sans-serif",
				xPadding: 8,
				yPadding: 8,
				bodySpacing: 4,
				callbacks: {
					label: function(tooltipItem, data) {
						var datasetIndex = tooltipItem.datasetIndex;
						var dataset = data.datasets[datasetIndex];
						var content = dataset.data[tooltipItem.index];
						if(visualizacao == "gastos")
							return dataset.label + ": R$ " + content.formatNumber(2, ",", ".");
						else
							return dataset.label + ": " + content.toString() + " ligações";
	                }
				}
			},
			scales: {
				xAxes: [{
					type: "time",
					time: {
						parser: timeFormat,
						tooltipFormat: 'll',
						unit: "day"
					},
					scaleLabel: {
						display: true,
					},
					ticks: {
						autoSkip: false,
						maxRotation: 0,
						minRotation: 0,
						fontFamily: "'Source Sans Pro',sans-serif"
					},
					gridLines: {
						drawOnChartArea: false
					}
				}],
				yAxes: [{
					scaleLabel: {
						display: false
					},
					ticks: {
						fontFamily: "'Source Sans Pro',sans-serif"
					}
				}]
			},
			legend: {
				display: true,
			    labels: {
			        boxWidth: 16,
			        fontFamily: "'Source Sans Pro',sans-serif",
			        fontSize: 13,
			        padding: 10
			    }
			}
		}
	};
	$(document).ready(function() {
		var ctx = document.getElementById("canvas").getContext("2d");
		window.myLine = new Chart(ctx, config);
	});
}

// Hook into main event handler
Chart.defaults.LineWithLine = Chart.defaults.line;
Chart.controllers.LineWithLine = Chart.controllers.line.extend({
   draw: function(ease) {
      Chart.controllers.line.prototype.draw.call(this, ease);

      if (this.chart.tooltip._active && this.chart.tooltip._active.length) {
         var activePoint = this.chart.tooltip._active[0],
             ctx = this.chart.ctx,
             x = activePoint.tooltipPosition().x,
             topY = this.chart.scales['y-axis-0'].top,
             bottomY = this.chart.scales['y-axis-0'].bottom;

         // draw line
         ctx.save();
         ctx.beginPath();
         ctx.moveTo(x, topY);
         ctx.lineTo(x, bottomY);
         ctx.lineWidth = 2;
         ctx.setLineDash([5, 5]);
         ctx.strokeStyle = '#d2d6de';
         ctx.stroke();
         ctx.restore();
      }
   }
});

dadosGerais = {};
dadosGerais[0] = {};
dadosGerais[0]['ids'] = [];
desenharGrafico();

pegarFiltro(function(filtro,data1,data2){
	$('#data').val(filtro);
	$('#datainicial').val(data1);
	$('#datafinal').val(data2);
	if(filtro == "CUSTOM_DATE")
		$('.datadiv').removeClass("hide");
	carregar_dados();
});
 
$('#periodo, #selectGrafico').change(function(){ desenharGrafico(); });
$('#data, #switch').change(function(){ atualizar(); });
$('#datapersonalizada').click(function(){
	salvarFiltro($('#data').val(),$('#datainicial').val(),$('#datafinal').val());
	carregar_dados();
});