
$('.datepicker').datepicker({
    format: 'dd/mm/yyyy',
    endDate: '0d',
    autoclose: true,
    language: 'pt-BR'
});

$('.datepicker').mask('00/00/0000');

$.fn.dataTable.moment( 'DD/MM/YYYY HH:mm:ss');
$('#tabelaLigacoes').html('<table id="tbLigacoes" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>');
$('#tbLigacoes').dataTable({
    "data": [],
    "order": [[ 0, 'desc' ]],
    "columns": [{"title": "Origem"}, {"title": "Destino Final"}, {"title": "Fonte"}, {"title": "Dia da Ligação"}, {"title": "Custo"}, {"title": "Duração Final"}, {"title": "Opções", "className": "table-buttons"}, {"title": "Resultado"}, {"title": "Duração Total"}, {"title": "Tempo de Espera"}],
    "lengthMenu": [[25, 50, 100, -1], ["25","50","100", "todas"]],
    "columnDefs": [{"targets": 6, "orderable": false}],
    responsive: true
});

function modalNovoContato(telefone, id, dataLigacao, fonte = ""){
    if($('.dtr-bs-modal').hasClass("in")){
        $('.dtr-bs-modal').one('hidden.bs.modal', function () {
            modalNovoContato_2(telefone, id, dataLigacao, fonte);
        });
        $('.dtr-bs-modal').modal('hide');
    }
    else{
        modalNovoContato_2(telefone, id, dataLigacao, fonte);
    }
}

function modalNovoContato_2(telefone, id, dataLigacao, fonte){
    $(document).ready(function(){
        jQuery.ajax({
            type: "POST",
            url: "action/abrir_modal_nova_ligacao",
            data: {'telefone' : telefone, 'id' : id, 'dataligacao' : dataLigacao, 'fonte' : fonte},
            success: function(data){
                $('.preloader').css({display:"none"});
                if(data == '-1') {window.location.href = "./"; return;}
                if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
                $('#modal-sistema-conteudo').html(data);
                $('#modal-sistema').modal();
            },
            beforeSend: function(){
                $('.preloader').css({display:"block"});
            },
            complete: function(){
                $('.preloader').css({display:"none"});
            },
            error: function(){
                $('.preloader').css({display:"none"});
                toastr.clear(); toastr.error("Houve um erro ao abrir modal."); return;
            }
        });
    });
}

function visualizarLinha(id){
    var table = $('#tbLigacoes').DataTable();
    var row = table.row(".id"+id);
    var tr = $(row.node());
    if ( row.child.isShown() ) {
        row.child.hide();
        tr.removeClass('shown');
    }
    else {
        var subligacoes = row.data()[13];
        var rowData = "\
    	<div class='row' style='white-space: normal;'>\
			<div class='col-xs-12'>\
				<b>Mais ligações da mesma origem: </b>\
				<br>\
			</div>\
    	";
        for(var c = subligacoes.length - 1;c >= 0; c--){
            var ligacaoAtual = subligacoes[c];
            var date = Date.parse(ligacaoAtual.data).toString('dd/MM/yyyy HH:mm:ss');
            rowData += "\
    		<div class='col-xs-12'>\
				<b>→</b> <b>Dia da Ligação:</b> "+date+" | <b>Custo</b>: "+ligacaoAtual.valor+" (<a href= 'javascript:void(0);' onclick='modalVerLigacao(\""+ligacaoAtual.id+"\")' class='text-blue' title='Clique para ver os detalhes desta ligação.'>Ver Detalhes</a>)\
			</div>";
        }
        rowData += "</div>"
        row.child(rowData).show();
        tr.addClass('shown');
    }
}

function mudar_icone_adicionado(telefone, id){
    var table = $('#tbLigacoes').DataTable();
    var tableRow = table.row(".id"+id);
    var rowData = tableRow.data();
    if (rowData == null){
        return;
    }

    const telefoneFormatado = telefone.replace(/[`~!@#$%^&*()_ |+\-=?;:'",.<>\{\}\[\]\\\/]/gi, '');
    const telefoneNormal = telefone;

    const urlTelefoneFormatado = `<? echo $TXT_URL_BTN_CONTATO; ?>`.replace('#TELEFONE#',telefoneFormatado);
    const urlTelefoneNormal = `<? echo $TXT_URL_BTN_CONTATO; ?>`.replace('#TELEFONE#',telefoneNormal);

    $(tableRow.node()).css("background-color", "#bafdd7");
    rowData[7] = `<div class='btn-group'><a href= 'javascript:void(0);' onclick='modalVerContato(\""+telefone+"\", \""+id+"\")' class='btn btn-default text-orange' title='Clique editar o contato.'><i class='fa fa-edit'></i></a><a href= 'javascript:void(0);' onclick='modalVerLigacao(\""+id+"\")' class='btn btn-default text-blue' title='Clique para ver os detalhes desta ligação.'><i class='fa fa-list'></i></a>${telefone.length > 3 ? '<a href="tel:0'+telefone.replace(/[`~!@#$%^&*()_ |+\-=?;:'",.<>\{\}\[\]\\\/]/gi, '')+'" class="btn btn-default text-blue" title="Clique para ligar"><i class="fa fa-phone"></i></a>' : ''}${
        telefone.indexOf("(") != -1
            ? '<a href="'+urlTelefoneFormatado+'" class="btn btn-default text-green" target="_blank" title="Enviar mensagem para o cliente"><i class="fa fa-whatsapp"></i></a>'
            : '<a href="'+urlTelefoneNormal+'" class="btn btn-default text-green" target="_blank" title="Enviar mensagem para o cliente"><i class="fa fa-whatsapp"></i></a>' }</div>`;
    tableRow.data(rowData);
    tableRow.invalidate();
    table.draw(false);
}

function modalVerLigacao(id){
    if($('.dtr-bs-modal').hasClass("in")){
        $('.dtr-bs-modal').one('hidden.bs.modal', function () {
            modalVerLigacao_2(id);
        });
        $('.dtr-bs-modal').modal('hide');
    }
    else{
        modalVerLigacao_2(id);
    }
}

function modalVerLigacao_2(id){
    $(document).ready(function(){
        jQuery.ajax({
            type: "POST",
            url: "action/abrir_modal_ligacao",
            data: {'id' : id},
            success: function(data){
                $('.preloader').css({display:"none"});
                if(data == '-1') {window.location.href = "./"; return;}
                if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
                $('#modal-sistema-conteudo').html(data);
                $('#modal-sistema').modal();
            },
            beforeSend: function(){
                $('.preloader').css({display:"block"});
            },
            complete: function(){
                $('.preloader').css({display:"none"});
            },
            error: function(){
                $('.preloader').css({display:"none"});
                toastr.clear(); toastr.error("Houve um erro ao abrir modal."); return;
            }
        });
    });
}

function modalVerContato(telefone, id){
    if($('.dtr-bs-modal').hasClass("in")){
        $('.dtr-bs-modal').one('hidden.bs.modal', function () {
            modalVerContato_2(telefone, id);
        });
        $('.dtr-bs-modal').modal('hide');
    }
    else{
        modalVerContato_2(telefone, id);
    }
}

function modalVerContato_2(telefone, id){
    $(document).ready(function(){
        jQuery.ajax({
            type: "POST",
            url: "action/abrir_modal_ligacao_contato",
            data: {'telefone' : telefone, 'id' : id},
            success: function(data){
                $('.preloader').css({display:"none"});
                if(data == '-1') {window.location.href = "./"; return;}
                if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
                $('#modal-sistema-conteudo').html(data);
                $('#modal-sistema').modal();
            },
            beforeSend: function(){
                $('.preloader').css({display:"block"});
            },
            complete: function(){
                $('.preloader').css({display:"none"});
            },
            error: function(){
                $('.preloader').css({display:"none"});
                toastr.clear(); toastr.error("Houve um erro ao abrir modal."); return;
            }
        });
    });
}

function carregar_dados(){
    $(document).ready(function() {
        var dados = jQuery('#formLigacoes').serialize();
        jQuery.ajax({
            type: "POST",
            url: "action/atualizar_ligacoes",
            data: dados,
            success: function(data){
                $('.preloader').css({display:"none"});
                if(data == '-1') {window.location.href = "./"; return;}
                if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
                var json = JSON.parse(data);
                var table_data = [];

                for (var i=1; i < json.length; i++){
                    var date = Date.parse(json[i].data).toString('dd/MM/yyyy HH:mm:ss');
                    var editar = "";
                    if(json[i].adicionado == 1){
                        editar = "<div class='btn-group'><a href= 'javascript:void(0);' onclick='modalVerContato(\""+json[i].origem+"\", \""+json[i].id+"\")' class='btn btn-default text-orange' title='Clique editar o contato.'><i class='fa fa-edit'></i></a>";
                    }
                    else{
                        if(json[i].valido == 1){
                            editar = "<div class='btn-group'><a href= 'javascript:void(0);' onclick='modalNovoContato(\""+json[i].origem+"\", \""+json[i].id+"\", \""+json[i].data+"\", \""+json[i].fonte+"\")' class='btn btn-default text-green' title='Clique para adicionar como um contato.'><i class='fa fa-plus'></i></a>";
                        }
                        else{
                            editar = "<div class='btn-group'>";
                        }
                    }
                    editar += "<a href= 'javascript:void(0);' onclick='modalVerLigacao(\""+json[i].id+"\")' class='btn btn-default text-blue' title='Clique para ver os detalhes desta ligação.'><i class='fa fa-list'></i></a>";

                    if(json[i].origem.length > 3){
                        editar += '<a href="tel:0'+json[i].origem.replace(/[`~!@#$%^&*()_ |+\-=?;:'",.<>\{\}\[\]\\\/]/gi, '')+'" class="btn btn-default text-blue" title="Clique para ligar"><i class="fa fa-phone"></i></a>';
                    }

                    const telefoneFormatado = json[i].origem.replace(/[`~!@#$%^&*()_ |+\-=?;:'",.<>\{\}\[\]\\\/]/gi, '');
                    const telefoneNormal = json[i].origem;

                    const urlTelefoneFormatado = `<? echo $TXT_URL_BTN_CONTATO; ?>`.replace('#TELEFONE#',telefoneFormatado);
                    const urlTelefoneNormal = `<? echo $TXT_URL_BTN_CONTATO; ?>`.replace('#TELEFONE#',telefoneNormal);

                    if(json[i].origem.indexOf("(") != -1){
                        editar += '<a href="'+urlTelefoneFormatado+'" class="btn btn-default text-light-gold" target="_blank" title="Enviar mensagem para esse número"><i class="fa fa-whatsapp"></i></a>';
                    }else{
                        editar += '<a href="'+urlTelefoneNormal+'" class="btn btn-default text-light-gold" target="_blank" title="Enviar mensagem para esse número"><i class="fa fa-whatsapp"></i></a>';
                    }

                    editar += '</div>';
                    var botao = "";
                    if(json[i].subligacoes != null){
                        botao = json[i].subligacoes.length > 0 ? "<a class='open-details' href='javascript:void(0)' onclick='visualizarLinha(\""+json[i].id+"\")'>↪</a>" : ""
                    }
                    else{
                        botao = "";
                    }

                    table_data[i-1] = ["", botao + json[i].origem, json[i].destino, json[i].fonte, date, json[i].valor, json[i].duracaofinal, editar, json[i].atendida, json[i].duracao, json[i].espera, json[i].adicionado,json[i].id,json[i].subligacoes];
                }

                $('#totalligacoes').html(json[0].totalligacoes);
                $('#totalgasto').html(json[0].totalgasto);

                $(document).ready(function() {
                    const colunas = [{},{"title": "Origem"}, {"title": "Destino Final"},{"title": "Fonte"}, {"title": "Dia da Ligação"}, {"title": "Custo"}, {"title": "Duração Final"}, {"title": "Opções", "className": "table-buttons"}, {"title": "Resultado"}, {"title": "Duração Total"}, {"title": "Tempo de Espera"}];
                    $.fn.dataTable.moment( 'DD/MM/YYYY HH:mm:ss');
                    $('#tabelaLigacoes').html('<table id="tbLigacoes" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>');
                    if(json.length >= 2){
                        $("#tbLigacoes").append(
                            $('<tfoot style="display: table-header-group;" />').append(`<tr>${colunas.map((i) => "<th></th>").join("")}</tr>`)
                        );
                        $('#tbLigacoes tfoot tr th').each(function (index) {
                            if(index !== 7){// numero da coluna das opções
                                $(this).html('<input type="text" style="width: 100%" class="form-control" placeholder="" />');
                            }
                        });
                    }
                    $('#tbLigacoes').DataTable({
                        "data": table_data,
                        "order": [[ 4, 'desc' ]],
                        "columns": colunas,
                        "lengthMenu": [[25, 50, 100, -1], ["25","50","100", "todas"]],
                        "columnDefs": [{"targets": 7, "orderable": false},{"targets": 5, "type": "numeric-comma-real"},{className: 'control', orderable: false, targets: 0, width: "5%"}],
                        responsive: {
                            details: {
                                type: 'column',
                                display: $.fn.dataTable.Responsive.display.modal( {
                                    header: function ( row ) {
                                        return '<span style="margin-right: 10px"><b>Dados da Ligação</b></span>';
                                    }
                                } ),
                                renderer: function ( api, rowIdx, columns ) {
                                    text = "";
                                    text += columns[6].data + "<br>";
                                    for(i = 0;i < columns.length;i++){
                                        column = columns[i];
                                        if(i == 6) { continue; }
                                        if(i > 0) text += "<br>";
                                        text += "<b>" + column.title + ": </b>" + column.data;
                                    }
                                    return text;
                                }
                            }
                        },
                        initComplete: function () {
                            // Apply the search
                            this.api()
                                .columns([3,8])
                                .every(function () {
                                    var column = this;
                                    var select = $('<select class="form-control"><option value=""></option></select>')
                                        .appendTo($(column.footer()).empty())
                                        .on('change', function () {
                                            var val = $.fn.dataTable.util.escapeRegex($(this).val());
                                            column.search(val ? '^' + val + '$' : '', true, false).draw();
                                        });
                                    column
                                        .data()
                                        .unique()
                                        .sort()
                                        .each(function (d, j) {
                                            select.append('<option value="' + d + '">' + d + '</option>');
                                        });
                                    var that = this;
                                    $('input', this.footer()).on('keyup change clear', function () {
                                        if (that.search() !== this.value) {
                                            that.search(this.value).draw();
                                        }
                                    });

                                });
                            this.api()
                                .columns([0,1,2,4,5,6,7,9,10])
                                .every(function () {
                                    var that = this;
                                    $('input', this.footer()).on('keyup change clear', function () {
                                        if (that.search() !== this.value) {
                                            that.search(this.value).draw();
                                        }
                                    });
                                });
                        },
                        "deferRender": true,
                        "createdRow": function ( row, data, index ) {
                            $(row).addClass("id"+data[12]);
                            var current = $('td', row).eq(8);
                            $('td', row).eq(0).css("background-color", "white");
                            if(data[11] == 1){
                                $(row).css("background-color", "#bafdd7");
                            }
                            if(current.text() == "Atendida"){
                                current.css('color','green');
                            }
                            else{
                                current.css('color','red');
                            }
                        }
                    });
                });
            },
            beforeSend: function(){
                $('.info-box-number').html('<div class="preloader"><i class="fa fa-refresh fa-spin"></i></div>');
                $('.preloader').css({display:"block"});
            },
            complete: function(){
                $('.preloader').css({display:"none"});
            },
            error: function(){
                $('.preloader').css({display:"none"});
                toastr.clear(); toastr.error("Houve um erro ao atualizar"); return;
            }
        });
    });
}

function fechar_modal(){
    $('#modal-sistema').modal('hide');
}

function atualizar(){
    var valor = $('#data').val();
    if(valor == "CUSTOM_DATE")
        $('.datadiv').removeClass("hide");
    else{
        $('.datadiv').addClass("hide");
        carregar_dados();
        salvarFiltro(valor,'','');
    }
}

pegarFiltro(function(filtro,data1,data2){
    $('#data').val(filtro);
    $('#datainicial').val(data1);
    $('#datafinal').val(data2);
    if(filtro == "CUSTOM_DATE")
        $('.datadiv').removeClass("hide");
    carregar_dados();
});

$('#data, #switch').change(function(){ atualizar(); });
$('#datapersonalizada').click(function(){
    salvarFiltro($('#data').val(),$('#datainicial').val(),$('#datafinal').val());
    carregar_dados();
});

$("#modal-sistema").on("hidden.bs.modal", function () {
    $('#modal-sistema-conteudo').html(" ");
});