<?php
require_once(__DIR__ . "/classes/Sistema.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-MFFM5J3');</script>
<!-- End Google Tag Manager -->
<script>
    (function() {
      try {
        var theme = localStorage.getItem('theme');
        if (!theme) {
          theme = window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light';
        }
        document.documentElement.setAttribute('data-theme', theme);
      } catch (e) {}
    })();
  </script>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<title>Mudar Senha - Sistema Win7</title>
	<link rel="icon" type="image/ico" href="favicon.png" />
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/datatables.min.css"/>
	<link rel="stylesheet" href="css/bootstrap-xl-xxl.css">
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/ionicons.min.css">
	<link rel="stylesheet" href="css/AdminLTE.min.css">
	<link rel="stylesheet" href="css/skin-blue.min.css">
	<link rel="stylesheet" href="css/custom2.0.1.css">
	<link rel="stylesheet" href="css/toastr.min.css">

	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->criar_meta_tags();?>
</head>

<body data-theme="dark" class="hold-transition skin-blue sidebar-mini lte-fixed <?php if($sistema->usuario->sidebar) {echo "sidebar-collapse"; }?>">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MFFM5J3"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<div class="modal fade" id="modal-sistema"><div class="modal-dialog modal-lg"><div class="modal-content" id="modal-sistema-conteudo"></div></div></div>
<div class="wrapper">
	<?php $sistema->layout->exibir_cabecalho('mudar-senha');?>

	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
			<span class="tipopesquisa">Mudar Senha</span>
			<small class="tipopesquisa2">Mude sua senha de acesso ao sistema</small>
			</h1>
			<ol class="breadcrumb">
				<li><a href="mudar-senha"><i class="fa fa-lock"></i> Mudar Senha</a></li>
			</ol>
		</section>

		<section class="content container-fluid">
			<form action="" method="POST" id="formSenha">
			<div class="row">
				<div class="col-xs-12">
          			<div class="box">
          				<div class="box-header with-border">
          					<span class="text-muted">Preencha os campos abaixo com sua senha atual e sua nova senha, que deve conter mais de 5 dígitos:</span>
          				</div>
          				<div class="box-body">
          					<div class="row">
          						<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3 col-xl-2">
          							<div class="form-group">
										<label>Senha Atual:</label>
										<div class="input-group">
											<div class="input-group-addon">
												<i class="fa fa-lock"></i>
											</div>
											<input type="password" class="form-control pull-right" name="senha" id="senha">
										</div>
									</div>
								</div>
								<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3 col-xl-2">
          							<div class="form-group">
										<label>Nova Senha:</label>
										<div class="input-group">
											<div class="input-group-addon">
												<i class="fa fa-lock"></i>
											</div>
											<input type="password" class="form-control pull-right" name="senha1" id="senha1">
										</div>
									</div>
								</div>
								<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3 col-xl-2">
          							<div class="form-group">
										<label>Confirmar Senha:</label>
										<div class="input-group">
											<div class="input-group-addon">
												<i class="fa fa-lock"></i>
											</div>
											<input type="password" class="form-control pull-right" name="senha2" id="senha2">
										</div>
									</div>
								</div>
          					</div>
          				</div>
          				<div class="box-footer">
  							<button type="submit" class="btn btn-primary text-center" >Salvar Senha</button>
  						</div>
  						<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
          		</div>
          	</div>
          	</form>
		</section>
	</div>
	<?php $sistema->layout->exibir_rodape();?>
</div>

<script src="js/jquery.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/adminlte.min.js"></script>
<script src="js/toastr.min.js"></script>
<script src="js/senha2.0.0.js"></script>

</body>
</html>