<?php
require_once(__DIR__ . "/classes/Sistema.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_indicacoes == Usuario::PERM_NENHUMA) $sistema->redirecionar("home");
if($sistema->indicacoes->usa_pontos != "1") $sistema->redirecionar("home");
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-MFFM5J3');</script>
<!-- End Google Tag Manager -->
<script>
    (function() {
      try {
        var theme = localStorage.getItem('theme');
        if (!theme) {
          theme = window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light';
        }
        document.documentElement.setAttribute('data-theme', theme);
      } catch (e) {}
    })();
  </script>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<title>Prêmios - Sistema Win7</title>
	<link rel="icon" type="image/ico" href="favicon.png" />
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/datatables.min.css"/>
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap-xl-xxl.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/font-awesome.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/ionicons.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/AdminLTE.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/skin-blue.min.css">
	<link rel="stylesheet" href="css/custom2.0.1.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/toastr.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap-datepicker.min.css">

	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->criar_meta_tags();?>
</head>

<body data-theme="dark" class="hold-transition skin-blue sidebar-mini lte-fixed <?php if($sistema->usuario->sidebar) {echo "sidebar-collapse"; }?>">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MFFM5J3"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<div class="modal fade" id="modal-confirmacao"><div class="modal-dialog"><div class="modal-content" id="modal-confirmacao-conteudo"></div></div></div>
<div class="modal fade" id="modal-sistema"><div class="modal-dialog modal-lg"><div class="modal-content" id="modal-sistema-conteudo"></div></div></div>
<div class="wrapper">
	<?php $sistema->layout->exibir_cabecalho('premios');?>

	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
			<span class="tipopesquisa">Prêmios</span>
			<small class="tipopesquisa2">Visualize os prêmios que podem ser escolhidos pelos indicadores</small>
			</h1>
			<ol class="breadcrumb">
				<li><a href="javascript:void(0)"><i class="fa green-text fa-smile-o"></i> Indicações</a></li>
				<li><a href="premios">Prêmios</a></li>
			</ol>
		</section>

		<section class="content container-fluid">
			<div class="row">
				<div class="col-xs-12">
					<div class="box">
						<?php if($sistema->usuario->permissao_indicacoes == Usuario::PERM_ESCRITA){ ?>
						<div class="box-header with-border">
							<a href="javascript:void(0);" onclick="modalNovoPremio();" class="btn btn-primary" >Adicionar Prêmio</a>
          				</div>
          				<?php } ?>
          				<div class="box-body">
          					<div id="tabelaPremios" class="tabela">
          						<table id="tbPremios" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>
          					</div>
          				</div>
          				<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
				</div>
			</div>
		</section>
	</div>
	<?php $sistema->layout->exibir_rodape();?>
</div>

<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/jquery.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/datatables.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/adminlte.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap-datepicker.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap-datepicker.pt-BR.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/toastr.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/jquery.mask.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/moment.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/datetime-moment.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/date.js"></script>
<script src="js/indicacoes-premios-2-0-1"></script>

</body>
</html>