<?php

namespace Win7\Application\Common;


/**
 * @namespace Win7\Application\Common
 * @author Thiago Daher
 */
final class StringUtils
{

    /**
     * Copiado do código do sistema win7 original, filtra o número 3cx para visualização do usuário.
     *
     * @param $numero
     * @param $display
     * @return string
     */
    public static function filter3cxNumber($numero, $display = null): string
    {
        // Removemos os dois pontos e o que houve depois, caso tenha
        $posicaoDoisPontos = strpos($numero, ":");
        if (strpos($numero, ":") !== false) {
            $numero = substr($numero, 0, $posicaoDoisPontos);
        }

        // Preparamos, nos seguintes IFs, o número de origem para exibição
        if (substr($numero, 0, 4) === "Ext.") { // O número de origem é um ramal?
            // Se o nome display foi configurado, refazemos a filtragem
            if ($display != null) {
                // Remove o número do ramal que está entre parênteses
                $numero             = trim(preg_replace("/\([^)]+\)/", "", $display)); // Remove número do ramal entre parênteses
                $resultadoFiltragem = self::filter3cxNumber($numero);
                $numero             = $resultadoFiltragem;
            }
        } elseif (is_numeric($numero)) { // O número de origem não é um ramal?
            $size = strlen($numero); // obtém o tamanho do número
            if ($size == 11 & $numero[0] == "0") { // Se tem tamanho 11 e começa com 0, é um número de tamanho 8 com DDD. Ex: 06199123432
                $numero = self::applyPhoneMask(substr($numero, 1, $size - 1)); // formata o número para exibição
            } elseif ($size == 12 & $numero[0] == "0") { // Se tem tamanho 12 e começa com 0, é um número de tamanho 9 com DDD. Ex: 061999123432
                $numero = self::applyPhoneMask(substr($numero, 1, $size - 1)); // formata o número para exibição
            } elseif (($size == 12 || $size == 13) & substr($numero, 0, 2) == "55") { // é um número no formato global. Ex: 5561993213567
                $numero = self::applyPhoneMask(substr($numero, 2, $size - 2)); // formata o número para exibição
            } elseif ($size == 8 || $size == 9) { // Se tem tamanho 8 ou 9, é o número sem DDD
                $numero = self::applyPhoneMask($numero); // formata o número para exibição
            } elseif ($size == 10 || $size == 11) {
                $numero = self::applyPhoneMask($numero); // formata o número para exibição
            } elseif ($size >= 14) {
                if (substr($numero, 0, 4) == "0055") {
                    $numero = substr($numero, 4, $size - 4);

                    if (substr($numero, 0, 2) == "00") {
                        $numero = substr($numero, 2, $size - 2);
                    }
                    $numero = self::applyPhoneMask($numero);
                }
            }
        }

        return $numero;
    }

    /**
     * Aplica uma máscara de telefone. Copiado do sistema win7 original.
     *
     * @param string $val
     * @return string
     */
    public static function applyPhoneMask(string $val): string
    {
        $size = strlen($val);

        if ($size == 8) {
            return self::applyMask($val, "####-####");
        } elseif ($size == 9) {
            return self::applyMask($val, "#####-####");
        } elseif ($size == 10) {
            return self::applyMask($val, "(##) ####-####");
        } elseif ($size == 11) {
            return self::applyMask($val, "(##) #####-####");
        }

        return $val;
    }

    /**
     * Aplica uma máscara. Copiado do sistema win7 original.
     *
     * @param $val
     * @param $mask
     * @return string
     */
    public static function applyMask($val, $mask): string
    {
        $maskared = '';
        $k        = 0;

        for ($i = 0; $i <= strlen($mask) - 1; $i++) {
            if ($mask[$i] == '#') {
                if (isset($val[$k])) {
                    $maskared .= $val[$k++];
                }
            } else {
                if (isset($mask[$i])) {
                    $maskared .= $mask[$i];
                }
            }
        }

        return $maskared;
    }

    /**
     * @param float $value
     * @return string
     */
    public static function formatMoney(float $value): string
    {
        return 'R$ ' . number_format($value, 2, ',', '.');
    }

    /**
     * @param int $seconds
     * @return string
     */
    public static function convertDurationSeconds(int $seconds): string
    {
        $hours   = floor($seconds / 3600);
        $minutes = floor(($seconds / 60) % 60);
        $seconds = $seconds % 60;

        return sprintf('%02d:%02d:%02d', $hours, $minutes, $seconds);
    }
}