<?php

namespace Win7\Application\Factory;

use Illuminate\Database\Capsule\Manager;
use Illuminate\Database\Connection;
use Illuminate\Database\ConnectionInterface;
use Psr\Container\ContainerInterface;
use Win7\App;

/**
 * @namespace Win7\Application\Factory
 * @author Thiago Daher
 */
class DbConnectionFactory implements FactoryInterface
{

    /**
     * @return void
     * @throws \DI\DependencyException
     * @throws \DI\NotFoundException
     */
    public function closeAppConnections()
    {
        App::getContainer()->get(ConnectionInterface::class)->disconnect();
    }

    /**
     * @param \Psr\Container\ContainerInterface $container
     * @return \Illuminate\Database\Connection
     */
    public static function create(ContainerInterface $container): Connection
    {
        $instance = new DbConnectionFactory();
        register_shutdown_function([$instance, 'closeAppConnections']);

        return Manager::connection('default');
    }
}
