<?php

namespace Win7\Application\Factory;

use Psr\Container\ContainerInterface;
use Slim\Views\Twig;
use Win7\App;
use Win7\Config;

/**
 * @package App\Factory
 * @author Thiago Daher
 */
class TwigFactory implements FactoryInterface
{

    /**
     * @param \Psr\Container\ContainerInterface $container
     * @return \Slim\Views\Twig
     * @throws \Psr\Container\ContainerExceptionInterface
     * @throws \Psr\Container\NotFoundExceptionInterface
     * @throws \Twig\Error\LoaderError
     */
    public static function create(ContainerInterface $container): Twig
    {
        $config = $container->get(Config::class)->get('twig');
        $twig   = Twig::create($config['templates'], $config['settings']);
        $twig->getEnvironment()->addGlobal('app_version', App::VERSION);

        return $twig;
    }
}