<?php

namespace Win7\Application\Manager\DataTable;

/**
 * @author Thiago Daher
 */
class Column
{

    /**
     * @var string
     */
    private string $name = '';

    /**
     * @var string
     */
    private string $order = '';

    /**
     * @var string
     */
    private string $search = '';

    /**
     * @var int
     */
    private int $position = 0;

    /**
     * @var int
     */
    private int $searchType = ColumnDefinition::SEARCH_LIKE;

    /**
     * @var \Win7\Application\Manager\DataTable\ColumnDefinition
     */
    private ColumnDefinition $definition;

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getOrder(): string
    {
        return $this->order;
    }

    /**
     * @param string $order
     */
    public function setOrder(string $order): void
    {
        $this->order = $order;
    }

    /**
     * @return string
     */
    public function getSearch(): string
    {
        return $this->search;
    }

    /**
     * @param string $search
     */
    public function setSearch(string $search): void
    {
        $this->search = $search;
    }

    /**
     * @return int
     */
    public function getSearchType(): int
    {
        return $this->searchType;
    }

    /**
     * @param int $searchType
     */
    public function setSearchType(int $searchType): void
    {
        $this->searchType = $searchType;
    }

    /**
     * @return int
     */
    public function getPosition(): int
    {
        return $this->position;
    }

    /**
     * @param int $position
     */
    public function setPosition(int $position): void
    {
        $this->position = $position;
    }

    /**
     * @return \Win7\Application\Manager\DataTable\ColumnDefinition
     */
    public function getDefinition(): ColumnDefinition
    {
        return $this->definition;
    }

    /**
     * @param \Win7\Application\Manager\DataTable\ColumnDefinition $definition
     * @return void
     */
    public function setDefinition(ColumnDefinition $definition): void
    {
        $this->definition = $definition;
    }
}