<?php

namespace Win7\Application\Manager\DataTable;

/**
 * @author Thiago Daher
 */
class ColumnDefinition
{

    public const SEARCH_LIKE_END_ONLY = 2;
    public const SEARCH_LIKE = 1;
    public const SEARCH_EQUAL = 0;

    public const INNER_JOIN = 0;
    public const LEFT_JOIN = 1;

    /**
     * @var bool
     */
    private bool $orderable;

    /**
     * @var bool
     */
    private bool $searchable;

    /**
     * @var int
     */
    private int $searchType;

    /**
     * @var int
     */
    private int $position;

    /**
     * @var callable|null
     */
    private $callback;

    /**
     * @var int
     */
    private int $join;

    /**
     * @var bool
     */
    private bool $loadFromDb;

    /**
     * @param array $params
     */
    public function __construct(array $params)
    {
        $this->orderable  = $params['orderable'] ?? false;
        $this->searchable = $params['searchable'] ?? false;
        $this->searchType = $params['search_type'] ?? self::SEARCH_LIKE;
        $this->callback   = $params['callback'] ?? null;
        $this->join       = $params['join'] ?? self::INNER_JOIN;
        $this->loadFromDb = $params['load_from_db'] ?? true;
        $this->position   = $params['position'] ?? 0;
    }

    /**
     * @return bool
     */
    public function isOrderable(): bool
    {
        return $this->orderable;
    }

    /**
     * @return bool
     */
    public function isSearchable(): bool
    {
        return $this->searchable;
    }

    /**
     * @return int
     */
    public function getSearchType(): int
    {
        return $this->searchType;
    }

    /**
     * @return int
     */
    public function getPosition(): int
    {
        return $this->position;
    }

    /**
     * @param int $position
     */
    public function setPosition(int $position): void
    {
        $this->position = $position;
    }

    /**
     * @return callable|null
     */
    public function getCallback(): ?callable
    {
        return $this->callback;
    }

    /**
     * @param callable|null $callback
     */
    public function setCallback(?callable $callback): void
    {
        $this->callback = $callback;
    }

    /**
     * @return int
     */
    public function getJoin(): int
    {
        return $this->join;
    }

    /**
     * @return bool
     */
    public function isLoadFromDb(): bool
    {
        return $this->loadFromDb;
    }

    /**
     * @param bool $loadFromDb
     */
    public function setLoadFromDb(bool $loadFromDb): void
    {
        $this->loadFromDb = $loadFromDb;
    }

    /**
     * @param int $join
     */
    public function setJoin(int $join): void
    {
        $this->join = $join;
    }
}