<?php

namespace Win7\Application\Manager;

use Illuminate\Database\ConnectionInterface;
use Win7\Application\Repository\RepositoryManager;

/**
 * Representa um serviço com regras de negócio intimamente
 * relacionadas às entidades de banco de dados.
 *
 * @package App\Manager
 * @author Thiago Daher
 */
abstract class Manager
{

    /**
     * @var \Win7\Application\Repository\RepositoryManager
     */
    private RepositoryManager $repositoryManager;

    /**
     * @param \Win7\Application\Repository\RepositoryManager $repositoryManager
     */
    public function __construct(RepositoryManager $repositoryManager)
    {
        $this->repositoryManager = $repositoryManager;
    }

    /**
     * @return \Win7\Application\Repository\Repository|object
     * @throws \ReflectionException
     */
    public function getRepository()
    {
        return $this->repositoryManager->get($this->getRepositoryClass());
    }

    /**
     * @return string
     */
    abstract protected function getRepositoryClass(): string;

    /**
     * @throws \Throwable
     */
    public function beginTransaction()
    {
        $this->getConnection()->beginTransaction();
    }

    /**
     * @return \Illuminate\Database\ConnectionInterface
     */
    protected function getConnection(): ConnectionInterface
    {
        return $this->repositoryManager->getConnection();
    }

    /**
     * @throws \Throwable
     */
    public function rollBack()
    {
        $this->getConnection()->rollBack();
    }

    /**
     * @throws \Throwable
     */
    public function commit()
    {
        $this->getConnection()->commit();
    }

    /**
     * @return \Win7\Application\Repository\RepositoryManager
     */
    protected function getRepositoryManager(): RepositoryManager
    {
        return $this->repositoryManager;
    }
}