<?php

namespace Win7\Application\Repository;

use Illuminate\Database\ConnectionInterface;
use ReflectionClass;
use RuntimeException;

/**
 * @namespace Win7\Application\Repository
 * @author Thiago Daher
 */
class RepositoryManager
{

    private ConnectionInterface $connection;

    /**
     * @var Repository[]
     */
    private array $cache;

    /**
     * @param \Illuminate\Database\ConnectionInterface $connection
     */
    public function __construct(ConnectionInterface $connection)
    {
        $this->connection = $connection;
    }

    /**
     * @return \Illuminate\Database\ConnectionInterface
     */
    public function getConnection(): ConnectionInterface
    {
        return $this->connection;
    }

    /**
     * @param \Illuminate\Database\ConnectionInterface $connection
     */
    public function setConnection(ConnectionInterface $connection): void
    {
        $this->connection = $connection;
    }

    /**
     * Retorna o repositório especificado.
     *
     * @param string $repositoryClass
     * @return \Win7\Application\Repository\Repository|object
     * @throws \ReflectionException
     */
    public function get(string $repositoryClass): Repository
    {
        if (isset($this->cache[$repositoryClass])) {
            return $this->cache[$repositoryClass];
        }

        if (!class_exists($repositoryClass)) {
            throw new RuntimeException('The repository does not exist!');
        }

        $reflection = new ReflectionClass($repositoryClass);

        if (!$reflection->isSubclassOf(Repository::class)) {
            throw new RuntimeException('The specified class is not an repository!');
        }

        $repository  = new $repositoryClass();
        $entityClass = $repository->getEntityClass();
        $repository->setEntity(new $entityClass());
        $repository->setRepositoryManager($this);
        $this->cache[$repositoryClass] = $repository;

        return $repository;
    }
}