<?php

namespace Win7;

use Win7\Utils\DotNotation;

/**
 * @author Thiago Daher
 */
final class Config
{

    /**
     * @var \Win7\Utils\DotNotation
     */
    private $dotNotation;

    /**
     * @param array $settings
     */
    public function __construct(array $settings)
    {
        $this->dotNotation = new DotNotation($settings);
    }

    /**
     * Obtém a configuração com nome especificado.
     *
     * @param string $param nome da configuração
     * @param null $defaultValue
     * @return array|mixed|string|null
     */
    public function get(string $param, $defaultValue = null)
    {
        return $this->dotNotation->get($param, $defaultValue);
    }
}