<?php

namespace Win7\Phone\Controller;

use DI\Annotation\Inject;
use Win7\Application\Controller\Controller;
use Win7\Application\Manager\FilterParams;
use Win7\Phone\DataTable\CallTable;
use Win7\Phone\Manager\CallManager;
use Win7\Phone\Service\DatabaseUpdater;

/**
 * @namespace Win7\Phone\Controller
 * @author Thiago Daher
 */
class CallController extends Controller
{

    /**
     * @Inject()
     * @var \Win7\Phone\DataTable\CallTable
     */
    public CallTable $callTable;

    /**
     * @Inject()
     * @var \Win7\Phone\Manager\CallManager
     */
    public CallManager $callManager;

    /**
     * @Inject()
     * @var \Win7\Phone\Service\DatabaseUpdater
     */
    public DatabaseUpdater $updater;

    /**
     * @return void
     * @throws \ReflectionException
     * @throws \Win7\Application\Exception\UserException
     */
    public function listar()
    {
        $this->respondWithJson($this->callTable->getTableList(new FilterParams($_POST)));
    }

    /**
     * @return void
     * @throws \ReflectionException
     */
    public function listarSubligacoes()
    {
        $this->respondWithJson($this->callManager->getSubligacoes(new FilterParams($_POST)));
    }
}