<?php

namespace Win7\Phone\Entity;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Win7\Application\Entity\DatabaseEntity;

/**
 * @namespace Win7\Phone\Entity
 * @author Thiago Daher
 *
 * @property int $id
 * @property int $external_id
 * @property int|null $cliente_id
 * @property Carbon $start_time
 * @property Segment[]|Collection $segments
 * @property int $total_talking_duration
 * @property int $last_talking_duration
 * @property int $total_ringing_duration
 * @property int $last_ringing_duration
 * @property bool $answered
 * @property bool $antiga
 * @property string $cost
 * @property string $source_caller_id
 * @property string $source_display_name
 * @property string $source_number
 * @property int $source_type
 * @property string $destination_caller_id
 * @property string $destination_display_name
 * @property string $destination_number
 * @property int $destination_type
 * @property int $charge_type
 * @property int $charge_minutes
 * @property string $category
 * @property string $source
 * @property string $destination
 * @property string $real_cost
 * @property string|null $real_total_duration
 * @property string|null $real_talking_duration
 * @property string|null $real_ringing_duration
 */
class Call extends DatabaseEntity
{

    public const NO_CHARGE = 0;
    public const CHARGE_CELL_PHONE = 1;
    public const CHARGE_LANDLINE = 2;

    /**
     * @var string
     */
    protected $table = 'call';

    /**
     * @var array
     */
    protected $casts = [
        'answered'   => 'boolean',
        'antiga'   => 'boolean',
        'start_time' => 'datetime:Y-m-d H:i:s',
        'cost'       => 'decimal:2',
        'real_cost'  => 'decimal:2',
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function segments(): HasMany
    {
        return $this->hasMany(Segment::class);
    }

    /**
     * @return string
     */
    public function getSourceNumberFromData(): string
    {
        if (!empty($this->source_caller_id) && ctype_digit($this->source_caller_id)) {
            return $this->source_caller_id;
        }

        return $this->source_display_name;
    }

    /**
     * @return string
     */
    public function getDestinationNumberFromData(): string
    {
        if (!empty($this->destination_caller_id)) {
            return $this->destination_caller_id;
        }

        if (!empty($this->destination_number)) {
            return $this->destination_number;
        }

        return $this->destination_display_name;
    }
}