<?php

namespace Win7\Phone\Entity;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Win7\Application\Entity\DatabaseEntity;

/**
 * @namespace Win7\Phone\Entity
 * @author Thiago Daher
 *
 * @property int $id
 * @property int $call_id
 * @property Call $call
 * @property bool $answered
 * @property string $cost
 * @property Carbon $start_time
 * @property Carbon $end_time
 * @property string $source_caller_id
 * @property string $source_display_name
 * @property string $source_number
 * @property string $source_type
 * @property string $destination_caller_id
 * @property string $destination_display_name
 * @property string $destination_number
 * @property string $destination_type
 * @property string $recording_url
 * @property string $source_ramal
 * @property string $destination_ramal
 * @property string $source_filter
 * @property string $destination_filter
 * @property string $action_filter
 * @property int $ringing_duration
 * @property int $talking_duration
 * @property string $action_dn_dn
 * @property string $action_dn_caller_id
 * @property string $action_dn_display_name
 * @property string $creation_method
 * @property string $creation_forward_reason
 * @property string $termination_reason
 * @property string $termination_reason_details
 * @property string $destination_dn_type
 * @property int $action_dn_type
 * @property int $action_type
 * @property int $indent
 * @property int $subrow_desc_number
 */
class Segment extends DatabaseEntity
{

    /**
     * @var string
     */
    protected $table = 'call_segment';

    /**
     * @var array
     */
    protected $casts = [
        'answered' => 'boolean',
        'start_time' => 'datetime:Y-m-d H:i:s',
        'end_time' => 'datetime:Y-m-d H:i:s',
        'cost' => 'decimal:2',
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function call(): BelongsTo
    {
        return $this->belongsTo(Call::class);
    }

    /**
     * @return string
     */
    public function getSourceNumberFromData(): string
    {
        if (!empty($this->source_caller_id) && ctype_digit($this->source_caller_id)) {
            return $this->source_caller_id;
        }

        return $this->source_display_name;
    }

    /**
     * @return string
     */
    public function getDestinationNumberFromData(): string
    {
        if (!empty($this->destination_caller_id)) {
            return $this->destination_caller_id;
        }

        if (!empty($this->destination_number)) {
            return $this->destination_number;
        }

        return $this->destination_display_name;
    }
}