<?php

namespace Win7\Ads\Report;

/**
 * Representa uma requisição de um relatório do ads.
 *
 * @author Thiago Daher
 */
class ReportRequest
{

    /**
     * Montador da query do relatório.
     *
     * @var \Win7\Ads\Report\QueryBuilder
     */
    private $queryBuilder;

    /**
     * ID do cliente.
     *
     * @var string
     */
    private $customerId;

    /**
     * Construtor
     */
    public function __construct()
    {
        $this->queryBuilder = new QueryBuilder();
        $this->customerId   = '';
    }

    /**
     * Verifica se a requisição é válida.
     *
     * @return bool
     */
    public function isValid(): bool
    {
        return $this->queryBuilder->isValid() && !empty($this->customerId);
    }

    /**
     * @return string
     */
    public function getCustomerId(): string
    {
        return $this->customerId;
    }

    /**
     * @param string $customerId
     */
    public function setCustomerId(string $customerId): void
    {
        $this->customerId = preg_replace('/[^0-9]/', '', $customerId);
    }

    /**
     * @return \Win7\Ads\Report\QueryBuilder
     */
    public function getQueryBuilder(): QueryBuilder
    {
        return $this->queryBuilder;
    }
}