<?php
/*
 * Este arquivo é responsável por montar a modal que serve para editar uma indicação especificada.
 */

require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_indicacoes == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if($_POST['id'] != "-1" & !ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	if($_POST['id'] == "-1"){ // Se a ID for -1, o usuário está tentando visualizar nosso perfil
		$nome = "Agência Win7";
		$email = "contato@win7.com.br";
		$telefone = "(61) 3028-4940";
	}
	else{
		// Obtém os dados do usuário no banco de dados
		$dados = $sistema->indicacoes->obter_usuario($_POST['id']);

		if($sistema->bd->quantidade() == 0){ // Os dados não foram encontrados, então a ID é inválida
			echo "-2ID inválida!";
			exit;
		}
		
		// Prepara os dados para a exibição no modal
		$select_produtos = $sistema->indicacoes->select_comissoes("");
		$produto_editavel = $sistema->indicacoes->produto_editavel($dados);
		$nome = $dados['TXT_NOME'];
		$telefone = $dados['TEL_CEL'];
		$email = $dados['TXT_EMAIL'];
		$flag_cpf = strlen($dados['NU_CPF']) == 11;
		$cpf = Mascara::mascara_cpf_cnpj($dados['NU_CPF']);
		$status = $dados['TXT_STATUS'];
		$qualidade = $dados['TXT_QUALIDADE'];

		// Formata os valores monetários
		$fechado = number_format(floatval($dados['VALOR_FECHADO']/100),2,',','.');
		$combinado = number_format(floatval($dados['VALOR_COMBINADO']/100),2,',','.');
		$saldo = $sistema->indicacoes->usa_pontos == "1" ? number_format(intval($dados['TXT_SALDO']),0,',','.') : $sistema->indicacoes->simbolo_dinheiro." ". number_format(floatval($dados['TXT_SALDO']/100),2,',','.');
		$saldo_cadastro = $sistema->indicacoes->usa_pontos == "1" ? number_format(intval($dados['TXT_SALDO_CADASTRO']),0,',','.') : $sistema->indicacoes->simbolo_dinheiro." ". number_format(floatval($dados['TXT_SALDO_CADASTRO']/100),2,',','.');

		// Se o sistema for do tipo de faculdades, carrega os dados específicos desse sistema
		if($sistema->indicacoes->tipo ==  Sistema_Indicacoes::FACULDADES){
			$unidade = $dados['TXT_UNIDADE'];
			$unidade = empty($unidade) ? "Não Informada" : $unidade;
			$curso = $dados['TXT_CURSO'];
			$curso = empty($curso) ? "Não Informado" : $curso;
			$data_prova = $dados['TXT_DATA_PROVA'];
			$data_prova = empty($data_prova) ? "Não Informada" : $data_prova;
			$bairro = $dados['TXT_BAIRRO'];
			$bairro = empty($bairro) ? "Não Informado" : $bairro;
			$cidade = $dados['TXT_CIDADE'];
			$cidade = empty($cidade) ? "Não Informada" : $cidade;

			if($dados["NU_TIPO"] == "1"){
				$tipo_captador = $sistema->indicacoes->funcionario_faculdade();
				$tipo_captador = $tipo_captador[intval($dados['NU_TIPO_FUNC'])];
			}
		}

		if(empty($dados['NU_CPF_IND'])) // Se o usuário não foi indicado por ninguém específico, consideramos que ele foi indicado pela Win7
			$indicador_por = "Agência Win7";
		else{
			$dado = $sistema->indicacoes->obter_usuario_por_cpf($dados['NU_CPF_IND']);
			$indicador_por = $dado['TXT_NOME'];
		}

		$dados_fechamentos = $sistema->indicacoes->obter_fechamentos($_POST['id']);
	}
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}

if($_POST['id'] != "-1"){ // Se o usuário não for a Win7, montamos a modal normalmente

?>

<form action="" method="POST" id="formSistema">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
		<span aria-hidden="true">&times;</span></button>
		<h4 class="modal-title"><b><?php echo $nome;?></b> (<?php echo $cpf ?>) <a href="#" onclick="setClipboard('https://<?php echo $sistema->indicacoes->dominio; ?>/r/<?php echo $_POST['id']; ?>')" id="aidInd" style="background-color: #3c8dbc;color: white;padding: 6px 10px;border-radius: 6px;font-size: 0.8em;display: inline-block;">Copiar link de indicação</a></h4>
		<h6><?php if(!empty($indicador_por)) { ?> Indicado por <?php echo $indicador_por;?> / <?php } ?><b><?php echo $sistema->indicacoes->usa_pontos == "1" ? "Pontos" : "Saldo"; ?></b>: <?php echo $saldo;?><?php if(intval($dados['TXT_SALDO_CADASTRO']) > 0 ){ ?> / <b><?php echo $sistema->indicacoes->usa_pontos == "1" ? "Pontos" : "Saldo"; ?> de cadastro</b>: <?php echo $saldo_cadastro;?><?php } ?><?php if($sistema->indicacoes->tipo ==  Sistema_Indicacoes::FACULDADES) {?><br><b>Unidade:</b> <?php echo $unidade;?><?php if($dados["NU_TIPO"] == "1"){ ?> / <b>Tipo de Captador:</b> <?php echo $tipo_captador;?><?php }} ?></h6>
	</div>
	<div class="modal-body">
		<div class="row">
			<?php if($sistema->indicacoes->tipo ==  Sistema_Indicacoes::FACULDADES) {?>
			<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
				<label>Cidade:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-building"></i></div>
					<input type="text" class="form-control pull-right" id="cidade" name="cidade" value="<?php echo $cidade;?>" readonly/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
				<label>Bairro:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-building"></i></div>
					<input type="text" class="form-control pull-right" id="bairro" name="bairro" value="<?php echo $bairro;?>" readonly/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
				<label>Curso:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-graduation-cap"></i></div>
					<input type="text" class="form-control pull-right" id="curso" name="curso" value="<?php echo $curso;?>" readonly/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
				<label>Data da Prova:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-calendar"></i></div>
					<input type="text" class="form-control pull-right" id="data-prova" name="data-prova" value="<?php echo $data_prova;?>" readonly/>
				</div>
			</div></div>
		<?php } ?>
		</div>
		<div class="row">
			<div class="col-xs-12 col-md-7">
				<div class="row">
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>Nome:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-user"></i></div>
							<input type="text" class="form-control pull-right" id="nome" name="nome" alt="Nome" value="<?php echo $nome;?>" <?php if($sistema->usuario->permissao_indicacoes != Usuario::PERM_ESCRITA || $sistema->usuario->super_adm_indicacoes == false) { ?>readonly <?php }?>/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>Email:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-envelope"></i></div>
							<input type="text" class="form-control pull-right" id="email" name="email" alt="Email" value="<?php echo $email;?>" <?php if($sistema->usuario->permissao_indicacoes != Usuario::PERM_ESCRITA || $sistema->usuario->super_adm_indicacoes == false) { ?>readonly <?php }?>/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>Telefone:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-phone"></i></div>
							<input type="text" class="form-control pull-right" id="telefone" name="telefone" alt="Telefone" value="<?php echo $telefone;?>" <?php if($sistema->usuario->permissao_indicacoes != Usuario::PERM_ESCRITA || $sistema->usuario->super_adm_indicacoes == false) { ?>readonly <?php }?>/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>Status:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-check-circle"></i></div>
							<select name="status" id="status" class="form-control pull-right"  <?php if($sistema->usuario->permissao_indicacoes != Usuario::PERM_ESCRITA){ echo "disabled";}?>>
								<?php $sistema->layout->select_status($status);?>
							</select>
						</div>
					</div></div>
				</div>
			</div>
			<div class="col-xs-12 col-md-5">
				<div class="form-group">
					<label>Anotações:</label>
					<textarea name="anotacoes" id="anotacoes" class="form-control" rows="5" <?php if($sistema->usuario->permissao_indicacoes != Usuario::PERM_ESCRITA){ echo "disabled";}?>><?php echo $dados['TXT_ANOTACOES']; ?></textarea>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12">
				<?php if($sistema->usuario->permissao_indicacoes == Usuario::PERM_ESCRITA & ($sistema->indicacoes->ativar_recorrencia == "1" || ($sistema->indicacoes->ativar_recorrencia == "0" & count($dados_fechamentos) == 0))) { ?><a class="btn btn-primary" href="javascript:void(0);" id="botao-fechamento" onclick="exibirFormFechamento();">Adicionar Fechamento</a><?php } ?>
			</div>
			<div class="col-xs-12 adicionar-fechamento" style="display: none;">
				<hr style="margin-bottom: 8px; margin-top: 8px;">
				<div class="row">
					<?php if($sistema->indicacoes->ativar_recorrencia == "0") {?>
					<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
						<label>Valor Fechado:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-dollar"></i></div>
							<input type="text" class="form-control pull-right dinheiro" id="valor-fechamento" name="valor-fechamento" maxlength="15"/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
						<label>Descrição:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-edit"></i></div>
							<input type="text" class="form-control pull-right" id="descricao-fechamento" name="descricao-fechamento" maxlength="30" />
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
						<label>Categoria:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-gift"></i></div>
							<select name="produto-fechamento" id="produto-fechamento" class="form-control pull-right">
								<?php echo $select_produtos; ?>
							</select>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
						<label> </label>
						<a class="btn btn-primary btn-block btn-success" href="javascript:void(0);" onclick="adicionarFechamento();" style="margin-top: 5px;">Adicionar</a>
					</div></div>
					<?php } else {?>
					<div class="col-xs-12 col-sm-4 col-md-2"><div class="form-group">
						<label>Quantidade:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-asterisk"></i></div>
							<select name="quantidade-fechamento" id="quantidade-fechamento" class="form-control pull-right">
								<option value="1">1</option>
								<option value="2">2</option>
								<option value="3">3</option>
								<option value="4">4</option>
								<option value="5">5</option>
								<option value="6">6</option>
								<option value="7">7</option>
								<option value="8">8</option>
								<option value="9">9</option>
								<option value="10">10</option>
							</select>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-4 col-md-2"><div class="form-group">
						<label>Valor Fechado:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-dollar"></i></div>
							<input type="text" class="form-control pull-right dinheiro" id="valor-fechamento" name="valor-fechamento" maxlength="15"/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-4 col-md-3"><div class="form-group">
						<label>Descrição:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-edit"></i></div>
							<input type="text" class="form-control pull-right" id="descricao-fechamento" name="descricao-fechamento" maxlength="30" />
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
						<label>Categoria:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-gift"></i></div>
							<select name="produto-fechamento" id="produto-fechamento" class="form-control pull-right">
								<?php echo $select_produtos; ?>
							</select>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6 col-md-2"><div class="form-group">
						<label> </label>
						<a class="btn btn-primary btn-block btn-success" href="javascript:void(0);" onclick="adicionarFechamento();" style="margin-top: 5px;">Adicionar</a>
					</div></div>
					<?php }?>
				</div>
				<hr style="margin-bottom: 10px; margin-top: 2px;">
			</div>
			<div class="col-xs-12">
				<div id="tabelaComissoes" class="tabela">
					<table id="tbComissoes" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>
				</div>
			</div>
		</div>
	</div>
	<div class="modal-footer">
		<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
		<?php if($sistema->usuario->permissao_indicacoes == Usuario::PERM_ESCRITA) { ?><button type="button" id="botao-salvar" name="action" class="btn btn-primary btn-success" onclick="salvarDadosIndicado();" style="display: none;">Salvar Alterações</button><?php } ?>
	</div>
	<div class="overlay preloader">
		<i class="fa fa-refresh fa-spin"></i>
	</div>
</form>
<script>
var maskBehavior = function (val) {
	return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
},
options = {onKeyPress: function(val, e, field, options) {
	field.mask(maskBehavior.apply({}, arguments), options);}
};

<?php  
switch ($sistema->indicacoes->mascara_dinheiro) {
	case 'brasil':
		$mascara = "$('#telefone').mask(maskBehavior, options);";
		break;

	case 'eua':
		$mascara = "$('#telefone').mask('(000) 000-0000');";
		break;
	
	default:
		$mascara = "$('#telefone').mask(maskBehavior, options);";
		break;
}
echo $mascara;
?>
// $('#telefone').mask(maskBehavior, options);

$('#telefone,#email,#nome,#anotacoes').bind('input', function(){
	$('#botao-salvar').css({display:"inline-block"});
	modificacoesFeitas = true;

});

$('#status').change(function(){
	$('#botao-salvar').css({display:"inline-block"});
	modificacoesFeitas = true;
});

var idIndicadoModal = "<?php echo $_POST['id']; ?>";

function salvarDadosIndicado(){
	dadosIndicadoSalvos = true;
	$('#modal-sistema-indicado').modal('hide');
}

<?php if($sistema->usuario->super_adm_indicacoes == "1" && $sistema->usuario->permissao_indicacoes == Usuario::PERM_ESCRITA) { ?>
function deletarFechamento(id){
	delecaoFechamentos.push(id);
	var table = $('#tbComissoes').DataTable();
	var tableRow = table.row(".idFechamento"+id.toString());
	var rowData = tableRow.data();
	if (rowData == null){
		return;
	}
	tableRow.remove();
	table.draw(false);
	$('#botao-salvar').css({display:"inline-block"});
	modificacoesFeitas = true;
}
function deletarFechamentoNovo(id){
	var table = $('#tbComissoes').DataTable();
	var tableRow = table.row(".idFechamento"+id.toString());
	var rowData = tableRow.data();
	if (rowData == null){
		return;
	}
	var index = listaFechamentos.indexOf(rowData[6]);
	listaFechamentos.splice(index, 1);
	tableRow.remove();
	table.draw(false);
	$('#botao-salvar').css({display:"inline-block"});
	modificacoesFeitas = true;
}
<?php }?>

var fechamentosCarregados1 = false;

function carregarFechamentos(){
	if(fechamentosCarregados1 == false){
		var json = JSON.parse('<?php echo json_encode($dados_fechamentos, JSON_HEX_APOS) ?>');
		var table_data = [];
		for (var i=0; i < json.length; i++){
			var date = Date.parse(json[i].data).toString('dd/MM/yyyy HH:mm:ss');
			<?php if($sistema->usuario->super_adm_indicacoes == "1") { ?>var editar = "<div class='btn-group'><a href= 'javascript:void(0);' onclick='deletarFechamento("+json[i].id+")' class='btn btn-default text-red' title='Clique para deletar o fechamento.'><i class='fa fa-trash'></i></a></div>";<?php }?>
			table_data[i] = [json[i].descricao, json[i].valorfechado, json[i].produto, date <?php if($sistema->usuario->super_adm_indicacoes == "1") { ?>, editar, json[i].id<?php }?>];
		}
		$(document).ready(function() {
			$.fn.dataTable.moment( 'DD/MM/YYYY HH:mm:ss');
			$('#tabelaComissoes').html('<table id="tbComissoes" style="width: 100%;" class="table table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>');
			$('#tbComissoes').DataTable({
				"data": table_data,
				"order": [[ 3, 'desc' ]],
				"columns": [{"title": "Descrição", "class": "center"}, {"title": "Valor Fechado", "class": "center"},{"title": "Categoria", "class": "center"}, {"title": "Dia do Registro", "class": "center"}<?php if($sistema->usuario->super_adm_indicacoes == "1") { ?>, {"title": "Opções", "class": "table-buttons"} <?php }?>],
				"lengthMenu": [[5], ["5"]],
				responsive: true,
				<?php if($sistema->usuario->super_adm_indicacoes == "1") { ?>"columnDefs": [{"targets": 4, "orderable": false}],<?php }?>
				"searching": false,
				"bLengthChange": false,
				"deferRender": true,
				<?php if($sistema->usuario->super_adm_indicacoes == "1") { ?>
				"createdRow": function ( row, data, index ) {
					$(row).addClass("idFechamento"+data[5]);
				}
				<?php }?>
			});
		});
		fechamentosCarregados1 = true;
	}	
}

<?php if($sistema->usuario->permissao_indicacoes == Usuario::PERM_ESCRITA) { ?>

function adicionarFechamento(){
	var descricao = $('#descricao-fechamento').val();
	var valor = $('#valor-fechamento').val();
	var produto = $('#produto-fechamento').val();
	var textoProduto = $("#produto-fechamento option:selected").text();
	var quantidadeProduto = parseInt($("#quantidade-fechamento").val());
	if(descricao.length == 0){
		toastr.clear(); toastr.error("Por favor, digite uma descrição"); return;
	}
	if(valor.length < 4){
		toastr.clear(); toastr.error("Por favor, digite um valor válido"); return;
	}
	var valorFloat = valor.replace(".","");
	valorFloat = parseFloat(valorFloat.replace(",","."));
	if(valorFloat == 0){
		toastr.clear(); toastr.error("Por favor, digite um valor válido"); return;
	}

	var newRows = [];
	var tabelaFechamentos = $('#tbComissoes').DataTable();
	<?php if($sistema->indicacoes->ativar_recorrencia == "0") {?>
	var objFechamento = {};
	objFechamento.descricao = descricao;
	objFechamento.valor = valor;
	objFechamento.produto = produto;
	listaFechamentos.push(objFechamento);
	var idFechamento = "-" + listaFechamentos.length;
	<?php if($sistema->usuario->super_adm_indicacoes == "1") { ?>var editar = "<div class='btn-group'><a href= 'javascript:void(0);' onclick='deletarFechamentoNovo("+idFechamento+")' class='btn btn-default text-red' title='Clique para deletar o fechamento.'><i class='fa fa-trash'></i></a></div>";<?php }?>
	newRows.push([descricao + " (Pendente)", "R$ " + valor, textoProduto, moment().format('DD/MM/Y HH:mm:ss')<?php if($sistema->usuario->super_adm_indicacoes == "1") { ?>, editar, idFechamento, objFechamento<?php }?>]);
	<?php }else{?>
	for(var c = 0;c < quantidadeProduto;c++){
		var objFechamento = {};
		objFechamento.descricao = descricao;
		objFechamento.valor = valor;
		objFechamento.produto = produto;
		listaFechamentos.push(objFechamento);
		var idFechamento = "-" + listaFechamentos.length;
		<?php if($sistema->usuario->super_adm_indicacoes == "1") { ?>var editar = "<div class='btn-group'><a href= 'javascript:void(0);' onclick='deletarFechamentoNovo("+idFechamento+")' class='btn btn-default text-red' title='Clique para deletar o fechamento.'><i class='fa fa-trash'></i></a></div>";<?php }?>
		newRows.push([descricao + " (Pendente)", "R$ " + valor, textoProduto, moment().format('DD/MM/Y HH:mm:ss')<?php if($sistema->usuario->super_adm_indicacoes == "1") { ?>, editar, idFechamento, objFechamento<?php }?>]);
	}
	<?php }?>
	tabelaFechamentos.rows.add(newRows);
	tabelaFechamentos.draw(false);
	esconderFormFechamento();
	$('#descricao-fechamento').val("");
	$('#valor-fechamento').val("");
	<?php if($sistema->indicacoes->ativar_recorrencia == "0") {?>$('#botao-fechamento').css({display:"none"});<?php }?>
	$('#botao-salvar').css({display:"inline-block"});
	modificacoesFeitas = true;
}

function esconderFormFechamento(){
	$('.adicionar-fechamento').css({display:"none"});
}

function exibirFormFechamento(){
	$('.adicionar-fechamento').css({display:"block"});
	$('#valor-fechamento').focus();
}

<?php } ?>

function atualizar_status(){
	var current = $('#status').val();
	if(current == "Fechado")
		$('#status').css('color','green');
	else if(current == "Perdeu" || current == "Não é Cliente")
		$('#status').css('color','red');
	else if(current == "Novo")
		$('#status').css('color','blue');
	else
		$('#status').css('color','#555');
}
$(document).ready(function(){
	atualizar_status();
	$('#status').change(atualizar_status);
	$('.dinheiro').mask('000.000.000.000.000,00', {reverse: true});
});
</script>
<?php } else {?>
<div class="modal-header">
	<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
	<span aria-hidden="true">&times;</span></button>
	<h4 class="modal-title"><b>Editar usuário:</b> <?php echo $nome;?></h4>
</div>
<div class="modal-body">
	<div class="row">
		<div class="col-xs-12 col-sm-4 col-md-6"><div class="form-group">
			<label>Telefone:</label>
			<div class="input-group">
				<div class="input-group-addon"><i class="fa fa-phone"></i></div>
				<input type="text" class="form-control pull-right" id="telefone" name="telefone" alt="Telefone" value="<?php echo $telefone;?>" readonly/>
			</div>
		</div></div>
		<div class="col-xs-12 col-sm-8 col-md-6"><div class="form-group">
			<label>Email:</label>
			<div class="input-group">
				<div class="input-group-addon"><i class="fa fa-envelope"></i></div>
				<input type="text" class="form-control pull-right" id="email" name="email" alt="Email" value="<?php echo $email;?>" readonly/>
			</div>
		</div></div>
	</div>
</div>
<div class="modal-footer">
	<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
</div>
<?php } ?>

<script>
function setClipboard(value) {var tempInput = document.createElement("input");tempInput.style = "position: absolute; left: -1000px; top: -1000px";tempInput.value = value;document.body.appendChild(tempInput);tempInput.select();document.execCommand("copy");document.body.removeChild(tempInput);$('#aidInd').text('Copiado!');}
</script>