<?php
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_indicacoes != Usuario::PERM_ESCRITA || $sistema->indicacoes->usa_pontos != "1") {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	$sql = "SELECT * FROM TBL_INDICACOES_PRODUTOS WHERE NU_ID = :id AND ID_CLIENTE_FK = :id2 AND NU_DELETADO = 0";
	$params = array(
		':id' => $_POST['id'],
		':id2' => $sistema->usuario->id
	);
	$premio = $sistema->bd->executar($sql, $params, Banco_Dados::FETCH);

	if($sistema->bd->quantidade() == 0){ // Nenhum dado foi encontrado, ID é inválida
		echo "-2ID inválida!";
		exit;
	}

	$nome = $premio['TXT_NOME'];
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>
<div class="modal-header">
	<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
	<span aria-hidden="true">&times;</span></button>
	<h4 class="modal-title"><b>Confirmação</b></h4>
</div>

<div class="modal-body">
	Tem certeza de que deseja deseja deletar o prêmio <b>"<?php echo $nome;?>"</b>?<br>
	<b>ATENÇÃO:</b> A ação é permanente e não pode ser revertida.
</div>
<div class="modal-footer">
	<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Não</button>
	<a class="btn btn-primary" href="javascript:void(0);" onclick="deletar_premio();">Sim</a>
</div>
<div class="overlay preloader">
	<i class="fa fa-refresh fa-spin"></i>
</div>

<script>
function deletar_premio(){
	var dados = "id=<?php echo $_POST['id']; ?>";
	jQuery.ajax({
		type: "POST",
		url: "action/salvar_modal_premio_deletar",
		data: dados,
		success: function(data){
			$('.preloader').css({display:"none"});
			if(data == '-1') {window.location.href = "./"; return;}
			if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
			fechar_modal_confirmacao();
			remover_premio(<?php echo $_POST['id']; ?>);
			toastr.clear(); toastr.success("Prêmio deletado com sucesso."); return;
		},
		beforeSend: function(){
			$('.preloader').css({display:"block"});
		},
		complete: function(){
			$('.preloader').css({display:"none"});
		},
		error: function(){
			$('.preloader').css({display:"none"});
			toastr.clear(); toastr.error("Houve um erro ao deletar."); return;
		}
	});
}
</script>