<?php
/***
	Este arquivo é responsável por retornar um json contendo
	todos os usuários do sistema de arquivos
***/

require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso ao drive
if($sistema->usuario->permissao_drive == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

// Validamos aqui se o filtro de pesquisa está correto
if(!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])){
	echo "-2Filtro de pesquisa inválido";
	exit;
}

try {
	$rows = $sistema->drive->obter_usuarios($_POST['data'], $_POST['datainicial'], $_POST['datafinal']);
	
	echo json_encode_alt($rows);
}
catch (Exception $e) {
	echo "-2Houve um erro com o servidor";
	exit;
}
?>