<?php
/*
 * Este arquivo é responsável por atualizar a página de "Campanhas" do sistema.
 * Para isso, ele faz uma pesquisa dos grupos de anúncios do cliente usando a API,
 * emitindo um JSON ao final.
 */

use Win7\Ads\Entity\CustomerFilter;
use Win7\Ads\Repository\CampaignRepository;
use Win7\App;

require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às campanhas do google
if ($sistema->usuario->permissao_google == Usuario::PERM_NENHUMA) {
    echo "-2Permissão insuficiente para ver esta página!";
    exit;
}

// Validamos aqui se o filtro de pesquisa está correto
if (!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])) {
    echo "-2Filtro de pesquisa inválido";
    exit;
}

/* Esvazia-se as datas customizadas caso o filtro não seja personalizado */
if ($_POST['data'] != "CUSTOM_DATE") {
    $_POST['datainicial'] = "";
    $_POST['datafinal']   = "";
}

try {
    if ($sistema->usuario->tem_adwords()) { // Verificamos de o adwords do cliente está configurado
        App::initialize();
        $rows = App::getContainer()
            ->get(CampaignRepository::class)
            ->getListWithMetrics($sistema->get_filtro_ads());

        $resultado = [];

        foreach ($rows as $row) {
            $campaign = $row['campaign'];
            $metrics  = $row['metrics'];

            $linha = [
                "campaign"      => $campaign["name"],
                "impressions"   => Sistema_Adwords::formatar_numero($metrics["impressions"]),
                "clicks"        => Sistema_Adwords::formatar_numero($metrics["clicks"]),
                "ctr"           => number_format($metrics['ctr'] * 100, 2) . "%",
                "imprAbsTop"    => number_format($metrics['absoluteTopImpressionPercentage'] * 100),
                "imprTop"       => number_format($metrics['topImpressionPercentage'] * 100),
                "invalid"       => Sistema_Adwords::formatar_numero($metrics["invalidClicks"]),
                "paused"        => $campaign["status"] == "PAUSED" ? "t" : "f",
                "campaignID"    => $campaign["id"],
                "campaignState" => strtolower($campaign["status"]),
            ];

            // Caso o cliente seja de consultoria, adicionamos os campos de custo e cpc
            if ($sistema->usuario->consultoria) {
                $linha["avgCPC"] = Sistema_Adwords::formatar_valor($metrics["averageCpc"], $sistema->usuario->moeda);
                $linha["cost"]   = Sistema_Adwords::formatar_valor($metrics["costMicros"], $sistema->usuario->moeda);
            }

            $resultado[] = $linha;
        }

        // Adicionamos ao resultado uma flag que indicará se o cliente é de consultoria
        array_unshift($resultado, $sistema->usuario->consultoria);

        echo json_encode_alt($resultado);
    } else { // Nesse caso, o cliente não tem adwords configurado, retornamos então um resultado vazio
        echo json_encode_alt([$sistema->usuario->consultoria]);
        exit;
    }
} catch (Exception $e) {
    $sistema->adwords->tratar_excecao($e);
}
?>