<?php
/*
 * Este arquivo é responsável por atualizar a página de "Ver Contatos" do sistema.
 * Para isso, ele faz uma pesquisa de todos os leads de um certo período, e monta um
 * JSON contendo tais informações.
 */
 
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_leads == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

// Validamos aqui se o filtro de pesquisa está correto
if(!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])){
	echo "-2Filtro de pesquisa inválido";
	exit;
}

try{
	$sistema->iniciar_bd_leads();

	$filtro = Filtro::filtrar_data($_POST['data'], "DT_ATUAL", $_POST['datainicial'], $_POST['datafinal']); // Montamos o filtro SQL de data
	
	$sql = empty($filtro) ? 
	"SELECT ID_LEAD, TXT_NOME, TXT_EMAIL, NU_TELEFONE1, DT_ATUAL, TXT_LEAD_CLIENTE, TXT_SITUACAO, TXT_QUALI, TXT_PRECO_FECHADO, TXT_PRECO, TXT_LEADTIPO, TXT_IDENTIFICADOR FROM TBL_LEADS WHERE ID_CLIENTE_FK = :id AND TXT_LEADTIPO != 'Link Clique' AND NU_LIXEIRA = '0' " :
	"SELECT ID_LEAD, TXT_NOME, TXT_EMAIL, NU_TELEFONE1, DT_ATUAL, TXT_LEAD_CLIENTE, TXT_SITUACAO, TXT_QUALI, TXT_PRECO_FECHADO, TXT_PRECO, TXT_LEADTIPO, TXT_IDENTIFICADOR FROM TBL_LEADS WHERE ".$filtro." AND ID_CLIENTE_FK = :id AND TXT_LEADTIPO != 'Link Clique' AND NU_LIXEIRA = '0' ";
	
	// Fazemos aqui a consulta dos contatos
	$dados = $sistema->bd_leads->executar($sql,array(':id' => $sistema->usuario->id),Banco_Dados::FETCH_ALL);
	
	// Finalmente, montamos uma array que conterá todos os contatos em um formato fácil de ser lido por JSON
	$resultado = array();
	foreach($dados as $linha){
		$sql = "SELECT * FROM TBL_LEADS_CAMPOS WHERE NU_ID_LEAD = :id";
		
		$resultado[] = array(
			'id' => $linha['ID_LEAD'],
			'nome' => $linha['TXT_NOME'],
			'email' => $linha['TXT_EMAIL'],
			'telefone' => $linha['NU_TELEFONE1'],
			'data' => $linha['DT_ATUAL'],
			'tipo' => $linha['TXT_LEADTIPO'],
			'status' => $linha['TXT_SITUACAO'],
			'identificador' => $linha['TXT_IDENTIFICADOR'] == null ? "" : $linha['TXT_IDENTIFICADOR'],
			'qualidade' => empty($linha['TXT_QUALI']) ? "--" : $linha['TXT_QUALI'],
			'valorfechado' => number_format(floatval($linha['TXT_PRECO_FECHADO']/100),2,',','.'),
			'valororcado' => number_format(floatval($linha['TXT_PRECO']/100),2,',','.')
		);
	}
	
	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>