<?php
/*
 * Este arquivo é responsável por retornar um json contendo o histórico
 * do indicador especificado.
 */

require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_indicacoes == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

// Validamos aqui se o filtro de pesquisa está correto
if(!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])){
	echo "-2Filtro de pesquisa inválido";
	exit;
}

if(!ctype_digit($_POST['id'])){
	echo "-2ID inválida!";
	exit;
}

try {
	$rows = $sistema->indicacoes->obter_historico($_POST['id'], $_POST['data'], $_POST['datainicial'], $_POST['datafinal']);

	if ($rows == -1){
		echo "-2ID inválida!";
		exit;
	}

	echo json_encode_alt($rows);
}
catch (Exception $e) {
	echo "-2Houve um erro com o servidor";
	exit;
}
?>