<?php
/*
 * Este arquivo é responsável por atualizar a página da lixeira de contatos
 */
 
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_leads != Usuario::PERM_ESCRITA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

// Validamos aqui se o filtro de pesquisa está correto
if(!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])){
	echo "-2Filtro de pesquisa inválido";
	exit;
}

try{
	$sistema->iniciar_bd_leads();

	$filtro = Filtro::filtrar_data($_POST['data'], "DT_ATUAL", $_POST['datainicial'], $_POST['datafinal']); // Montamos o filtro SQL de data
	
	$sql = empty($filtro) ? 
	"SELECT * FROM TBL_LEADS WHERE ID_CLIENTE_FK = :id AND NU_LIXEIRA = '1' " :
	"SELECT * FROM TBL_LEADS WHERE ".$filtro." AND ID_CLIENTE_FK = :id AND NU_LIXEIRA = '1' ";
	
	// Fazemos aqui a consulta dos contatos
	$dados = $sistema->bd_leads->executar($sql,array(':id' => $sistema->usuario->id),Banco_Dados::FETCH_ALL);
	
	// Finalmente, montamos uma array que conterá todos os contatos em um formato fácil de ser lido por JSON
	$resultado = array();
	foreach($dados as $linha){
		$sql = "SELECT * FROM TBL_LEADS_CAMPOS WHERE NU_ID_LEAD = :id";

		$campos = $sistema->bd_leads->executar($sql,array(':id' => $linha['ID_LEAD']),Banco_Dados::FETCH_ALL);
		$dados_extras = "";
		foreach($campos as $campo){
			$dados_extras .= $campo['TXT_NOME'] . " " . $campo['TXT_CONTEUDO'] . " ";
		}

		$mensagem = $linha['TXT_MENSAGEM'] . $dados_extras;
		
		$resultado[] = array(
			'id' => $linha['ID_LEAD'],
			'nome' => $linha['TXT_NOME'],
			'email' => $linha['TXT_EMAIL'],
			'telefone' => $linha['NU_TELEFONE1'],
			'data' => $linha['DT_ATUAL'],
			'status' => $linha['TXT_SITUACAO'],
			'qualidade' => empty($linha['TXT_QUALI']) ? "--" : $linha['TXT_QUALI'],
			'valorfechado' => number_format(floatval($linha['TXT_PRECO_FECHADO']/100),2,',','.'),
			'valororcado' => number_format(floatval($linha['TXT_PRECO']/100),2,',','.')
		);
	}
	
	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>