<?php
/*
 * Este arquivo é responsável por atualizar a página de "Palavras-chave" do sistema.
 * Para isso, ele faz uma pesquisa de todos as palavras-chave do grupo de anúncios configurado, e monta um
 * JSON contendo tal informação.
 */

use Win7\Ads\Repository\AdGroupRepository;
use Win7\Ads\Repository\KeywordViewRepository;
use Win7\App;

require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às campanhas do google
if ($sistema->usuario->permissao_google == Usuario::PERM_NENHUMA) {
    echo "-2Permissão insuficiente para ver esta página!";
    exit;
}

// Validamos aqui se o filtro de pesquisa está correto
if (!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])) {
    echo "-2Filtro de pesquisa inválido";
    exit;
}

/* Esvazia-se as datas customizadas caso o filtro não seja personalizado */
if ($_POST['data'] != "CUSTOM_DATE") {
    $_POST['datainicial'] = "";
    $_POST['datafinal']   = "";
}

try {
    if ($sistema->usuario->tem_adwords()) { // Verificamos se o cliente possui adwords configurado
        $_SESSION['palavras'] = $_POST['grupo'];

        // Separa o id do grupo do id da campanha
        // $idGrupo_idCampanha[0] -> Id do Grupo
        // $idGrupo_idCampanha[1] -> Id da Campanha
        $idGrupo_idCampanha = explode("|%|", $_POST['grupo']);

        $idGrupo = isset($idGrupo_idCampanha[0]) && $idGrupo_idCampanha[0] !== 'todos' ?
            $idGrupo_idCampanha[0] : null;

        App::initialize();
        $rows = App::getContainer()
            ->get(KeywordViewRepository::class)
            ->getListWithMetrics($sistema->get_filtro_ads(), $idGrupo);

        // Montamos aqui a array que será enviada por meio de JSON
        $resultado = [];

        foreach ($rows as $row) {
            $keyword = $row['adGroupCriterion']['keyword']['text'];
            $metrics = $row['metrics'];

            // Removemos aqui os "+" das palavras-chave
            $keyword = str_replace("+", "", $keyword);

            if ($keyword == "Content") {
                continue;
            }

            $linha = [
                "keyword"             => $keyword,
                "impressions"         => Sistema_Adwords::formatar_numero($metrics["impressions"]),
                "clicks"              => Sistema_Adwords::formatar_numero($metrics["clicks"]),
                "convertedClicks"     => Sistema_Adwords::formatar_numero($metrics["conversions"]),
                "clickConversionRate" => number_format($metrics["conversionsFromInteractionsRate"] * 100, 2) . "%",
                "ctr"                 => number_format($metrics['ctr'] * 100, 2) . "%",
                "imprAbsTop"          => number_format($metrics['absoluteTopImpressionPercentage'] * 100),
                "imprTop"             => number_format($metrics['topImpressionPercentage'] * 100),
            ];

            // Caso o cliente seja de consultoria, adicionamos os campos de custo e cpc
            if ($sistema->usuario->consultoria) {
                $linha["avgCPC"] = Sistema_Adwords::formatar_valor($metrics["averageCpc"], $sistema->usuario->moeda);
                $linha["cost"]   = Sistema_Adwords::formatar_valor($metrics["costMicros"], $sistema->usuario->moeda);
            }

            $resultado[] = $linha;
        }

        // Adicionamos ao resultado uma flag que indicará se o cliente é de consultoria
        array_unshift($resultado, $sistema->usuario->consultoria);
        echo json_encode_alt($resultado);
    } else { // O adwords do cliente não está configurado, então retornamos um resultado vazio
        echo json_encode_alt([$sistema->usuario->consultoria]);
        exit;
    }
} catch (Exception $e) {
    $sistema->adwords->tratar_excecao($e);
}
?>