<?php 
/*
 * Este arquivo é responsável por montar um arquivo excel contendo todos os leads do nosso cliente,
 * considerando um determinado período.
 */
 
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true);

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\IOFactory;

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_3cx == Usuario::PERM_NENHUMA) $sistema->redirecionar("../home");

// Validamos aqui se o filtro de pesquisa está correto
if(!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])){
	$_SESSION['erro-baixar-ligacoes'] = 0;
	$sistema->redirecionar("../baixar-ligacoes");
}

try{
	$sistema_win7fone = new Sistema_Win7Fone($sistema->usuario->id, $sistema->bd);
	$resultado = $sistema_win7fone->obter_ligacoes($_POST['data'],$_POST['datainicial'], $_POST['datafinal'], false, false);
	$total = count($resultado);

	if($total > 6500){
		$_SESSION['erro-baixar-ligacoes'] = 2;
		$sistema->redirecionar("../baixar-ligacoes");
	}

	// Inicializa o excel
	$arquivo = $sistema->usuario->nome.' - Win7 Fone - '.trim(Filtro::texto($_POST['data']));

	$spreadsheet = new Spreadsheet();

	$spreadsheet->getProperties()
	    ->setCreator('Agência Win7')
	    ->setLastModifiedBy('Agência Win7')
	    ->setTitle('Relatório de Ligações')
	    ->setSubject('Relatório de Ligações')
	    ->setDescription('Relatório de Ligações gerado pelo Sistema Win7')
	    ->setKeywords('sistemawin7');

	// Configura as colunas fixas do excel
	$sheet = $spreadsheet->setActiveSheetIndex(0);
	$sheet->setCellValue('A1', 'Fonte');
	$sheet->getStyle("A1")->getFont()->setBold(true);
	$sheet->getColumnDimension('A')->setWidth("25");

	$sheet->setCellValue('B1', 'Dia da Ligação');
	$sheet->getStyle("B1")->getFont()->setBold(true);
	$sheet->getColumnDimension('B')->setWidth("25");

	$sheet->setCellValue('C1', 'Origem');
	$sheet->getStyle("C1")->getFont()->setBold(true);
	$sheet->getColumnDimension('C')->setWidth("25");

	$sheet->setCellValue('D1', 'Destino Final');
	$sheet->getStyle("D1")->getFont()->setBold(true);
	$sheet->getColumnDimension('D')->setWidth("25");

	$sheet->setCellValue('E1', 'Custo');
	$sheet->getStyle("E1")->getFont()->setBold(true);
	$sheet->getColumnDimension('E')->setWidth("25");

	$sheet->setCellValue('F1', 'Duração Final');
	$sheet->getStyle("F1")->getFont()->setBold(true);
	$sheet->getColumnDimension('F')->setWidth("25");

	$sheet->setCellValue('G1', 'Resultado');
	$sheet->getStyle("G1")->getFont()->setBold(true);
	$sheet->getColumnDimension('G')->setWidth("25");

	$sheet->setCellValue('H1', 'Duração Total');
	$sheet->getStyle("H1")->getFont()->setBold(true);
	$sheet->getColumnDimension('H')->setWidth("25");

	$sheet->setCellValue('I1', 'Tempo de Espera');
	$sheet->getStyle("I1")->getFont()->setBold(true);
	$sheet->getColumnDimension('I')->setWidth("25");

    $sheet->setCellValue('J1', 'Nome');
    $sheet->getStyle('J1')->getFont()->setBold(true);
    $sheet->getColumnDimension('J')->setWidth("50");

    $sheet->setCellValue('K1', 'Anotações');
    $sheet->getStyle('K1')->getFont()->setBold(true);
    $sheet->getColumnDimension('K')->setWidth("50");

	// Adiciona todos os contatos ao excel
	for($i = 1;$i < $total;$i++){
		$ligacao = $resultado[$i];
		$data = date("d/m/Y H:i:s", strtotime($ligacao['data']));
		$sheet->setCellValue("A".($i+1), $ligacao['fonte']);
		$sheet->setCellValue("B".($i+1), $data);
		$sheet->setCellValueExplicit("C".($i+1), $ligacao['origem'], \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
		$sheet->setCellValueExplicit("D".($i+1), $ligacao['destino'], \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
		$sheet->setCellValue("E".($i+1), $ligacao['valor']);
		$sheet->setCellValue("F".($i+1), $ligacao['duracao']);
		if($ligacao['atendida'] == "Atendida"){
			$sheet->getStyle("G".($i+1))->getFont()->getColor()->setRGB("008000");
		}
		else{
			$sheet->getStyle("G".($i+1))->getFont()->getColor()->setRGB("ff0000");
		}
		$sheet->setCellValue("G".($i+1), $ligacao['atendida']);
		$sheet->setCellValue("H".($i+1), $ligacao['duracaofinal']);
		$sheet->setCellValue("I".($i+1), $ligacao['espera']);

        if($ligacao['valido']){
            $contato = $sistema->bd->executar(
                "SELECT TXT_NOME, TXT_ANOTACOES FROM TBL_LEADS WHERE NU_TELEFONE1 = :telefone  AND ID_CLIENTE_FK = :cliente AND TXT_LEADTIPO = 'Win7 Fone' LIMIT 1",
                [
                    ':telefone' => $ligacao['origem'],
                    ':cliente' => $sistema->usuario->id,
                ],
                Banco_Dados::FETCH
            );
            if($contato){
                $sheet->setCellValue("J".($i+1), $contato['TXT_NOME']);
                $sheet->setCellValue("K".($i+1), $contato['TXT_ANOTACOES']);
            }
        }
	}

	// Configura as colunas para assumirem largura automática
	//foreach(range('A','G') as $columnID) {
	//    $excel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
	//}

	$sistema->logs->adicionar_log_geracao_relatorio_ligacoes();

	// Cria os headers
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header('Content-Disposition: attachment;filename="'.$arquivo.'.xlsx"');
	header('Cache-Control: max-age=1');
	header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
	header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
	header('Cache-Control: cache, must-revalidate');
	header('Pragma: public');

	$spreadsheet->getActiveSheet()->setTitle('Relatório de Ligações');

	// Envia o excel para o usuário
	$writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
	$writer->save('php://output');
	exit;
}
catch(Exception $e){
	$_SESSION['erro-baixar-ligacoes'] = 1;
	$sistema->redirecionar("../baixar-ligacoes");
}
?>