<?php 
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\IOFactory;

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_google == Usuario::PERM_NENHUMA) $sistema->redirecionar("../home");

try{
	$json = json_decode($_SESSION['excel-palavras-negativas']);

	$total = count($json);

	if($total > 2000){
		$_SESSION['erro-baixar-palavras-negativas'] = 2;
		$sistema->redirecionar("../palavras-negativas");
	}

	// Inicializa o excel
	$arquivo = $sistema->usuario->nome . ' - Palavras-chave negativas';
	
	$spreadsheet = new Spreadsheet();

	$spreadsheet->getProperties()
	    ->setCreator('Agência Win7')
	    ->setLastModifiedBy('Agência Win7')
	    ->setTitle('Relatório de Palavras-chave negativas')
	    ->setSubject('Relatório de Palavras-chave negativas')
	    ->setDescription('Relatório de Palavras-chave negativas gerado pelo Sistema Win7')
	    ->setKeywords('sistemawin7');

	// Configura as colunas fixas do excel
	$sheet = $spreadsheet->setActiveSheetIndex(0);
	$sheet->setCellValue('A1', 'Palavras Chave negativas');
	$sheet->getStyle("A1")->getFont()->setBold(true);
	$sheet->getColumnDimension('A')->setWidth("30");

	$sheet->setCellValue('B1', 'Adicionado a');
	$sheet->getStyle("B1")->getFont()->setBold(true);
	$sheet->getColumnDimension('B')->setWidth("30");

	$sheet->setCellValue('C1', 'Nível');
	$sheet->getStyle("C1")->getFont()->setBold(true);
	$sheet->getColumnDimension('C')->setWidth("30");

	$sheet->setCellValue('D1', 'Correspondência');
	$sheet->getStyle("D1")->getFont()->setBold(true);
	$sheet->getColumnDimension('D')->setWidth("30");

	$count = 2;
	for ($i=1; $i < $total;$i++){
		$row = $json[$i];

		if ($row->matchType == 'Phrase') { $correspondecia = 'Frase'; }
		if ($row->matchType == 'Exact') { $correspondecia = 'Exata'; }
		if ($row->matchType == 'Broad') { $correspondecia = 'Ampla'; }

		$sheet->setCellValue('A'.$count, $row->negativeKeyword);
		$sheet->setCellValue('B'.$count, $row->campaign);
		$sheet->setCellValue('C'.$count, $row->negativeKeywordNivel);
		$sheet->setCellValue('D'.$count, $correspondecia);

		$count++;
	}

	$sistema->logs->adicionar_log_geracao_relatorio_palavras_negativas();
	
	// Cria os headers
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header('Content-Disposition: attachment;filename="'.$arquivo.'.xlsx"');
	header('Cache-Control: max-age=1');
	header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
	header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
	header ('Cache-Control: cache, must-revalidate');
	header ('Pragma: public');
	
	// O tilulo não pode ser muito grande se nao da erro
	$spreadsheet->getActiveSheet()->setTitle('Relat. Palavras-chave negativas');

	// Envia o excel para o usuário
	$writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
	$writer->save('php://output');
	exit;
}
catch(Exception $e){
	$_SESSION['erro-baixar-palavras-negativas'] = "Houve um erro com o servidor";
	redirecionar("../palavras-negativas");
}
?>