<?php
/*
 * Este arquivo é responsável por montar a modal que serve para editar o email especificado.
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_envio_email == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	$resultado = $sistema->obter_email($_POST['id']);

	if($sistema->bd->quantidade() == 0){ // Nenhum dado foi encontrado, ID é inválida
		echo "-2ID inválida!";
		exit;
	}

	$assunto = $resultado['TXT_ASSUNTO'];
	$nome = $resultado['TXT_NOME'];
	$arquivo = $resultado['TXT_ARQUIVO'];
	$mensagem = $resultado['TXT_MENSAGEM'];
	$remetente = $resultado['TXT_EMAIL'];

	$dest = explode(" |$| ", $resultado['TXT_DESTINATARIOS']);
	$destinatarios = array();
	if($dest != false){
		$qtd_destinatarios = count($dest);
		if($qtd_destinatarios % 2 == 0){
			for($i = 0; $i < $qtd_destinatarios / 2; $i++){
				$destinatarios[$dest[$i+$qtd_destinatarios / 2]] = $dest[$i];
			}
		}
	}

	$ocu = explode(" |$| ", $resultado['TXT_COPIAS_OCULTAS']);
	$ocultas = array();
	if($dest != false){
		$qtd_ocultas = count($ocu);
		if($qtd_ocultas % 2 == 0){
			for($i = 0; $i < $qtd_ocultas / 2; $i++){
				$ocultas[$ocu[$i+$qtd_ocultas / 2]] = $ocu[$i];
			}
		}
	}

	$tipo = $resultado['NU_TIPO'];
	$status = $resultado['NU_STATUS'];
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>
<script>
$(document).ready(function(){
	$('#formEmail2').submit(function(){
		var dados = jQuery( this ).serialize() + "&id=<?php echo $_POST['id']; ?>";
		jQuery.ajax({
			type: "POST",
			url: "action/salvar_modal_email_adm",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				fechar_modal();
				atualizar_linha(JSON.parse(data));
				toastr.clear(); toastr.success("Dados salvos com sucesso."); return;
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao salvar."); return;
			}
		});
		return false;
	});
});
</script>

<form action="" method="POST" id="formEmail2">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
		<span aria-hidden="true">&times;</span></button>
		<h4 class="modal-title"><b>Visualizar E-mail:</b></h4>
	</div>
	<div class="modal-body">
		<div class="row">
			<div class="col-xs-12 col-sm-6"><div class="form-group">
				<label>Assunto:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-envelope"></i></div>
					<input type="text" class="form-control pull-right"  id="assunto" name="assunto" alt="Assunto" value="<?php echo $assunto;?>" <?php if($status != "2"){ ?> readonly<?php } ?> required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6"><div class="form-group">
				<label>Arquivo que Gerou:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-file"></i></div>
					<input type="text" class="form-control pull-right"  id="arquivo" name="arquivo" alt="Arquivo" value="<?php echo $arquivo;?>" readonly/>
				</div>
			</div></div>
			<?php
			$counter = 1;
			foreach($destinatarios as $dEmail => $dNome){
				?>
			<div class="col-xs-12 col-sm-6"><div class="form-group">
				<label>Destinatário <?php echo $counter; ?>:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-user"></i></div>
					<input type="text" class="form-control pull-right"  id="destinatario<?php echo $counter; ?>" name="destinatario<?php echo $counter; ?>" alt="Destinatário" value="<?php echo $dEmail;?>" <?php if($status != "2"){ ?> readonly<?php } ?>/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6"><div class="form-group">
				<label>Nome do Destinatário <?php echo $counter; ?>:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-user"></i></div>
					<input type="text" class="form-control pull-right"  id="destinatarioNome<?php echo $counter; ?>" name="destinatarioNome<?php echo $counter; ?>" alt="Nome do Destinatário" value="<?php echo $dNome;?>" <?php if($status != "2"){ ?> readonly<?php } ?>/>
				</div>
			</div></div>
			<?php
				$counter++;
			}
			?>
			<?php
			$counter = 1;
			foreach($ocultas as $oEmail => $oNome){
				?>
			<div class="col-xs-12 col-sm-6"><div class="form-group">
				<label>Cópia Oculta <?php echo $counter; ?>:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-user"></i></div>
					<input type="text" class="form-control pull-right"  id="oculta<?php echo $counter; ?>" name="oculta<?php echo $counter; ?>" alt="Cópia Oculta" value="<?php echo $oEmail;?>" <?php if($status != "2"){ ?> readonly<?php } ?>/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6"><div class="form-group">
				<label>Nome da Cópia Oculta <?php echo $counter; ?>:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-user"></i></div>
					<input type="text" class="form-control pull-right"  id="ocultaNome<?php echo $counter; ?>" name="ocultaNome<?php echo $counter; ?>" alt="Nome da Cópia Oculta" value="<?php echo $oNome;?>" <?php if($status != "2"){ ?> readonly<?php } ?>/>
				</div>
			</div></div>
			<?php
				$counter++;
			}
			?>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-6"><div class="form-group">
				<label>Mensagem:</label>
				<textarea name="mensagem" id="mensagem" class="form-control" rows="5" <?php if($status != "2"){ ?> readonly<?php } ?>><?php echo $mensagem; ?></textarea>
			</div></div>
			<div class="col-xs-12 col-sm-6"><div class="form-group">
				<div class="row">
					<div class="col-xs-12"><div class="form-group">
						<label>Nome do Remetente:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-user"></i></div>
							<input type="text" class="form-control pull-right"  id="nome" name="nome" alt="Nome do Remetente" value="<?php echo $nome;?>" <?php if($status != "2"){ ?> readonly<?php } ?> required/>
						</div>
					</div></div>
					<div class="col-xs-12"><div class="form-group">
						<label>Remetente:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-user"></i></div>
							<input type="text" class="form-control pull-right"  id="remetente" name="remetente" alt="Remetente" value="<?php echo $remetente;?>" <?php if($status != "2"){ ?> readonly<?php } ?> required/>
						</div>
					</div></div>
				</div>
			</div></div>
		</div>
	</div>
	<div class="modal-footer">
		<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
		<?php if($status == "2"){ ?><button type="submit" name="action" class="btn btn-primary">Salvar E-mail</button><?php } ?>
	</div>
	<div class="overlay preloader">
		<i class="fa fa-refresh fa-spin"></i>
	</div>
</form>