<?php
/*
 * Este arquivo cria a modal que possibilita a edição dos dados de
 * um cliente da agência.
 */

require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

if(!$sistema->usuario->super_adm_adm) {
	echo "-2Permissão Insuficiente";
	exit;
}
?>

<script>
function salvarDados(){
	var dados = jQuery('#formDados').serialize();
	$(document).ready(function(){
		jQuery.ajax({
			type: "POST",
			url: "action/salvar_modal_novo_admin",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				fechar_modal();
				adicionar_administradores(JSON.parse(data));
				toastr.clear(); toastr.success("Administrador criado com sucesso."); return;
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro a criar administrador."); return;
			}
		});
	});
}
$(document).ready(function(){
	$('#formDados').submit(function(){
		salvarDados();
		return false;
	})
});
</script>

<form name="formDados" action="" method="POST" id="formDados">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
		<span aria-hidden="true">&times;</span></button>
		<h4 class="modal-title"><b>Criar Administrador:</b></h4>
	</div>
	<div class="modal-body">
		<div class="nav-tabs-custom">
			<ul class="nav nav-tabs">
				<li class="active"><a href="#tab_1" data-toggle="tab">Geral</a></li>
				<li><a href="#tab_2" data-toggle="tab">Permissões</a></li>
			</ul>
			<div class="tab-content">
				<div class="tab-pane active" id="tab_1">
					<div class="row">
						<div class="col-xs-12"><div class="form-group">
							<div class="checkbox">
								<label>
									<input type="checkbox" name="superadm" id="superadm" value="Sim">
									É Super Administrador&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
							</div>
						</div></div>
					</div>
					<div class="row">
						<div class="col-xs-12 col-sm-6"><div class="form-group">
							<label>Nome:</label>
							<div class="input-group">
								<div class="input-group-addon"><i class="fa fa-user"></i></div>
								<input type="text" class="form-control pull-right"  id="nome" name="nome" alt="Nome" required/>
							</div>
						</div></div>
						<div class="col-xs-12 col-sm-6"><div class="form-group">
							<label>Email:</label>
							<div class="input-group">
								<div class="input-group-addon"><i class="fa fa-envelope"></i></div>
								<input type="text" class="form-control pull-right"  id="email" name="email" alt="Email" required/>
							</div>
						</div></div>
						<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
							<label>WhatsApp Business:</label>
							<div class="input-group">
								<div class="input-group-addon"><i class="fa fa-whatsapp"></i></div>
								<input type="text" class="form-control pull-right"  id="whatsapp" name="whatsapp" alt="WhatsApp" />
							</div>
						</div></div>
						<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
							<label>Login:</label>
							<div class="input-group">
								<div class="input-group-addon"><i class="fa fa-user"></i></div>
								<input type="text" class="form-control pull-right"  id="login" name="login" alt="Login" required />
							</div>
						</div></div>
						<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
							<label>Senha:</label>
							<div class="input-group">
								<div class="input-group-addon"><i class="fa fa-lock"></i></div>
								<input type="text" class="form-control pull-right"  id="senha" name="senha" alt="Senha" required />
							</div>
						</div></div>
					</div>
				</div>
				<div class="tab-pane" id="tab_2">
					<div class="row">
						<div class="col-xs-12"><div class="form-group">
							<div class="checkbox">
								<label>
									<input type="checkbox" name="permclientes" id="permclientes" value="Sim" checked="checked">
									Sistema de Clientes&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="permemail" id="permemail" value="Sim" checked="checked">
									Sistema de Envio de E-mail&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="permindicacoes1" id="permindicacoes1" value="Sim" checked="checked">
									Tela Geral do Sistema de Indicações&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="permresultados" id="permresultados" value="Sim" checked="checked">
									Resultados Gerais&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="permgsuite" id="permgsuite" value="Sim">
									Agendamentos do G Suite&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="permtodoscontatos" id="permtodoscontatos" value="Sim" checked="checked">
									Todos os Contatos&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="permlog" id="permlog" value="Sim" checked="checked">
									Log de Usuários&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="permwin7fone" id="permwin7fone" value="Sim" checked="checked">
									Win7 Fone&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="permadwords" id="permadwords" value="Sim" checked="checked">
									Adwords&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="permarquivos" id="permarquivos" value="Sim" checked="checked">
									Sistema de Arquivos&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="comparacao" id="comparacao" value="Sim" checked="checked">
									Comparação dos dados gerais&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
							</div>
						</div></div>
					</div>
					<div class="row">
						<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
							<label>Contatos:</label>
							<div class="input-group">
								<div class="input-group-addon"><i class="fa fa-users"></i></div>
								<select name="permcontatos" id="permcontatos" class="form-control pull-right">
									<option value="0">Permitir Leitura</option>
									<option value="1" selected>Permitir Modificação</option>
									<option value="2">Não Permitir</option>
								</select>
							</div>
						</div></div>
						<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
							<label>Indicações:</label>
							<div class="input-group">
								<div class="input-group-addon"><i class="fa fa-smile-o"></i></div>
								<select name="permindicacoes2" id="permindicacoes2" class="form-control pull-right">
									<option value="0">Permitir Leitura</option>
									<option value="1" selected>Permitir Modificação</option>
									<option value="2">Não Permitir</option>
								</select>
							</div>
						</div></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="modal-footer">
		<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
		<button type="submit" name="action" class="btn btn-primary">Salvar Administrador</button>
	</div>
	<div class="overlay preloader">
		<i class="fa fa-refresh fa-spin"></i>
	</div>
</form>

<script>
var maskBehavior = function (val) {
	return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
},
options = {onKeyPress: function(val, e, field, options) {
	field.mask(maskBehavior.apply({}, arguments), options);}
};
$(document).ready(function(){
	$('#whatsapp').mask(maskBehavior, options);
});
</script>