<?php
/*
 * Este arquivo lê apenas os clientes que possuem sistema de indicação.
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_indicacoes_geral == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

try{
	// Faz a consulta no banco
	$dados = $sistema->bd->executar("SELECT * FROM TBL_CLI_DADOS", array(), Banco_Dados::FETCH_ALL);
	
	$resultado = array();
	
	foreach($dados as $linha){
		$id = $linha['ID_FK'];
		$saldo_win7 = Mascara::converter_para_real($linha['TXT_SALDO_AGENCIA']);

		// Obtém os dados originais do cliente
		$dado = $sistema->bd->executar("SELECT * FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $id), Banco_Dados::FETCH);

		$data_alteracao = $dado['NU_ACESSOS_SISTEMA_DATA'];
		if(Utilitarios::data_padrao_valida($data_alteracao)){
			$data_alteracao = strtotime($data_alteracao);
			$data_alteracao = date('d/m/Y H:i:s', $data_alteracao);
		}
		else{
			$data_alteracao = "Nunca";
		}

		// Calcula a soma do saldo de todos os indicadores
		$total_saldo = 0;
		$indicadores = $sistema->bd->executar("SELECT * FROM TBL_INDICACOES WHERE NU_CLIENTE = :id AND NU_TIPO = 1", array(':id' => $id), Banco_Dados::FETCH_ALL);
		foreach($indicadores as $row){
			$total_saldo += intval($row['TXT_SALDO']);
		}
		
		// Calcula a quantidade total que já foi paga
		$total = 0;
		$total_pago = 0;
		$indicadores = $sistema->bd->executar("SELECT * FROM TBL_PAG_PENDENTES WHERE ID_CLIENTE = :id AND (NU_PROCESSADO = 1 OR NU_PROCESSADO = 0)", array(':id' => $id), Banco_Dados::FETCH_ALL);
		foreach($indicadores as $row){
			if($row['NU_PROCESSADO'] == 0)
				$total += intval($row['TXT_VALOR']);
			else if($row['NU_PROCESSADO'] == 1)
				$total_pago += intval($row['TXT_VALOR']);
		}
		
		// Monta o JSON final
		$resultado[] = array(
			"id" => $id,
			"nome" => $linha['TXT_NOME'],
			"nomeempresa" => $dado['TXT_NOME_EMPRESA'],
			"login" => $dado['TXT_LOGIN'],
			"saldowin" => $saldo_win7,
			"saldoind" => Mascara::converter_para_real(strval($total_saldo)),
			"bonuspagos" => Mascara::converter_para_real(strval($total_pago)),
			"bonuspendentes" => Mascara::converter_para_real(strval($total)),
			"ramo" => $dado['TXT_RAMO'],
			"acesso" => $data_alteracao
		);
	}
	
	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>