<?php
/*
 * Este arquivo é responsável por atualizar a página de "Ver Contatos" do sistema.
 * Para isso, ele faz uma pesquisa de todos os leads de um certo período, e monta um
 * JSON contendo tais informações.
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_leads_adm == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_todos_contatos == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

// Validamos aqui se o filtro de pesquisa está correto
if(!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])){
	echo "-2Filtro de pesquisa inválido";
	exit;
}

try{
	$sistema->iniciar_bd_leads();

	$filtro = Filtro::filtrar_data($_POST['data'], "DT_ATUAL", $_POST['datainicial'], $_POST['datafinal']); // Montamos o filtro SQL de data
	
	$sql = empty($filtro) ? 
	"SELECT ID_LEAD, TXT_NOME, TXT_EMAIL, NU_TELEFONE1, DT_ATUAL, TXT_LEAD_CLIENTE, TXT_SITUACAO, TXT_QUALI, TXT_PRECO_FECHADO, TXT_PRECO FROM TBL_LEADS" :
	"SELECT ID_LEAD, TXT_NOME, TXT_EMAIL, NU_TELEFONE1, DT_ATUAL, TXT_LEAD_CLIENTE, TXT_SITUACAO, TXT_QUALI, TXT_PRECO_FECHADO, TXT_PRECO FROM TBL_LEADS WHERE ".$filtro;
	
	// Fazemos aqui a consulta dos contatos
	$dados = $sistema->bd_leads->executar($sql,array(),Banco_Dados::FETCH_ALL);
	
	if($sistema->bd_leads->quantidade() > 3000){
		echo "-2Há mais de 3.000 registros a serem exibidos.<br>Selecione um período menor.";
		exit;
	}

	// Finalmente, montamos uma array que conterá todos os contatos em um formato fácil de ser lido por JSON
	$resultado = array();
	foreach($dados as $linha){
		$resultado[] = array(
			'id' => $linha['ID_LEAD'],
			'nome' => $linha['TXT_NOME'],
			'email' => $linha['TXT_EMAIL'],
			'telefone' => $linha['NU_TELEFONE1'],
			'data' => $linha['DT_ATUAL'],
			'cliente' => $linha['TXT_LEAD_CLIENTE'],
			'status' => empty($linha['TXT_SITUACAO']) ? "--" : $linha['TXT_SITUACAO'],
			'qualidade' => empty($linha['TXT_QUALI']) ? "--" : $linha['TXT_QUALI'],
			'valorfechado' => number_format(floatval($linha['TXT_PRECO_FECHADO']/100),2,',','.'),
			'valororcado' => number_format(floatval($linha['TXT_PRECO']/100),2,',','.')
		);
	}
	
	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>