<?php
/*
 * Este arquivo salva os dados do administrador
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

if(!$sistema->usuario->super_adm_adm) {
	echo "-2Permissão Insuficiente";
	exit;
}

if(!ctype_digit($_POST['id'])){ // Verifica se a ID é um número
	echo "-2ID inválida!";
	exit;
}

try{
	$dados_adm = $sistema->bd->executar("SELECT * FROM TBL_ADM WHERE ID_ADM = :ID", array(":ID" => $_POST['id']), Banco_Dados::FETCH);
	
	if($sistema->bd->quantidade() == 0){
		echo "-2ID inválida!";
		exit;
	}

	$sistema->bd->executar("DELETE FROM TBL_ADM WHERE ID_ADM = :ID", array(":ID" => $_POST['id']), Banco_Dados::FETCH);

	$sistema->logs->adicionar_log_delecao_admin($dados_adm);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>