<?php
/*
 * Este arquivo salva os dados do sistema de indicações do cliente da agência.
 */
  
require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

if(!ctype_digit($_POST['id'])){ // Verifica se a ID é um número
	echo "-2ID inválida!";
	exit;
}

// Garante que o domínio não seja vazio
if(empty($_POST['dominio'])){
	echo "-2Insira um domínio";
	exit;
}

// Garante que o nome do sistema não seja vazio
if(empty($_POST['nome-sistema'])){
	echo "-2Insira um nome para o sistema";
	exit;
}

// Garante que sessão não seja vazia
if(empty($_POST['sessao'])){
	echo "-2Insira uma sessão";
	exit;
}


// Garante que o nome de exibição tenha sido inserido
if(empty($_POST['nome'])){
	echo "-2Insira um nome de exibição!";
	exit;
}

// Garante que a URL do favicon tenha sido inserida
if(empty($_POST['favicon'])){
	echo "-2Insira a URL do favicon!";
	exit;
}

// Garante que a URL do logo tenha sido inserida
if(empty($_POST['logo'])){
	echo "-2Insira a URL da logo!";
	exit;
}

// Garante que o telefone tenha sido informado
if(empty($_POST['telefone'])){
	echo "-2Insira um telefone!";
	exit;
}

// Garante que o email de avisos seja válido CASO tenha sido inserido
if(!empty($_POST['email']) & !Utilitarios::email_valido($_POST['email'])){
	echo "-2Insira um email válido!";
	exit;
}

// Verifica se a cor 1 é um hex válido
if(!Utilitarios::hex_valido($_POST['cor1'])){
	echo "-2Cor 1 inválida!";
	exit;
}

// Verifica se a cor 2 é um hex válido
if(!Utilitarios::hex_valido($_POST['cor2'])){
	echo "-2Cor 2 inválida!";
	exit;
}

// Verifica se a cor 3 é um hex válido
if(!Utilitarios::hex_valido($_POST['cor3'])){
	echo "-2Cor 3 inválida!";
	exit;
}

// Verifica se a cor 4 é um hex válido
if(!Utilitarios::hex_valido($_POST['cor4'])){
	echo "-2Cor 4 inválida!";
	exit;
}

// Verifica se a cor 5 é um hex válido
if(!Utilitarios::hex_valido($_POST['cor5'])){
	echo "-2Cor 5 inválida!";
	exit;
}

$ativado = $_POST['ativado'] == "Sim" ? 1 : 0; // verifica se o sistema está ativado

try{
	$sistema->bd->executar("SELECT * FROM TBL_CLI_GDRIVE WHERE ID_FK = :id", array('id' => $_POST['id']), Banco_Dados::FETCH);
	$row_count = $sistema->bd->quantidade();

	if($row_count > 0)
		$sql = 'UPDATE TBL_CLI_GDRIVE SET TXT_HOST = :dominio, TXT_SESSION = :sessao, NU_ATIVADO = :ativado, TXT_NOME = :nome, TXT_EMAIL = :email, TXT_LOGO = :logo, TXT_FAVICON = :favicon, TXT_TELEFONE = :telefone, TXT_CONTATO = :contato, TXT_COR1 = :cor1, TXT_COR2 = :cor2, TXT_COR3 = :cor3, TXT_COR4 = :cor4, TXT_COR5 = :cor5, TXT_NOME_SISTEMA = :nomesistema WHERE ID_FK = :id';
	else 
		$sql = 'INSERT INTO TBL_CLI_GDRIVE (ID_FK, TXT_HOST, TXT_SESSION, NU_ATIVADO, TXT_NOME, TXT_EMAIL, TXT_LOGO, TXT_FAVICON, TXT_TELEFONE, TXT_CONTATO, TXT_COR1, TXT_COR2, TXT_COR3, TXT_COR4, TXT_COR5, TXT_NOME_SISTEMA) VALUES (:id, :dominio, :sessao, :ativado, :nome, :email, :logo, :favicon, :telefone, :contato, :cor1, :cor2, :cor3, :cor4, :cor5, :nomesistema)';

	$parametros = array(
		':id' => $_POST['id'],
		':sessao' => $_POST['sessao'],
		':dominio' => $_POST['dominio'],
		':ativado' => $ativado,
		':nome' => $_POST['nome'],
		':email' => $_POST['email'],
		':cor1' => $_POST['cor1'],
		':cor2' => $_POST['cor2'],
		':cor3' => $_POST['cor3'],
		':cor4' => $_POST['cor4'],
		':cor5' => $_POST['cor5'],
		':favicon' => $_POST['favicon'],
		':logo' => $_POST['logo'],
		':telefone' => $_POST['telefone'],
		':contato' => $_POST['contato'],
		':nomesistema' => $_POST['nome-sistema']
	);

	$sistema->bd->executar($sql, $parametros);

	$sistema->logs->adicionar_log_salvar_dados_gdrive($_POST['nome'], $_POST['id']);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>