<?php
require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, false, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_indicacoes_geral == Usuario::PERM_NENHUMA) $sistema->redirecionar("home");
?>
<!DOCTYPE html>
<html>
<head><!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-MFFM5J3');</script>
<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<title>Sistema de Indicações - Sistema Win7</title>
	<link rel="icon" type="image/ico" href="favicon.png" />
	<link rel="stylesheet" href="../css/bootstrap.min.css">
	<link rel="stylesheet" href="../css/datatables.min.css"/>
	<link rel="stylesheet" href="../css/bootstrap-xl-xxl.css">
	<link rel="stylesheet" href="../css/font-awesome.min.css">
	<link rel="stylesheet" href="../css/ionicons.min.css">
	<link rel="stylesheet" href="../css/AdminLTE.min.css">
	<link rel="stylesheet" href="../css/skin-blue.min.css">
	<link rel="stylesheet" href="css/custom2.0.1.css">
	<link rel="stylesheet" href="../css/toastr.min.css">
	<link rel="stylesheet" href="../css/bootstrap-datepicker.min.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->criar_meta_tags();?>
</head>

<body class="hold-transition skin-blue sidebar-mini <?php if($sistema->usuario->sidebar) {echo "sidebar-collapse"; }?>">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MFFM5J3"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<div class="modal fade" id="modal-sistema"><div class="modal-dialog modal-lg"><div class="modal-content" id="modal-sistema-conteudo"></div></div></div>
<div class="modal fade" id="modal-confirmacao"><div class="modal-dialog"><div class="modal-content" id="modal-confirmacao-conteudo"></div></div></div>
<div class="wrapper">
	<?php $sistema->layout->exibir_cabecalho('indicacoes-adm');?>

	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
			Sistema de Indicações
			<small>Visualize os dados de todos os sistemas de indicações</small>
			</h1>
			<ol class="breadcrumb">
				<li><a href="indicacoes-adm"><i class="fa green-text fa-smile-o"></i> Sistema de Indicações</a></li>
			</ol>
		</section>

		<section class="content container-fluid">
			<div class="row">
				<div class="col-xs-12">
					<div class="box">
          				<div class="box-body">
          					<div id="tabelaClientes" class="tabela">
          						<table id="tbClientes" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>
          					</div>
          				</div>
          				<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
				</div>
			</div>
		</section>
	</div>

	<?php $sistema->layout->exibir_rodape();?>
</div>

<script src="../js/jquery.min.js"></script>
<script src="../js/datatables.min.js"></script>
<script src="../js/bootstrap.min.js"></script>
<script src="../js/adminlte.min.js"></script>
<script src="../js/bootstrap-datepicker.min.js"></script>
<script src="../js/bootstrap-datepicker.pt-BR.min.js"></script>
<script src="../js/toastr.min.js"></script>
<script src="../js/jquery.mask.min.js"></script>
<script src="../js/moment.min.js"></script>
<script src="../js/datetime-moment.js"></script>
<script src="../js/date.js"></script>
<script src="../js/filtros.js"></script>
<script src="js/indicacoes-adm2.0.3.js"></script>

</body>
</html>