<?php
require_once(__DIR__ . "/classes/Sistema.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if ($sistema->usuario->permissao_indicacoes == Usuario::PERM_NENHUMA) $sistema->redirecionar("home");
?>
<!DOCTYPE html>
<html>

<head>
	<!-- Google Tag Manager -->
	<script>
		(function(w, d, s, l, i) {
			w[l] = w[l] || [];
			w[l].push({
				'gtm.start': new Date().getTime(),
				event: 'gtm.js'
			});
			var f = d.getElementsByTagName(s)[0],
				j = d.createElement(s),
				dl = l != 'dataLayer' ? '&l=' + l : '';
			j.async = true;
			j.src =
				'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
			f.parentNode.insertBefore(j, f);
		})(window, document, 'script', 'dataLayer', 'GTM-MFFM5J3');
	</script>
	<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<title>Relatórios - Sistema Win7</title>
	<link rel="icon" type="image/ico" href="favicon.png" />
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap-xl-xxl.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/font-awesome.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/ionicons.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/AdminLTE.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/skin-blue.min.css">
	<link rel="stylesheet" href="css/custom2.0.1.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/toastr.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap-datepicker.min.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->criar_meta_tags(); ?>
</head>

<body class="hold-transition skin-blue sidebar-mini <?php if ($sistema->usuario->sidebar) {
																											echo "sidebar-collapse";
																										} ?>">
	<!-- Google Tag Manager (noscript) -->
	<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MFFM5J3" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
	<!-- End Google Tag Manager (noscript) -->
	<div class="modal fade" id="modal-sistema">
		<div class="modal-dialog modal-lg">
			<div class="modal-content" id="modal-sistema-conteudo"></div>
		</div>
	</div>
	<div class="wrapper">
		<?php $sistema->layout->exibir_cabecalho('baixar-indicacoes'); ?>

		<div class="content-wrapper">
			<!-- Content Header (Page header) -->
			<section class="content-header">
				<h1>
					Relatórios
					<small>Visualize relatórios do sistema de indicações</small>
				</h1>
				<ol class="breadcrumb">
					<li><a href="javascript:void(0);"><i class="fa green-text fa-smile-o"></i> Indicações</a></li>
					<li><a href="baixar-indicacoes"> Relatórios</a></li>
				</ol>
			</section>

			<section class="content container-fluid">
				<div class="row">
					<form action="action/baixar_excel_ganhos" method="POST" id="formGanhos">
						<div class="col-xs-12">
							<div class="box">
								<div class="box-header with-border">
									<b>Relatório de ganhos de comissão</b>
								</div>
								<div class="box-body">
									<div class="row">
										<div class="col-xs-12">
											<?php if (isset($_SESSION['erro-baixar-ganhos-indicacoes'])) { ?>
												<div class="row">
													<div class="col-lg-6 col-sm-6 col-xs-12">
														<div class="alert alert-danger alert-dismissible">
															<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
															<?php
															switch ($_SESSION['erro-baixar-ganhos-indicacoes']) {
																case 0:
																	echo "Filtro de pesquisa inválido";
																	break;
																case 1:
																	echo "Houve um erro com o servidor";
																	break;
																case 2:
																	echo "Há muitos registros a serem exibidos. Por favor, selecione um período menor.";
																	break;
															}
															?>
														</div>
													</div>
												</div>
											<?php unset($_SESSION['erro-baixar-ganhos-indicacoes']);
											} ?>
											<div class="row">
												<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
													<div class="form-group">
														<label>Período:</label>
														<select name="data" id="data" class="form-control" title="Selecione um perído">
															<?php $sistema->layout->select_periodo(false); ?>
														</select>
													</div>
												</div>
												<div class="hide datadiv">
													<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
														<div class="form-group">
															<label>Data Inicial:</label>
															<div class="input-group date">
																<div class="input-group-addon">
																	<i class="fa fa-calendar"></i>
																</div>
																<input type="text" class="form-control pull-right datepicker" name="datainicial" id="datainicial">
															</div>
														</div>
													</div>
													<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
														<div class="form-group">
															<label>Data Final:</label>
															<div class="input-group date">
																<div class="input-group-addon">
																	<i class="fa fa-calendar"></i>
																</div>
																<input type="text" class="form-control pull-right datepicker" class="datepicker" name="datafinal" id="datafinal">
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div class="col-xs-12">
											<p>Este relatório gera um excel contendo todos os ganhos de comissão de todos os indicadores no período selecionado. <br> Para gerar o relatório, basta clique em Gerar Arquivo.</p>
										</div>
									</div>
								</div>
								<div class="box-footer">
									<button type="submit" class="btn btn-primary text-center">Gerar Arquivo</button>
								</div>
							</div>
						</div>
					</form>
					<form action="action/baixar_excel_indicacoes" method="POST" id="formIndicacoes">
						<div class="col-xs-12">
							<div class="box">
								<div class="box-header with-border">
									<b>Relatório de lista de indicações</b>
								</div>
								<div class="box-body">
									<div class="row">
										<div class="col-xs-12">
											<?php if (isset($_SESSION['erro-baixar-indicacoes'])) { ?>
												<div class="row">
													<div class="col-lg-6 col-sm-6 col-xs-12">
														<div class="alert alert-danger alert-dismissible">
															<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
															<?php
															switch ($_SESSION['erro-baixar-indicacoes']) {
																case 0:
																	echo "Filtro de pesquisa inválido";
																	break;
																case 1:
																	echo "Houve um erro com o servidor";
																	break;
																case 2:
																	echo "Há muitos registros a serem exibidos. Por favor, selecione um período menor.";
																	break;
															}
															?>
														</div>
													</div>
												</div>
											<?php unset($_SESSION['erro-baixar-indicacoes']);
											} ?>
											<div class="row">
												<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
													<div class="form-group">
														<label>Período:</label>
														<select name="data" id="data2" class="form-control" title="Selecione um perído">
															<?php $sistema->layout->select_periodo(false); ?>
														</select>
													</div>
												</div>
												<div class="hide datadiv2">
													<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
														<div class="form-group">
															<label>Data Inicial:</label>
															<div class="input-group date">
																<div class="input-group-addon">
																	<i class="fa fa-calendar"></i>
																</div>
																<input type="text" class="form-control pull-right datepicker" name="datainicial" id="datainicial2">
															</div>
														</div>
													</div>
													<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
														<div class="form-group">
															<label>Data Final:</label>
															<div class="input-group date">
																<div class="input-group-addon">
																	<i class="fa fa-calendar"></i>
																</div>
																<input type="text" class="form-control pull-right datepicker" class="datepicker" name="datafinal" id="datafinal2">
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div class="col-xs-12">
											<p>Este relatório gera um excel contendo todos os usuários que se registraram no sistema no período selecionado. <br> Selecione abaixo os dados serão adicionados ao arquivo excel, e clique em Gerar Arquivo:</p>
											<div class="checkbox">
												<label>
													<input type="checkbox" name="nome" id="nome" value="Sim" checked="checked" disabled>
													Nome (Já Incluso)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
												</label>
												<label>
													<input type="checkbox" name="tipo" id="tipo" value="Sim" checked="checked" disabled>
													Tipo (Já Incluso)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
												</label>
												<label>
													<input type="checkbox" name="indicadopor" id="indicadopor" value="Sim" checked="checked" disabled>
													Indicado por (Já Incluso)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
												</label>
												<label>
													<input type="checkbox" name="email" id="email" value="Sim" checked="checked">
													Email&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
												</label>
												<label>
													<input type="checkbox" name="telefone" id="telefone" value="Sim" checked="checked">
													Telefone&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
												</label>
												<label>
													<input type="checkbox" name="dataregistro" id="dataregistro" value="Sim" checked="checked">
													Dia do Registro&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
												</label>
												<label>
													<input type="checkbox" name="status" id="status" value="Sim" checked="checked">
													Status&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
												</label>
												<label>
													<input type="checkbox" name="valorfechado" id="valorfechado" value="Sim" checked="checked">
													Qtd. Fechamentos&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
												</label>
												<label>
													<input type="checkbox" name="saldo" id="saldo" value="Sim" checked="checked">
													Saldo&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
												</label>
												<label>
													<input type="checkbox" name="cpf" id="cpf" value="Sim" checked="checked">
													CPF/CNPJ&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
												</label>
												<?php if ($sistema->indicacoes->tipo == Sistema_Indicacoes::FACULDADES) { ?>
													<label>
														<input type="checkbox" name="dataprova" id="dataprova" value="Sim" checked="checked">
														Data da Prova&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
													</label>
													<label>
														<input type="checkbox" name="unidade" id="unidade" value="Sim" checked="checked">
														Unidade&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
													</label>
													<label>
														<input type="checkbox" name="curso" id="curso" value="Sim" checked="checked">
														Curso&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
													</label>
													<label>
														<input type="checkbox" name="cidade" id="cidade" value="Sim" checked="checked">
														Cidade&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
													</label>
													<label>
														<input type="checkbox" name="bairro" id="bairro" value="Sim" checked="checked">
														Bairro&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
													</label>
													<label>
														<input type="checkbox" name="tipocaptador" id="tipocaptador" value="Sim" checked="checked">
														Tipo de Captador&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
													</label>
												<?php } ?>
											</div>
										</div>
									</div>
								</div>
								<div class="box-footer">
									<button type="submit" class="btn btn-primary text-center">Gerar Arquivo</button>
								</div>
							</div>
						</div>
					</form>
				</div>
			</section>
		</div>

		<?php $sistema->layout->exibir_rodape(); ?>
	</div>

	<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/jquery.min.js"></script>
	<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap.min.js"></script>
	<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/adminlte.min.js"></script>
	<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap-datepicker.min.js"></script>
	<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap-datepicker.pt-BR.min.js"></script>
	<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/toastr.min.js"></script>
	<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/jquery.mask.min.js"></script>
	<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/date.js"></script>
	<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/baixar-indicacoes2.0.0.js"></script>

</body>

</html>